/*
 * $Header: /rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC/vpl_dmac_locals.c 5     15/12/24 2:56p Yiming.liu $
 *
 * Copyright 2015-2020 VATICS INC.. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.8.0.4.
 *
 * $History: vpl_dmac_locals.c $
 * 
 * *****************  Version 5  *****************
 * User: Yiming.liu   Date: 15/12/24   Time: 2:56p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 * 
 * *****************  Version 4  *****************
 * User: Yiming.liu   Date: 15/10/16   Time: 5:36p
 * Updated in $/rd_2/project/Rossini/Components/DMAC/Device_Driver/DMAC
 * FEATURE: Generate vpl_dmac device driver by code_gen version 4.8.0.4 -
 * DONE.
 *
 */

/* ============================================================================================== */
#include "vpl_dmac_locals.h"

/* ============================================================================================== */
DWORD VPL_DMAC_GetDevInfoSize(void)
{
	return sizeof(TVPLDMACDevInfo);
}

/* ============================================================================================== */
SCODE VPL_DMAC_SetMMRInfo(HANDLE hDevInfo, volatile TVPLDMACInfo *ptMMRInfo, struct clk *pClk, volatile DWORD *pdwRstEnMmr)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo = ptMMRInfo;
	ptDevInfo->pClk = pClk;
	ptDevInfo->pdwRstEnMmr = pdwRstEnMmr;
	ptDevInfo->dwVersionNum = ptDevInfo->ptMMRInfo->dwVersion;

	if ((ptDevInfo->ptMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptMMRInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VPL_DMAC_GetMMRInfo(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
#ifdef __PROFILE__
SCODE VPL_DMAC_InitProfileInfo(TVPLDMACObjInfo *ptObjInfo)
{
	DWORD dwProfileInfoSize;

	dwProfileInfoSize = sizeof(TVPLDMACProfileInfo);
	if ((ptObjInfo->hProfileInfo=(HANDLE)kmalloc(dwProfileInfoSize, GFP_KERNEL)) == NULL)
	{
		PDEBUG("Allocate profile info buffer fail !!");
		return -ENOMEM;
	}
	memset(ptObjInfo->hProfileInfo, 0, dwProfileInfoSize);

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_DMAC_InitProfile(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD), "VPL_DMAC Profile Clear");
	ptDevInfo->apdwProfileClr[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Bandwidth");
	ptDevInfo->apdwBandwidth[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Request Grant Interval");
	ptDevInfo->apdwRGInterval[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x148+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Request Times");
	ptDevInfo->apdwReqTimes[0] = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x184+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD), "VPL_DMAC Profile Clear");
	ptDevInfo->apdwProfileClr[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Bandwidth");
	ptDevInfo->apdwBandwidth[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x10C+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Request Grant Interval");
	ptDevInfo->apdwRGInterval[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x148+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_DMAC Request Times");
	ptDevInfo->apdwReqTimes[1] = (DWORD *)ioremap((int)(VPL_AHBC_2_MMR_BASE+0x184+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2)), sizeof(DWORD));

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_DMAC_GetProfileInfo(HANDLE hDevInfo, TVPLDMACObjInfo *ptObjInfo, DWORD dwWriteIndex)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;
	TVPLDMACProfileInfo *ptProfileInfo = (TVPLDMACProfileInfo *)ptObjInfo->hProfileInfo;

	ptProfileInfo->adwBandwidth[0] = ptDevInfo->aadwBandwidth[dwWriteIndex][0];
	ptProfileInfo->adwRGInterval[0] = ptDevInfo->aadwRGInterval[dwWriteIndex][0];
	ptProfileInfo->adwReqTimes[0] = ptDevInfo->aadwReqTimes[dwWriteIndex][0];
	ptProfileInfo->adwBandwidth[1] = ptDevInfo->aadwBandwidth[dwWriteIndex][1];
	ptProfileInfo->adwRGInterval[1] = ptDevInfo->aadwRGInterval[dwWriteIndex][1];
	ptProfileInfo->adwReqTimes[1] = ptDevInfo->aadwReqTimes[dwWriteIndex][1];

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_DMAC_CloseProfile(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	if (ptDevInfo->apdwProfileClr[0] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[0] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[0] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[0] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[0]);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VPL_DMAC_MASTER_0_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwProfileClr[1] != NULL)
	{
		iounmap(ptDevInfo->apdwProfileClr[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->apdwBandwidth[1] != NULL)
	{
		iounmap(ptDevInfo->apdwBandwidth[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x10C+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwRGInterval[1] != NULL)
	{
		iounmap(ptDevInfo->apdwRGInterval[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x148+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->apdwReqTimes[1] != NULL)
	{
		iounmap(ptDevInfo->apdwReqTimes[1]);
		release_mem_region(VPL_AHBC_2_MMR_BASE+0x184+((VPL_DMAC_MASTER_1_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_DMAC_SetupProfile(TVPLDMACObjInfo *ptObjInfo, DWORD dwArg, DWORD dwCmd)
{
	TVPLDMACProfileInfo *ptProfileInfo = (TVPLDMACProfileInfo *)ptObjInfo->hProfileInfo;

	switch (dwCmd)
	{
		case VPL_DMAC_IOC_MASTER_0_GET_BANDWIDTH:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[0], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_0_GET_RG_INTERVAL:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[0], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_0_GET_REQ_TIMES:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[0], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_0_CLEAR_PROFILE:
		break;
		case VPL_DMAC_IOC_MASTER_1_GET_BANDWIDTH:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwBandwidth[1], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_1_GET_RG_INTERVAL:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwRGInterval[1], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_1_GET_REQ_TIMES:
			copy_to_user((DWORD *)dwArg, &ptProfileInfo->adwReqTimes[1], sizeof(DWORD));
		break;
		case VPL_DMAC_IOC_MASTER_1_CLEAR_PROFILE:
		break;
		default:
			return S_FAIL;
	}

	return S_OK;
}
#endif //__PROFILE__

/* ============================================================================================== */
DWORD VPL_DMAC_GetVersion(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	return ptDevInfo->ptMMRInfo->dwVersion;
}

/* ============================================================================================== */
DWORD VPL_DMAC_StartHead(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	return ptDevInfo->dwWriteIndex;
}

/* ============================================================================================== */
void VPL_DMAC_StartTail(HANDLE hDevInfo, DWORD dwWriteIndex, TVPLDMACInfo *ptMMRInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->aptMMRInfo[dwWriteIndex] = ptMMRInfo;
	ptDevInfo->dwWriteIndex = (dwWriteIndex+1) & VPL_DMAC_MMR_BUFF_MASK;

	//if ((ptDevInfo->bBusy==FALSE) && (ptDevInfo->dwWriteIndex!=ptDevInfo->dwReadIndex))
	if (!ptDevInfo->bBusy)
	{
		ptDevInfo->bBusy = TRUE;
		clk_enable(ptDevInfo->pClk);

		ptDevInfo->ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl;
		ptDevInfo->ptMMRInfo->dwMaxBurstLength = ptMMRInfo->dwMaxBurstLength;
		ptDevInfo->ptMMRInfo->dwDescriptor = ptMMRInfo->dwDescriptor;
		ptDevInfo->ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;
	}
}

/* ============================================================================================== */
void VPL_DMAC_IntrEnable(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl | 0x00000002;

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VPL_DMAC_IntrDisable(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFD;

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VPL_DMAC_IntrClear(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

	PDEBUG("Interrupt cleared !!\n");
}

/* ============================================================================================== */
void VPL_DMAC_Reset(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	PDEBUG("Enter Reset function...\n");

	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<30);
	ptDevInfo->ptMMRInfo->dwCtrl = (0x1<<30) | 0x00000008;

/* Version 1.0.0.4 modification, 2015.12.24 */
	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr & (~(VPL_DMAC_RST_EN_VALUE<<VPL_DMAC_RST_EN_NUM)); 
	*ptDevInfo->pdwRstEnMmr = *ptDevInfo->pdwRstEnMmr | (VPL_DMAC_RST_EN_VALUE<<VPL_DMAC_RST_EN_NUM);
/* ======================================== */

	while (ptDevInfo->ptMMRInfo->dwVersion != ptDevInfo->dwVersionNum);

	ptDevInfo->ptMMRInfo->dwCtrl = 0x0;

	PDEBUG("Exit Reset function !!\n");
}

/* ============================================================================================== */
void VPL_DMAC_Open(HANDLE hDevInfo)
{
	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	ptDevInfo->bBusy = FALSE;
	ptDevInfo->dwReadIndex = 0;
	ptDevInfo->dwWriteIndex = 0;
}

/* ============================================================================================== */
DWORD VPL_DMAC_ISR(HANDLE hDevInfo)
{
	DWORD dwReadIndex;

	TVPLDMACDevInfo *ptDevInfo = (TVPLDMACDevInfo *)hDevInfo;

	dwReadIndex = ptDevInfo->dwReadIndex;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

#ifdef __PROFILE__
	ptDevInfo->aadwBandwidth[dwReadIndex][0] = *ptDevInfo->apdwBandwidth[0];
	ptDevInfo->aadwRGInterval[dwReadIndex][0] = *ptDevInfo->apdwRGInterval[0];
	ptDevInfo->aadwReqTimes[dwReadIndex][0] = *ptDevInfo->apdwReqTimes[0];
	writel((0x1<<VPL_DMAC_MASTER_0_MASTER_NUM), ptDevInfo->apdwProfileClr[0]);

	ptDevInfo->aadwBandwidth[dwReadIndex][1] = *ptDevInfo->apdwBandwidth[1];
	ptDevInfo->aadwRGInterval[dwReadIndex][1] = *ptDevInfo->apdwRGInterval[1];
	ptDevInfo->aadwReqTimes[dwReadIndex][1] = *ptDevInfo->apdwReqTimes[1];
	writel((0x1<<VPL_DMAC_MASTER_1_MASTER_NUM), ptDevInfo->apdwProfileClr[1]);

#endif //__PROFILE__
	/*if (ptDevInfo->aptMMRInfo[dwReadIndex] != NULL)
	{
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwVersion = ptDevInfo->ptMMRInfo->dwVersion;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCycles = ptDevInfo->ptMMRInfo->dwCycles;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwStat = ptDevInfo->ptMMRInfo->dwStat;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwYSrcAddr = ptDevInfo->ptMMRInfo->dwYSrcAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCbSrcAddr = ptDevInfo->ptMMRInfo->dwCbSrcAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCrSrcAddr = ptDevInfo->ptMMRInfo->dwCrSrcAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwYDstAddr = ptDevInfo->ptMMRInfo->dwYDstAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCbDstAddr = ptDevInfo->ptMMRInfo->dwCbDstAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwCrDstAddr = ptDevInfo->ptMMRInfo->dwCrDstAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwTransSize = ptDevInfo->ptMMRInfo->dwTransSize;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwSrcStride = ptDevInfo->ptMMRInfo->dwSrcStride;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwDstWidth = ptDevInfo->ptMMRInfo->dwDstWidth;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwDstHeight = ptDevInfo->ptMMRInfo->dwDstHeight;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwDstStride = ptDevInfo->ptMMRInfo->dwDstStride;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwFillingConstant00 = ptDevInfo->ptMMRInfo->dwFillingConstant00;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwFillingConstant01 = ptDevInfo->ptMMRInfo->dwFillingConstant01;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwMaskAddr = ptDevInfo->ptMMRInfo->dwMaskAddr;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwMaxBurstLength = ptDevInfo->ptMMRInfo->dwMaxBurstLength;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwAlpha = ptDevInfo->ptMMRInfo->dwAlpha;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwMaskStride = ptDevInfo->ptMMRInfo->dwMaskStride;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwNextDescriptor = ptDevInfo->ptMMRInfo->dwNextDescriptor;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwDescriptor = ptDevInfo->ptMMRInfo->dwDescriptor;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwMaxDistort = ptDevInfo->ptMMRInfo->dwMaxDistort;
		ptDevInfo->aptMMRInfo[dwReadIndex]->dwMcmprObserve = ptDevInfo->ptMMRInfo->dwMcmprObserve;
	}*/


	ptDevInfo->dwReadIndex = (dwReadIndex+1) & VPL_DMAC_MMR_BUFF_MASK;

	if (ptDevInfo->dwReadIndex != ptDevInfo->dwWriteIndex)
	{
		TVPLDMACInfo *ptMMRInfo;
		ptMMRInfo = ptDevInfo->aptMMRInfo[ptDevInfo->dwReadIndex];

		ptDevInfo->ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl;
		ptDevInfo->ptMMRInfo->dwMaxBurstLength = ptMMRInfo->dwMaxBurstLength;
		ptDevInfo->ptMMRInfo->dwDescriptor = ptMMRInfo->dwDescriptor;
		ptDevInfo->ptMMRInfo->dwCtrl = ptMMRInfo->dwCtrl | 0x00000006;
	}
	else
	{
		clk_disable(ptDevInfo->pClk);
		ptDevInfo->bBusy = FALSE;
	}

	return dwReadIndex;
}

/* ============================================================================================== */
