/*
 * $Header: /rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC/vpl_edmc_locals.h 35    15/09/30 4:12p Morgan.chang $
 *
 * Driver for EDMC.
 *
 * Copyright 2006 Vivotek, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Description:
 *
 *  Generated by Code Generator Version 2.2.0.9.
 *
 * $History: vpl_edmc_locals.h $
 * 
 * *****************  Version 36  *****************
 * User: Morgan.chang Date: 16/01/15   Time: 11:47p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. add Schubert/Vienna platform
 * 2. remove dependency of the export of dmac_map_area
 * 
 * *****************  Version 35  *****************
 * User: Morgan.chang Date: 15/09/30   Time: 4:12p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * remove annoying headers of modification
 * 
 * *****************  Version 34  *****************
 * User: Vincent      Date: 15/01/15   Time: 1:19p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. REFINEMENT: include <asm/system.h> for compiling issue with older
 * gcc on Kernel 3.x
 *
 * *****************  Version 33  *****************
 * User: Vincent      Date: 14/12/26   Time: 11:18a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. BUGFIX: move common VPL_SYSC_CHIP_* definition to be platform
 * independent.
 *
 * *****************  Version 32  *****************
 * User: Vincent      Date: 14/12/17   Time: 4:37p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. FEATURE: Support for Genova Platform
 * 2. FEATURE: Add ioctl command, VPL_EDMC_IOC_GET_CHIP_INFO to get chip
 * vendor, ids and version.
 *
 * *****************  Version 31  *****************
 * User: Vincent      Date: 14/09/04   Time: 7:27p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 30  *****************
 * User: Vincent      Date: 14/07/03   Time: 7:37p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 29  *****************
 * User: Morgan.chang Date: 14/02/12   Time: 3:01p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Print more than 1 page data of mappings in /proc/vpl_edmc_maps
 *
 * *****************  Version 28  *****************
 * User: Morgan.chang Date: 13/10/03   Time: 4:21p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Allocate all DRAM memory out of control of kernel to EDMC driver.
 *
 * Since all memory out of kernel's control should be devoted to media
 * usage, edmc driver parses the kernel command line 'mem=' and gets
 * all the left memory.
 * So the module parameter dwMediaMemSize is abandoned !
 *
 * *****************  Version 27  *****************
 * User: Morgan.chang Date: 13/09/26   Time: 11:20a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Support Rosinni.
 *
 * *****************  Version 26  *****************
 * User: Morgan.chang Date: 12/06/19   Time: 11:56a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Fix undefind symbol VPL_EDMC_CTRL_OFFSET for platform Beethoven and
 * Andes.
 *
 * *****************  Version 25  *****************
 * User: Morgan.chang Date: 12/03/30   Time: 4:42p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. REFINEMENT: EDMC bus number is decided by base address set in dram
 * controller which should be identical with slave base address in AHB
 * controller. Should be with Mozart v2 loader with version 12033001 or
 * newer.
 *
 * *****************  Version 24  *****************
 * User: Poplar       Date: 11/12/30   Time: 11:17a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Version 6.0.0.3
 *
 * *****************  Version 23  *****************
 * User: Jon.lin      Date: 11/12/09   Time: 17:44
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * add GPL header
 *
 * *****************  Version 22  *****************
 * User: Jon.lin      Date: 10/12/08   Time: 10:00a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Version 6.0.0.0
 *
 * *****************  Version 21  *****************
 * User: Tassader.chen Date: 10/02/03   Time: 10:56a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 20  *****************
 * User: Poplar       Date: 10/01/30   Time: 6:32p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * 1. FEATURE: Modify the way to caluate the size of DRAM.
 *
 * *****************  Version 19  *****************
 * User: Poplar       Date: 10/01/29   Time: 5:27p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * Version: 5.0.0.12
 *
 * *****************  Version 18  *****************
 * User: Cchuang      Date: 10/01/27   Time: 18:11
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * UPDATE: Update version number from 5.0.0.10 to 5.0.0.11 - DONE.
 *
 * *****************  Version 16  *****************
 * User: Jon.lin      Date: 09/03/30   Time: 5:43p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * fix MMR base
 *
 * *****************  Version 15  *****************
 * User: Jon.lin      Date: 09/03/19   Time: 12:05p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * fix MMR mapping addr
 *
 * *****************  Version 14  *****************
 * User: Jon.lin      Date: 09/03/19   Time: 11:50a
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * for Mozart release
 *
 * *****************  Version 13  *****************
 * User: Ycchang      Date: 07/09/04   Time: 2:35p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 12  *****************
 * User: Jon.lin      Date: 07/08/16   Time: 1:32p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * for 2.6.20.4 kernel porting
 *
 * *****************  Version 11  *****************
 * User: Ycchang      Date: 07/08/16   Time: 12:49p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 10  *****************
 * User: Sor          Date: 06/07/10   Time: 5:31p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * FEATURE: Remove VPL_EDMC_IOC_SET_CACHABLE support, all memory region in
 * system bus will be always cacheable and all memory region in other
 * buses will be always noncacheable - DONE.
 *
 * *****************  Version 9  *****************
 * User: Sor          Date: 06/05/11   Time: 5:49p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * FEATURE: Change VPL_EDMC_IOC_USR_TO_PHY name to
 * VPL_EDMC_IOC_VIRT_TO_PHYS - DONE.
 * FEATURE: Change VPL_EDMC_IOC_PHY_TO_USR name to
 * VPL_EDMC_IOC_PHYS_TO_VIRT - DONE.
 * FEATURE: Add VPL_EDMC_IOC_SET_SHARED_SIZE ioctl option - DONE.
 * FEATURE: Add VPL_EDMC_IOC_CHECK_SHARED_REGION ioctl option - DONE.
 *
 * *****************  Version 8  *****************
 * User: Sor          Date: 06/04/26   Time: 8:55p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * BUG: Virtual memory space of different processes may have overlap, we
 * have to use the process ID to distinguish the virtual address from
 * different processes - FIXED.
 *
 * *****************  Version 7  *****************
 * User: Sor          Date: 06/04/26   Time: 5:31p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * BUG: Incorrect empty memory appending procedure - FIXED.
 * REFINEMENT: Remove useless adwCurrAddr arrag - DONE.
 * BUG: Fragmental memory space search should be moved to
 * VPL_EDMC_IOC_SET_SIZE ioctl option - FIXED.
 *
 * *****************  Version 6  *****************
 * User: Sor          Date: 06/04/26   Time: 2:49p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * REFINEMENT: Support dynamic memory allocation - DONE.
 *
 * *****************  Version 5  *****************
 * User: Sor          Date: 06/04/25   Time: 5:41p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * MODIFICATION: Use dynamic allocation method for TVPLEDMCBlkInfo buffer
 * to remove the limitation of block information number - DONE.
 *
 * *****************  Version 4  *****************
 * User: Sor          Date: 06/04/25   Time: 4:32p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 * MODIFICATION: Add TVPLEDMCObjInfo structure to store private data for
 * each device object - DONE.
 * BUG: Semaphore may be locked if process quit abnormally - FIXED.
 * MODIFICATION: Move table clear-up from Mmap() to Close() - DONE.
 *
 * *****************  Version 3  *****************
 * User: Sor          Date: 06/04/19   Time: 4:01p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 2  *****************
 * User: Sor          Date: 06/04/19   Time: 3:52p
 * Updated in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 * *****************  Version 1  *****************
 * User: Sor          Date: 06/04/19   Time: 3:39p
 * Created in $/rd_2/project/SoC/Components/EDMC/Device_Driver/EDMC
 *
 */

/* ============================================================================================== */
#ifndef __VPL_EDMC_LOCALS_H__
#define __VPL_EDMC_LOCALS_H__

#include <linux/interrupt.h>
#include <linux/mm.h>
#include <linux/mman.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/ioctl.h>
#include <linux/device.h>
#include <linux/list.h>
#include <linux/fs.h>
#include <linux/syscalls.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/setup.h>
#include <asm/system.h>
#include <asm/cacheflush.h>
#include <linux/dma-mapping.h>
#include <mach/platform.h>
#include "typedef.h"
#include "vpl_edmc.h"

#undef PDEBUG
#ifdef _DEBUG
    #ifdef __KERNEL__
        #define LOGLEVEL KERN_DEBUG
        #define PDEBUG(fmt, args...) printk(LOGLEVEL "VPL_EDMC: " fmt, ## args)
    #else
        #define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
    #endif
#else
    #define PDEBUG(fmt, args...)
#endif

/* Platform dependent configurations */
#if defined (__ASM_ARCH_PLATFORM_GENOVA_H__)
#define __ASM_ARCH_PLATFORM_PESARO_H__
#endif

#ifdef __ASM_ARCH_PLATFORM_PESARO_H__
    #define VPL_EDMC_BUS_NUM                        1
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR        VPL_DDRSDMC_0_MMR_BASE
    #define VPL_EMDC_BUSES \
        VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR
    #define VPL_EDMC_CTRL_OFFSET                    0x04
    #define VPL_EDMC_CFG_OFFSET                     0x0C
#endif //__ASM_ARCH_PLATFORM_PESARO_H__

#if defined (__ASM_ARCH_PLATFORM_ANDES_H__)| defined(__ASM_ARCH_PLATFORM_BEETHOVEN_H__)
    #define VPL_EDMC_BUS_NUM                        4
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR        VPL_DDRSDMC_0_MMR_BASE
    #define VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR        VPL_DDRSDMC_1_MMR_BASE
    #define VPL_EDMC_BUS_2_CTRL_MMR_BASEADDR        VPL_DDRSDMC_2_MMR_BASE
    #define VPL_EDMC_BUS_3_CTRL_MMR_BASEADDR        VPL_DDRSDMC_3_MMR_BASE
    #define VPL_EMDC_BUSES \
        VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR, \
        VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR, \
        VPL_EDMC_BUS_2_CTRL_MMR_BASEADDR, \
        VPL_EDMC_BUS_3_CTRL_MMR_BASEADDR
    #define VPL_EDMC_CTRL_OFFSET                    0x04
    #define VPL_EDMC_CFG_OFFSET                     0x0C
#endif //__ASM_ARCH_PLATFORM_ANDES_H__ __ASM_ARCH_PLATFORM_BEETHOVEN_H__

#ifdef __ASM_ARCH_PLATFORM_MOZART_H__
    #define VPL_EDMC_BUS_NUM                        2
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR        VPL_DDRSDMC_0_MMR_BASE
    #define VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR        VPL_DDRSDMC_1_MMR_BASE
    #define VPL_EMDC_BUSES \
        VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR, \
        VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR
    #define VPL_EDMC_CTRL_OFFSET                    0x04
    #define VPL_EDMC_CFG_OFFSET                     0x0C
    #define VPL_SYSC_CHIP_SUBTYPE                   0x3c
#endif //__ASM_ARCH_PLATFORM_MOZART_H__

#ifdef __ASM_ARCH_PLATFORM_HAYDN_H__
    #define MEDIA_MEM_SIZE
    #define VPL_EDMC_BUS_NUM                    2
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR    0x98100000
    #define VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR    0x18100000
    #define VPL_EDMC_CFG_OFFSET                 0x0C
#endif //__ASM_ARCH_PLATFORM_HAYDN_H__

#ifdef __ASM_ARCH_PLATFORM_BACH_H__
    #define MEDIA_MEM_SIZE
    #define VPL_EDMC_BUS_NUM                    3
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR    0x90200000
    #define VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR    0x90A00000
    #define VPL_EDMC_BUS_2_CTRL_MMR_BASEADDR    0x90B00000
    #define VPL_EDMC_CFG_OFFSET                 0x10
#endif //__ASM_ARCH_PLATFORM_BACH_H__
#ifdef __ASM_ARCH_PLATFORM_HANDEL_H__
    #define MEDIA_MEM_SIZE
    #define VPL_EDMC_BUS_NUM                    3
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR    0x90200000
    #define VPL_EDMC_BUS_1_CTRL_MMR_BASEADDR    0x90A00000
    #define VPL_EDMC_BUS_2_CTRL_MMR_BASEADDR    0x90B00000
    #define VPL_EDMC_CFG_OFFSET                 0x10
#endif //__ASM_ARCH_PLATFORM_HANDEL_H__
#ifdef __ASM_ARCH_PLATFORM_VIVALDI_H__
    #define MEDIA_MEM_SIZE
    #define VPL_EDMC_BUS_NUM                    1
    #define VPL_EDMC_BUS_0_CTRL_MMR_BASEADDR    0x90300000
    #define VPL_EDMC_BANK_0_CFG_OFFSET          0x10
    #define VPL_EDMC_BANK_1_CFG_OFFSET          0x14
#endif //__ASM_ARCH_PLATFORM_VIVALDI_H__

    #define VPL_SYSC_CHIP_VENDOR_ID                 0x04
    #define VPL_SYSC_CHIP_ID0                       0x08
    #define VPL_SYSC_CHIP_ID1                       0x0C
    #define VPL_SYSC_CHIP_ID2                       0x10
    #define VPL_SYSC_CHIP_VERSION                   0x14

#ifdef CONFIG_SYSFS
#define EXPORT_STAT_BY_SYSFS
#endif //CONFIG_SYSFS

#ifdef CONFIG_PROC_FS
#define EXPORT_STAT_BY_SEQ_FILE
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#define MAP_FILE_IN_PROC   "vpl_edmc_maps"
#endif

/* Make EDMC driver to use upper memory regions more likely. */
/* This is NOT necessary, but it can make the map more neat and easy to read. */
#define HINT_VIRTUAL_ADDR

/* Russell King has changed the type of DMA cache handling
 * functions' arguments from 'unsigned long' to 'const void *' since 2.6.21.
 * Ref. http://www.mail-archive.com/git-commits-head@vger.kernel.org/msg06899.html
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,21)
typedef const void * vma_ptr_t;
#else
typedef unsigned long vma_ptr_t;
#endif

typedef struct vpl_edmc_blk_info
{
	struct list_head    node;

	DWORD dwVirtLowerAddr;
	DWORD dwVirtUpperAddr;
	DWORD dwPhysLowerAddr;
	DWORD dwPhysUpperAddr;

	DWORD dwOffset;

	struct file         *pfile;
	struct mm_struct    *mm;
	DWORD dwTag;
} TVPLEDMCBlkInfo;

typedef struct vpl_edmc_obj_info
{
	BOOL bLock;
	pid_t   tgid;
} TVPLEDMCObjInfo;


typedef struct vpl_edmc_dev_info
{
#ifdef VPL_EDMC_QUERY_EDMCMAPPED_ONLY
	struct inode *dev_inode;
#endif //VPL_EDMC_QUERY_EDMCMAPPED_ONLY
	DWORD adwBaseAddr[VPL_EDMC_BUS_NUM];
	DWORD adwSize[VPL_EDMC_BUS_NUM];

	DWORD dwReqBusNum;
	DWORD dwReqSize;
	DWORD dwReqAddr;
	DWORD dwAlignMask;
	struct list_head    *plReqNext;

	BOOL bShared;

	struct list_head    lRegularBlk;
	struct list_head    lSharedBlk;

	struct semaphore sem;
	struct mutex ioctl_lock;
#ifdef VPL_SYSC_CHIP_SUBTYPE
	DWORD   dwChipSubType;
#endif //VPL_SYSC_CHIP_SUBTYPE
} TVPLEDMCDevInfo;

extern unsigned long edmc_query_phys(unsigned long virt_addr, struct file *filp, unsigned long *size, unsigned long *offset);
#endif //__VPL_EDMC_LOCALS_H__
