/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#ifndef __VPL_HDMITC_H__
#define __VPL_HDMITC_H__

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/dmaengine.h>
#include <linux/init.h>
#include <linux/kthread.h>
#include <linux/module.h>
#include <linux/gfp.h>
#include <linux/random.h>
#include <linux/interrupt.h>
#include <linux/videodev2.h>
#include <mach/platform.h>
#include <asm/sizes.h>

#include "vpl_hdmitc_regs.h"

#define VPL_HDMITC_VERSION MAKEFOURCC(1, 0, 0, 0)
#define VPL_HDMITC_ID_VERSION "1.0.0.0"

#define OTUS_MODIFY
#define HDMI_1080I_60FPS
//#define POLLING_HPD

typedef enum {
	RGB,
	YUV444,
	YUV422,
} pixel_fm_t;

struct hw_config_cap {
	/* config0_id */
	u32 prepen;
	u32 audspdif;
	u32 audi2s;
	u32 hdmi14;
	u32 csc;
	u32 cec;
	u32 hdcp;
	/* config1_id */
	u32 confapb;
	/* config2_id */
	u32 phytype;
	/* config3_id */
	u32 confahbauddma;
	u32 confgpaud;
};

struct csc_coeff {
	u16 matrix[3][3];
	u16 offset[3];
	u16 scale;
};

struct display_timing
{
	u32 vic_code;
	u32 pixelrep;
	u32 interlaced;

	u32 HActive;
	u32 HBlank;
	u32 HSyncFront; /*H Sync delay*/
	u32 HSyncWidth;

	u32 VActive;
	u32 VBlank;
	u32 VSyncFront; /*V Sync delay*/
	u32 VSyncWidth;

	u32 HSyncPol;
	u32 VSyncPol;

};

struct vpl_hdmitc_video {
	u32 hdmi_mode;
	pixel_fm_t InputColor;
	pixel_fm_t OutputColor;
	u32 pix_repetition;
};

struct vpl_hdmitc_info {
	void __iomem *base;
	struct hw_config_cap hw_cap;
	struct delayed_work edid_work; /* interrupt bh for edid read */
	struct vpl_hdmitc_video video_param;
#ifdef OTUS_MODIFY
	u8     connected;
	struct proc_dir_entry* proc_dir;
#endif
};

/* ============================================================================================== */
#define hdmitc_set_field(old, val, mask) ((val & mask) | (old & ~mask))

static inline void hdmitc_writel(struct vpl_hdmitc_info *hdmi, u32 val, u32 reg)
{
	writel(val, hdmi->base + (reg << 2));
	//printk("	write %04x: %02x\n", reg, val);
}

static inline u32 hdmitc_readl(struct vpl_hdmitc_info *hdmi, u32 reg)
{
	return readl(hdmi->base + (reg << 2));
}

static inline void hdmitc_writel_mask(struct vpl_hdmitc_info *hdmi, u32 val, u32 reg, u32 mask)
{
	u32 old = readl(hdmi->base + (reg << 2));
	val = (val & mask) | (old & ~mask);
	writel(val, hdmi->base + (reg << 2));
	//printk("	write %04x: %02x\n", reg, val);
}

static inline void hdmitc_set_bit(struct vpl_hdmitc_info *hdmi, u32 reg, u32 mask)
{
	u32 old = readl(hdmi->base + (reg << 2));
	old |= (0xFF & mask);
	writel(old, hdmi->base + (reg << 2));
	printk("	write %04x: %02x\n", reg, old);
}

static inline void hdmitc_clear_bit(struct vpl_hdmitc_info *hdmi, u32 reg, u32 mask)
{
	u32 old = readl(hdmi->base + (reg << 2));
	old &= (~mask);
	writel(old, hdmi->base + (reg << 2));
	printk("	write %04x: %02x\n", reg, old);
}
/* ============================================================================================== */
void hdmitc_dbgvideo(struct vpl_hdmitc_info *hdmitc_info, u32 enable);
void hdmitc_phy_init(struct vpl_hdmitc_info *hdmitc_info);
void hdmitc_phy_configure(struct vpl_hdmitc_info *hdmitc_info);
void edid_init(struct vpl_hdmitc_info *hdmitc_info);
void hdmitc_video_csc(struct vpl_hdmitc_info *hdmitc_info);
void hdmitc_cec_init(struct vpl_hdmitc_info *hdmitc_info, u32 phy_addr);
void cec_int_handle(struct vpl_hdmitc_info *hdmitc_info);
#endif //__VPL_HDMITC_H__
