/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#include "vpl_hdmitc.h"

#define CEC_MAJOR 0
#define CEC_BLOCK_NUM 16

enum {
	CEC_TV			= 0,
	CEC_RECORDING_DEVICE	= 1,
	CEC_TUNER		= 3,
	CEC_PLAYBACK_DEVICE	= 4,
	CEC_AUDIO_SYSTEM	= 5,
	CEC_PURE_SWITCH		= 6,
	CEC_VIDEO_PROCESSOR	= 7,
};

static u16 device_type_addr[] = {
	[CEC_TV]		= 0x0001,
	[CEC_RECORDING_DEVICE]	= 0x8206,
	[CEC_TUNER]		= 0x84C8,
	[CEC_PLAYBACK_DEVICE]	= 0x8910,
	[CEC_AUDIO_SYSTEM]	= 0x8020
};

struct cec_dev {
	u32 device_type;
	u32 physical_addr;  /*read from sink EDID Vender Specified Block*/
	u32 logical_addr; /* TODO: by type? */
};

struct cec_dev device;
#if 0


u32 type_la_mask[5] = {
#define TV_LOGICAL_MASK		(1 << 0)
#define RECORDING_LOGICAL_MASK	(1<<1 | 1<<2 | 1<<9)
#define TUNER_LOGICAL_MASK	(1<<3 | 1<<6 | 1<<7 | 1<<10)
#define PLAYBACK_LOGICAL_MASK	(1<<4 | 1<<8 | 1<<11)
#define AUDIO_LOGICAL_MASK	(1<<5)
}
struct messag {
	buf[CEC_BLOCK_NUM];
	len;
};



void hdmitc_cec_standby(struct vpl_hdmitc_info *hdmitc_info)
{
	hdmitc_writel(hdmitc_info, 0x7F ,HDMITC_CEC_MASK); /*mask all*/
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_IH_CEC_STAT0, IH_CEC_STAT0_WAKEUP); /*clear wakeup int*/
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_CEC_MASK, CEC_MASK_WAKEUP); /*unmask wakeup int*/
	hdmitc_writel_mask(hdmitc_info, CEC_CTRL_STANDBY, HDMITC_CEC_CTRL, CEC_CTRL_STANDBY);
}

static void hdmitc_cec_sendmsg()
{
	struct message msg;
	int i;
	msg.buf[0] = (logical_address[type] << 4) |  (dist&0xF);

	for (i = 0; i < msg.len; i++) {

	}
}


int sendMessage(u8 *buf, u32 len, u8 type, u8 dst, u32 retry)
{
	u32 i;
	u8 src =  getlogicalbydevice(type);

	writel(hdmitc_info, (1 << src), HDMITC_CEC_ADDR_H);
	writel(hdmitc_info, ((1 << src) >> 8), HDMITC_CEC_ADDR_H);

	buf[0] = (src << 4) | (dst & 0xF);
	for (i = 0; i < retry; i++) {
		if (i == 0)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_7BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);
		else (if i == 1)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_5BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);
	}

	tx_buf(buf[0], len);


	return i;
}
#endif
static int rx(struct vpl_hdmitc_info *hdmitc_info, u8 *data, u32 size)
{
	int count;
	int i;
	count = hdmitc_readl(hdmitc_info, HDMITC_CEC_RX_CNT);
	count = (count > size) ? size : count;

	for (i =0; i < count; i++) {
		data[i] = hdmitc_readl(hdmitc_info, HDMITC_CEC_RX_DATA0+i);
		printk("%02x", data[i]);
	}
	printk("\n");
	return count;
}
int cec_sendosdname(struct vpl_hdmitc_info *hdmitc_info);
void cec_int_handle(struct vpl_hdmitc_info *hdmitc_info)
{
	u32 ih_cec_stat0;
	u32 rx_locked;
	u8 rx_buf[16];
	ih_cec_stat0 = hdmitc_readl(hdmitc_info, HDMITC_IH_CEC_STAT0);

	/* There is Rx EOM */
	/* TODO, read to global output buffer ring, skip pin(len==1) */
	if (ih_cec_stat0 & IH_CEC_STAT0_EOM) {
		printk("CEC EOM INT\n");
		rx_locked = hdmitc_readl(hdmitc_info, HDMITC_CEC_LOCK);
		if (rx_locked) {
			rx(hdmitc_info, rx_buf, 16);
			hdmitc_writel(hdmitc_info, 0, HDMITC_CEC_LOCK);
			hdmitc_writel_mask(hdmitc_info, IH_CEC_STAT0_EOM | IH_CEC_STAT0_ERR_FOLL, HDMITC_IH_CEC_STAT0, IH_CEC_STAT0_EOM | IH_CEC_STAT0_ERR_FOLL);
		}
		if (rx_buf[1] == 0x46) {
			printk("source request osd\n");
			cec_sendosdname(hdmitc_info);
		}

	}

	/* The Tx done */
	if (ih_cec_stat0 & IH_CEC_STAT0_DONE) {
		printk("CEC DONE INT\n");
	}

	if (ih_cec_stat0 & IH_CEC_STAT0_NACK) {
		printk("CEC NACK\n");
	}

	if (ih_cec_stat0 & IH_CEC_STAT0_ERR_FOLL) {
		printk("CEC ERR_FOLL\n");
	}

	if (ih_cec_stat0 & IH_CEC_STAT0_ERR_INIT) {
		printk("CEC ERR_INIT\n");
	}

	if (ih_cec_stat0 & IH_CEC_STAT0_WAKEUP) {
		printk("CEC WAKEUP\n");
		hdmitc_writel_mask(hdmitc_info, 0xF, HDMITC_IH_CEC_STAT0, IH_CEC_STAT0_WAKEUP);
	}

	if (ih_cec_stat0 & IH_CEC_STAT0_ARB_LOST) {
		printk("CEC ARB_LOST\n");
	}


	/* clear interrupt at separte operation by requirement */

}
#if 0
static struct file_operations cec_fops =
{
	.owner = THIS_MODULE,
/*
	.ioctl = CECdev_ioctl,
	.write = CECdev_write,
	.read  = CECdev_read,
	.poll  = CECdev_poll,
	.open  = CECdev_open,
	.release  = CECdev_close
*/
};
#endif
static int tx_buf(struct vpl_hdmitc_info *hdmitc_info, u8 *data, u32 size)
{
	int i;
	if(size > CEC_BLOCK_NUM)
		return -1;

	hdmitc_writel(hdmitc_info, size, HDMITC_CEC_TX_CNT);
	for (i = 0; i < size; i++) {
		hdmitc_writel(hdmitc_info, data[i], HDMITC_CEC_TX_DATA0+i);
	}
	return i;
}

static int cec_send_busy_wait(struct vpl_hdmitc_info *hdmitc_info)
{
	unsigned long curr;
	unsigned long finish = jiffies + HZ;

	do {
		curr = jiffies;
		if (hdmitc_readl(hdmitc_info, HDMITC_CEC_CTRL) & CEC_CTRL_SEND) {
			cpu_relax();
		}
		else
			return 0;
	} while (!time_after_eq(curr, finish));
	printk("DAMN, CEC send not done\n");
	return -EBUSY;
}

int cec_ping(struct vpl_hdmitc_info *hdmitc_info)
{
	u32 i;
	u8 src =  device.logical_addr;
	u32 retry = 5;
	u8 buf[1];
	u32 int_status;
	hdmitc_writel(hdmitc_info, 0x00, HDMITC_CEC_ADDR_L);
	hdmitc_writel(hdmitc_info, 0x80, HDMITC_CEC_ADDR_H);
//	hdmitc_writel(hdmitc_info, (1<<src)&0xFF, HDMITC_CEC_ADDR_L);
//	hdmitc_writel(hdmitc_info, ((1<<src)>>8)&0xFF, HDMITC_CEC_ADDR_H);
	printk(" CEC ping\n");
	buf[0] = (src << 4) | (src & 0xF);
	tx_buf(hdmitc_info, buf, 1);

	for (i = 0; i < retry; i++) {
		if (i == 0)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_7BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);
		else if (i == 1)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_5BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);

		hdmitc_writel(hdmitc_info, IH_CEC_STAT0_DONE |
				                IH_CEC_STAT0_NACK |
				                IH_CEC_STAT0_ARB_LOST |
						IH_CEC_STAT0_ERR_FOLL |
						IH_CEC_STAT0_ERR_INIT,
						HDMITC_IH_CEC_STAT0);
		hdmitc_writel_mask(hdmitc_info, CEC_CTRL_SEND, HDMITC_CEC_CTRL, CEC_CTRL_SEND);

		if (cec_send_busy_wait(hdmitc_info) < 0)
			return -EBUSY;
		int_status = hdmitc_readl(hdmitc_info, HDMITC_IH_CEC_STAT0);
		if ((int_status & ( IH_CEC_STAT0_NACK | IH_CEC_STAT0_ARB_LOST | IH_CEC_STAT0_ERR_FOLL | IH_CEC_STAT0_ERR_INIT)) == 0) {
			printk("send done %x\n", int_status);
			return 0;
		}

		if (int_status & IH_CEC_STAT0_NACK) {
			return EBUSY;
		}
		printk("send fail %x\n", int_status);
	}

	return EAGAIN;
}

int cec_report_physical_address(struct vpl_hdmitc_info *hdmitc_info, u32 phy_addr)
{
	u8 buf[5];
	u8 src =  device.logical_addr;
	u32 retry = 5;
	u32 i;
	u32 int_status;
	hdmitc_writel(hdmitc_info, (1<<src)&0xFF, HDMITC_CEC_ADDR_L);
	hdmitc_writel(hdmitc_info, ((1<<src)>>8)&0xFF, HDMITC_CEC_ADDR_H);
	printk(" CEC write normal\n");
	buf[0] = (src << 4) | 0xF;
	buf[1] = 0x84;
	buf[2] = phy_addr>>8;
	buf[3] = phy_addr;
	buf[4] = CEC_PLAYBACK_DEVICE;
	tx_buf(hdmitc_info, buf, 5);

	for (i = 0; i < retry; i++) {
		if (i == 0)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_7BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);
		else if (i == 1)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_5BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);

		hdmitc_writel(hdmitc_info, IH_CEC_STAT0_DONE |
				                IH_CEC_STAT0_NACK |
				                IH_CEC_STAT0_ARB_LOST |
						IH_CEC_STAT0_ERR_FOLL |
						IH_CEC_STAT0_ERR_INIT,
						HDMITC_IH_CEC_STAT0);
		hdmitc_writel_mask(hdmitc_info, CEC_CTRL_SEND, HDMITC_CEC_CTRL, CEC_CTRL_SEND);

		if (cec_send_busy_wait(hdmitc_info) < 0)
			return -EBUSY;
		int_status = hdmitc_readl(hdmitc_info, HDMITC_IH_CEC_STAT0);
		if ((int_status & ( IH_CEC_STAT0_NACK | IH_CEC_STAT0_ARB_LOST | IH_CEC_STAT0_ERR_FOLL | IH_CEC_STAT0_ERR_INIT)) == 0) {
			printk("send done\n");
			return 0;
		}
		printk("send fail %x\n", int_status);
	}

	return -EBUSY;

}

int cec_sendosdname(struct vpl_hdmitc_info *hdmitc_info)
{
	u8 buf[8];
	u8 src =  device.logical_addr;
	u32 retry = 5;
	u32 i;
	u32 int_status;
	hdmitc_writel(hdmitc_info, (1<<src)&0xFF, HDMITC_CEC_ADDR_L);
	hdmitc_writel(hdmitc_info, ((1<<src)>>8)&0xFF, HDMITC_CEC_ADDR_H);
	printk(" CEC write normal\n");
	buf[0] = (src << 4) | 0x0;
	buf[1] = 0x47;
	buf[2] = 'V';
	buf[3] = 'A';
	buf[4] = 'T';
	buf[5] = 'I';
	buf[6] = 'C';
	buf[7] = 'S';
	tx_buf(hdmitc_info, buf, 8);

	for (i = 0; i < retry; i++) {
		if (i == 0)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_7BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);
		else if (i == 1)
			hdmitc_writel_mask(hdmitc_info, CEC_CTRL_FRAME_TYPE_5BP, HDMITC_CEC_CTRL, CEC_CTRL_FRAME_TYPE_MASK);

		hdmitc_writel(hdmitc_info, IH_CEC_STAT0_DONE |
				                IH_CEC_STAT0_NACK |
				                IH_CEC_STAT0_ARB_LOST |
						IH_CEC_STAT0_ERR_FOLL |
						IH_CEC_STAT0_ERR_INIT,
						HDMITC_IH_CEC_STAT0);
		hdmitc_writel_mask(hdmitc_info, CEC_CTRL_SEND, HDMITC_CEC_CTRL, CEC_CTRL_SEND);

		if (cec_send_busy_wait(hdmitc_info) < 0)
			return -EBUSY;
		int_status = hdmitc_readl(hdmitc_info, HDMITC_IH_CEC_STAT0);
		if ((int_status & ( IH_CEC_STAT0_NACK | IH_CEC_STAT0_ARB_LOST | IH_CEC_STAT0_ERR_FOLL | IH_CEC_STAT0_ERR_INIT)) == 0) {
			printk("send done\n");
			return 0;
		}
		printk("send fail %x\n", int_status);
	}

	return -EBUSY;

}

static void cec_allocate_logical_address(struct vpl_hdmitc_info *hdmitc_info, u32 phy_addr)
{
	u16 allowed = device_type_addr[CEC_PLAYBACK_DEVICE];
	u8 i;
	u8 ret = 0;
	/* Allocate the logical address */
	for (i = 0; i < 0xF; i++) {
		if (allowed & (1<<i)) {
			device.logical_addr = i;
			if ((ret = cec_ping(hdmitc_info)) == EBUSY)
				break;
		}
	}
	if (ret == EBUSY) {
		printk("NACK at logical address %d\n", device.logical_addr);
		/* report physical */
		cec_report_physical_address(hdmitc_info, phy_addr);
	} else {
		printk("damn can't send correctly\n");
	}

}


void hdmitc_cec_init(struct vpl_hdmitc_info *hdmitc_info, u32 phy_addr)
{
//	if (register_chrdev(CEC_MAJOR, "hdmicec",&cec_fops) < 0)
//		printk("[CEC] unable to get major %d for CEC\n", CEC_MAJOR);
//	hdmitc_writel(hdmitc_info, 0xBF, HDMITC_MC_SWRSTZREQ);

//	hdmitc_writel_mask(hdmitc_info, 0xFF, HDMITC_MC_CLKDIS, MC_CLKDIS_CECCLK);
//	hdmitc_writel_mask(hdmitc_info, 0x0, HDMITC_MC_CLKDIS, MC_CLKDIS_CECCLK);
//	hdmitc_writel_mask(hdmitc_info, 0xFF, HDMITC_MC_CLKDIS, MC_CLKDIS_CECCLK);
//	hdmitc_writel_mask(hdmitc_info, 0x0, HDMITC_MC_CLKDIS, MC_CLKDIS_CECCLK);

	printk("    cec init %x\n", hdmitc_readl(hdmitc_info, HDMITC_MC_SWRSTZREQ));
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_CEC_CTRL, CEC_CTRL_STANDBY);
	hdmitc_writel(hdmitc_info, 0x7F ,HDMITC_CEC_MASK); /* mask all*/
	hdmitc_writel(hdmitc_info, 0x7F, HDMITC_IH_CEC_STAT0); /* clear all int */
	hdmitc_writel(hdmitc_info, 0, HDMITC_CEC_LOCK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_CEC_MASK, IH_CEC_STAT0_EOM | IH_CEC_STAT0_NACK |
			                               IH_CEC_STAT0_ARB_LOST | IH_CEC_STAT0_ERR_FOLL |
						       IH_CEC_STAT0_ERR_INIT | IH_CEC_STAT0_WAKEUP);

	hdmitc_writel(hdmitc_info, IH_CEC_STAT0_NACK | IH_CEC_STAT0_ARB_LOST | IH_CEC_STAT0_ERR_FOLL | IH_CEC_STAT0_ERR_INIT, HDMITC_IH_MUTE_CEC_STAT0);


	cec_allocate_logical_address(hdmitc_info, phy_addr);

}
