/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */

#include "vpl_hdmitc.h"

static struct csc_coeff csc_bypass = {
	{  /* CSC Coef Matrix*/
		{0x2000, 0x0000, 0x0000},
		{0x0000, 0x2000, 0x0000},
		{0x0000, 0x0000, 0x2000}
	}, /* CSC Offset*/
	{0x0000, 0x0000, 0x0000},
	1
};

static struct csc_coeff csc_ITU601_YUV2RGB = {
	{  /* CSC Coef Matrix*/
		{0x2000, 0x6926, 0x74fd},
		{0x2000, 0x2cdd, 0x0000},
		{0x2000, 0x0000, 0x38b4}
	}, /* CSC Offset*/
	{0x010e, 0x7e9a, 0x7e3b},
	1
};

static struct csc_coeff csc_ITU709_YUV2RGB = {
	{  /* CSC Coef Matrix*/
		{0x2000, 0x7106, 0x7a02},
		{0x2000, 0x3264, 0x0000},
		{0x2000, 0x0000, 0x3b61}
	}, /* CSC Offset*/
	{0x00a7, 0x7e6d, 0x7e25},
	1
};

static struct csc_coeff csc_ITU601_RGB2YUV = {
	{  /* CSC Coef Matrix*/
		{0x2591, 0x1322, 0x074b},
		{0x6535, 0x2000, 0x7acc},
		{0x6acd, 0x7534, 0x2000}
	}, /* CSC Offset*/
	{0x0000, 0x0200, 0x0200},
	0
};

static struct csc_coeff csc_ITU709_RGB2YUV = {
	{  /* CSC Coef Matrix*/
		{0x2dc5, 0x0d9b, 0x049e},
		{0x62f0, 0x2000, 0x7d11},
		{0x6756, 0x78ab, 0x2000}
	}, /* CSC Offset*/
	{0x0000, 0x0200, 0x0200},
	0
};

/* ============================================================================================== */
static void hdmitc_video_csc_coeff(struct vpl_hdmitc_info *hdmitc_info, struct csc_coeff *coef)
{
	/* Matrix A1~A3 */
	hdmitc_writel(hdmitc_info, coef->matrix[0][0], HDMITC_CSC_COEF_A1_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[0][0] >> 8), HDMITC_CSC_COEF_A1_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[0][1], HDMITC_CSC_COEF_A2_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[0][1] >> 8), HDMITC_CSC_COEF_A2_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[0][2], HDMITC_CSC_COEF_A3_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[0][2] >> 8), HDMITC_CSC_COEF_A3_MSB);
	/* Matrix B1~B3 */
	hdmitc_writel(hdmitc_info, coef->matrix[1][0], HDMITC_CSC_COEF_B1_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[1][0] >> 8), HDMITC_CSC_COEF_B1_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[1][1], HDMITC_CSC_COEF_B2_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[1][1] >> 8), HDMITC_CSC_COEF_B2_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[1][2], HDMITC_CSC_COEF_B3_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[1][2] >> 8), HDMITC_CSC_COEF_B3_MSB);
	/* Matrix C1~C3 */
	hdmitc_writel(hdmitc_info, coef->matrix[2][0], HDMITC_CSC_COEF_C1_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[2][0] >> 8), HDMITC_CSC_COEF_C1_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[2][1], HDMITC_CSC_COEF_C2_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[2][1] >> 8), HDMITC_CSC_COEF_C2_MSB);
	hdmitc_writel(hdmitc_info, coef->matrix[2][2], HDMITC_CSC_COEF_C3_LSB);
	hdmitc_writel(hdmitc_info, (coef->matrix[2][2] >> 8), HDMITC_CSC_COEF_C3_MSB);
	/* Offset A4,B4,C4 */
	hdmitc_writel(hdmitc_info, coef->offset[0], HDMITC_CSC_COEF_A4_LSB);
	hdmitc_writel(hdmitc_info, (coef->offset[0] >> 8), HDMITC_CSC_COEF_A4_MSB);
	hdmitc_writel(hdmitc_info, coef->offset[1], HDMITC_CSC_COEF_B4_LSB);
	hdmitc_writel(hdmitc_info, (coef->offset[1] >> 8), HDMITC_CSC_COEF_B4_MSB);
	hdmitc_writel(hdmitc_info, coef->offset[2], HDMITC_CSC_COEF_C4_LSB);
	hdmitc_writel(hdmitc_info, (coef->offset[2] >> 8), HDMITC_CSC_COEF_C4_MSB);
	/* Scale */
	hdmitc_writel_mask(hdmitc_info, coef->scale, HDMITC_CSC_SCALE, CSC_SCALE_SCALE_MASK);
}

/* ============================================================================================== */
void hdmitc_video_csc(struct vpl_hdmitc_info *hdmitc_info)
{
	pixel_fm_t input = hdmitc_info->video_param.InputColor;
	pixel_fm_t output = hdmitc_info->video_param.OutputColor;
	u32 colorspace = V4L2_COLORSPACE_REC709;//V4L2_COLORSPACE_SMPTE170M;
	u32 cfg = 0;
	struct csc_coeff *coef = &csc_bypass;
	printk("    Color Space Conversion\n");
	if (input != output) {
		/* interpolation */
		if ((input == YUV422) && (output == YUV444 || output == RGB)) {
			printk("interpolation\n");
			cfg |= (0x01 << 4);
		}
		/* decimation */
		if ((input == YUV444 || input == RGB) && (output == YUV422)) {
			printk("decimation\n");
			cfg |= (0x01 << 0);
		}
		hdmitc_writel(hdmitc_info, cfg, HDMITC_CSC_CFG);
		/* color space conversion */
		if (output == RGB) {
			printk("out rgb\n");
			if (colorspace == V4L2_COLORSPACE_REC709)
				coef = &csc_ITU709_YUV2RGB;
			else
				coef = &csc_ITU601_YUV2RGB;
		}

		if (input == RGB) {
			printk("out yuv\n");
			if (colorspace == V4L2_COLORSPACE_REC709)
				coef = &csc_ITU709_RGB2YUV;
			else
				coef = &csc_ITU601_RGB2YUV;
		}
		hdmitc_video_csc_coeff(hdmitc_info, coef);
		/* color depth*/
		hdmitc_writel_mask(hdmitc_info, CSC_SCALE_COLOR_DEPTH_24, HDMITC_CSC_SCALE, CSC_SCALE_COLOR_DEPTH_MASK);
		/* enable path and clock gate */
		hdmitc_writel(hdmitc_info, 1, HDMITC_MC_FLOWCTRL);
		hdmitc_writel_mask(hdmitc_info, 0, HDMITC_MC_CLKDIS, MC_CLKDIS_CSCCLK);
	} else {
		/* disable path and clock gate*/
		hdmitc_writel(hdmitc_info, 0, HDMITC_MC_FLOWCTRL);
		hdmitc_writel_mask(hdmitc_info, ~MC_CLKDIS_CSCCLK, HDMITC_MC_CLKDIS, MC_CLKDIS_CSCCLK);
	}
}
