/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */

#include "vpl_hdmitc.h"

void hdmitc_dbgaudio(struct vpl_hdmitc_info *hdmitc_info, u32 enable)
{
	/* DON'T CARE NOW */
}

void hdmitc_dbgvideo(struct vpl_hdmitc_info *hdmitc_info, u32 enable)
{
	/* avoid glitches */
	if (enable)
	{
		printk("    enable debug video: blue screen\n");
		hdmitc_writel(hdmitc_info, 0x00, HDMITC_FC_DBGTMDS2); /* R/Y */
		hdmitc_writel(hdmitc_info, 0xFF, HDMITC_FC_DBGTMDS1); /* G/Cb */
		hdmitc_writel(hdmitc_info, 0xFF, HDMITC_FC_DBGTMDS0); /* B/Cr */
		hdmitc_writel_mask(hdmitc_info, FC_DBGFORCE_VIDEO, HDMITC_FC_DBGFORCE, FC_DBGFORCE_VIDEO);
	}
	else
	{
		printk("    disable debug video: normal output\n");
		hdmitc_writel_mask(hdmitc_info, ~FC_DBGFORCE_VIDEO, HDMITC_FC_DBGFORCE, FC_DBGFORCE_VIDEO);
		hdmitc_writel(hdmitc_info, 0x00, HDMITC_FC_DBGTMDS2); /* R/Y */
		hdmitc_writel(hdmitc_info, 0x00, HDMITC_FC_DBGTMDS1); /* G/Cb */
		hdmitc_writel(hdmitc_info, 0x00, HDMITC_FC_DBGTMDS0); /* B/Cr */
	}
}
