/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */

#include "vpl_hdmitc.h"
#include <linux/fb.h>
#define I2C_MIN_FS_SCL_HIGH_TIME	600 /* ns */
#define I2C_MIN_FS_SCL_LOW_TIME		1300
#define I2C_MIN_SS_SCL_HIGH_TIME	4500 /* 4000 */
#define I2C_MIN_SS_SCL_LOW_TIME		5200 /* 4700 */
#define I2C_MIN_SDA_HOLD_TIME		300

static void i2cm_init(struct vpl_hdmitc_info *hdmitc_info, u32 isfrclk)
{
	u32 value;
	isfrclk /= 1000000; /* pre divide, otherwise x_TIME*isfrclk will over 32bit */
	hdmitc_writel(hdmitc_info, I2CM_DIV_FAST_STD_MODE, HDMITC_I2CM_DIV);
	/* fast speed SCL high */
	value = DIV_ROUND_UP(I2C_MIN_FS_SCL_HIGH_TIME * isfrclk, 1000);
	hdmitc_writel(hdmitc_info, value >> 8, HDMITC_I2CM_FS_SCL_HCNT_1_ADDR);
	hdmitc_writel(hdmitc_info, value & 0xFF, HDMITC_I2CM_FS_SCL_HCNT_0_ADDR);
	/* fast speed SCL low */
	value = DIV_ROUND_UP(I2C_MIN_FS_SCL_LOW_TIME * isfrclk, 1000);
	hdmitc_writel(hdmitc_info, value >> 8, HDMITC_I2CM_FS_SCL_LCNT_1_ADDR);
	hdmitc_writel(hdmitc_info, value & 0xFF, HDMITC_I2CM_FS_SCL_LCNT_0_ADDR);
	/* slow speed SCL high */
	value = DIV_ROUND_UP(I2C_MIN_SS_SCL_HIGH_TIME * isfrclk, 1000);
	hdmitc_writel(hdmitc_info, value >> 8, HDMITC_I2CM_SS_SCL_HCNT_1_ADDR);
	hdmitc_writel(hdmitc_info, value & 0xFF, HDMITC_I2CM_SS_SCL_HCNT_0_ADDR);
	/* slow speed SCL low */
	value = DIV_ROUND_UP(I2C_MIN_SS_SCL_LOW_TIME * isfrclk, 1000);
	hdmitc_writel(hdmitc_info, value >> 8, HDMITC_I2CM_SS_SCL_LCNT_1_ADDR);
	hdmitc_writel(hdmitc_info, value & 0xFF, HDMITC_I2CM_SS_SCL_LCNT_0_ADDR);
	/* SDA hold time */
	value = DIV_ROUND_UP(I2C_MIN_SDA_HOLD_TIME * isfrclk, 1000);
	hdmitc_writel(hdmitc_info, value & 0xFF, HDMITC_I2CM_SDA_HOLD);
}

void i2cm_edid_read_byte_request(struct vpl_hdmitc_info *hdmitc_info, int block, u8 bl_offset)
{
	u8 ddc_seg_ptr = (block/2);
	u8 ddc_word_offset = (block%2)*0x80 + bl_offset; /* block offset to segment word offset*/

	hdmitc_writel(hdmitc_info, ddc_seg_ptr, HDMITC_I2CM_SEGPTR);
	hdmitc_writel(hdmitc_info, ddc_word_offset, HDMITC_I2CM_ADDRESS);

	if (ddc_seg_ptr == 0)
		hdmitc_writel(hdmitc_info, I2CM_OPERATION_RD , HDMITC_I2CM_OPERATION);
	else
		hdmitc_writel(hdmitc_info, I2CM_OPERATION_RD_EXT , HDMITC_I2CM_OPERATION);
}

u8 *i2cm_edid_read_block(struct vpl_hdmitc_info *hdmitc_info, u8 *edid, int block)
{
	int i;
	printk("====== block %03d ===== \n", block);

	for (i = 0; i < 0x80; i++) {
		i2cm_edid_read_byte_request(hdmitc_info, block, i);
		/* wait down interrupt */
		mdelay(1);
		edid[i] = hdmitc_readl(hdmitc_info, HDMITC_I2CM_DATAI);
	}

	for (i=0; i<128;i+=8)
		printk("%02x %02x %02x %02x %02x %02x %02x %02x\n", edid[i], edid[i+1], edid[i+2], edid[i+3], edid[i+4], edid[i+5], edid[i+6], edid[i+7]);

	return edid;
}

void edid_init(struct vpl_hdmitc_info *hdmitc_info)
{
	u8* edid =  kzalloc(512, GFP_KERNEL);
	int i;
	struct fb_monspecs specs;
	printk("    edid init\n");
	/* set up i2c interface */
	i2cm_init(hdmitc_info, 74500000);
	hdmitc_writel(hdmitc_info, (0xA0 >> 1), HDMITC_I2CM_SLAVE); /* 7 bit only, HW deal with LSB for read/write */
	hdmitc_writel(hdmitc_info, (0x60 >> 1), HDMITC_I2CM_SEGADDR); /* 0x60 segment pointer for E-EDID */

	i2cm_edid_read_block(hdmitc_info, edid, 0);

	/*if (&specs == NULL) {
		printk("no help");
	}*/

	if (edid[0x7E] > 0) {
		for (i = 0; i < edid[0x7E]; i++) {
			i2cm_edid_read_block(hdmitc_info, edid+0x80*(i+1), i+1); /* read CEA block*/
		}
	}

	fb_edid_to_monspecs(edid, &specs);
}

void i2cm_int_handler(struct vpl_hdmitc_info *hdmitc_info)
{


}
