/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#include "vpl_hdmitc.h"

void hdmitc_phy_init(struct vpl_hdmitc_info *hdmitc_info)
{
	u32 phyconf0 = PHY_CONF0_PDZ_DOWN | PHY_CONF0_ENTMDS_DIS |
		       PHY_CONF0_SELDATAENPOL_HI | PHY_CONF0_SELDIPIF_DATA;
	printk("    phy init\n");
	hdmitc_writel(hdmitc_info, phyconf0, HDMITC_PHY_CONF0);
}

static inline void hdmitc_phy_testcode(struct vpl_hdmitc_info *hdmitc_info, u32 value)
{

	hdmitc_writel_mask(hdmitc_info, PHY_TST0_TESTCLK_HI, HDMITC_PHY_TST0, PHY_TST0_TESTCLK_MASK);
	hdmitc_writel(hdmitc_info, value, HDMITC_PHY_TST1);
	hdmitc_writel_mask(hdmitc_info, PHY_TST0_TESTEN_HI, HDMITC_PHY_TST0, PHY_TST0_TESTEN_MASK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTCLK_MASK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTEN_MASK);
}

static inline void hdmitc_phy_testdata(struct vpl_hdmitc_info *hdmitc_info, u32 value)
{

	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTEN_MASK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTCLK_MASK);
	hdmitc_writel(hdmitc_info, value, HDMITC_PHY_TST1);
	hdmitc_writel_mask(hdmitc_info, PHY_TST0_TESTCLK_HI, HDMITC_PHY_TST0, PHY_TST0_TESTCLK_MASK);
}

void hdmitc_phy_configure(struct vpl_hdmitc_info *hdmitc_info)
{
	printk("    phy config\n");

	/* phy config */
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTCLR_MASK);
	hdmitc_writel_mask(hdmitc_info, PHY_TST0_TESTCLR_HI, HDMITC_PHY_TST0, PHY_TST0_TESTCLR_MASK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTCLR_MASK);

	/* */
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTCLK_MASK);
	hdmitc_writel_mask(hdmitc_info, 0, HDMITC_PHY_TST0, PHY_TST0_TESTEN_MASK);

	/* Test control */
	/*480
	hdmitc_phy_testcode(hdmitc_info, 0x1B);
	hdmitc_phy_testdata(hdmitc_info, 0x96C1 >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x96C1 & 0xFF);

	hdmitc_phy_testcode(hdmitc_info, 0x1A);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A & 0xFF);
	*/
	hdmitc_phy_testcode(hdmitc_info, 0x1B);
	hdmitc_phy_testdata(hdmitc_info, 0x95C8 >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x95C8 & 0xFF);

	hdmitc_phy_testcode(hdmitc_info, 0x1A);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A & 0xFF);
	/*1080p*/
	/*
	hdmitc_phy_testcode(hdmitc_info, 0x1B);
	hdmitc_phy_testdata(hdmitc_info, 0x89C9 >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x89C9 & 0xFF);

	hdmitc_phy_testcode(hdmitc_info, 0x1A);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A >> 8);
	hdmitc_phy_testdata(hdmitc_info, 0x6A4A & 0xFF);
	*/
	hdmitc_phy_testcode(hdmitc_info, 0x00);

	hdmitc_writel(hdmitc_info, 0x00, HDMITC_PHY_TST0);

	/* phy reset */
	hdmitc_writel(hdmitc_info, 0, HDMITC_MC_PHYRSTZ);
	hdmitc_writel(hdmitc_info, 1, HDMITC_MC_PHYRSTZ);

	/* 25 < Pclk < 40  , no pixel rep */
/*
	hdmitc_writel(hdmitc_info, 0x36, HDMITC_PHY_PCLFREQ0);
	hdmitc_writel(hdmitc_info, (0x36>>8), HDMITC_PHY_PCLFREQ1);
	hdmitc_writel(hdmitc_info, 0x40, HDMITC_PHY_PLLCFGFREQ0);
	hdmitc_writel(hdmitc_info, 0x29, HDMITC_PHY_PLLCFGFREQ1);
*/
	/* 50 < Pclk < 80  , no pixel rep */
	hdmitc_writel(hdmitc_info, 0x95, HDMITC_PHY_PCLFREQ0);
	hdmitc_writel(hdmitc_info, (0x95>>8), HDMITC_PHY_PCLFREQ1);
	hdmitc_writel(hdmitc_info, 0x40, HDMITC_PHY_PLLCFGFREQ0);
	hdmitc_writel(hdmitc_info, 0x29, HDMITC_PHY_PLLCFGFREQ1);

/*   100 < Pclk < 160
	hdmitc_writel(hdmitc_info, 0x129, HDMITC_PHY_PCLFREQ0);
	hdmitc_writel(hdmitc_info, (0x129>>8), HDMITC_PHY_PCLFREQ1);
	hdmitc_writel(hdmitc_info, 0x40, HDMITC_PHY_PLLCFGFREQ0);
	hdmitc_writel(hdmitc_info, 0x29, HDMITC_PHY_PLLCFGFREQ1);
*/
	hdmitc_writel(hdmitc_info, PHY_CONF0_PDZ_UP | PHY_CONF0_ENTMDS_EN |
		       PHY_CONF0_SELDATAENPOL_HI | PHY_CONF0_SELDIPIF_DATA, HDMITC_PHY_CONF0);
}
