/*
 * $Header:$
 *
 *
 * Driver for DesignWare HDMI Transmitter
 *
 * Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#ifndef __VPL_HDMITC_REGS_H__
#define __VPL_HDMITC_REGS_H__

/* Identification Registers*/
#define HDMITC_DESIGN_ID		0x0000
#define HDMITC_REVISION_ID		0x0001
#define HDMITC_PRODUCT_ID0		0x0002
#define HDMITC_PRODUCT_ID1		0x0003
#define HDMITC_CONFIG0_ID		0x0004
#define HDMITC_CONFIG1_ID		0x0005
#define HDMITC_CONFIG2_ID		0x0006
#define HDMITC_CONFIG3_ID		0x0007

/* Interrupt Registers */
#define HDMITC_IH_FC_STAT0		0x0100
#define HDMITC_IH_FC_STAT1		0x0101
#define HDMITC_IH_FC_STAT2		0x0102
#define HDMITC_IH_AS_STAT0		0x0103
#define HDMITC_IH_PHY_STAT0		0x0104
#define HDMITC_IH_I2CM_STAT0		0x0105
#define HDMITC_IH_CEC_STAT0		0x0106
#define HDMITC_IH_VP_STAT0		0x0107
#define HDMITC_IH_DECODE		0x0170
#define HDMITC_IH_MUTE_AUD       	0x0183
#define HDMITC_IH_MUTE_I2CM_STAT0	0x0185
#define HDMITC_IH_MUTE_CEC_STAT0	0x0186
#define HDMITC_IH_MUTE			0x01FF

/* Video Sampler Registers */
#define HDMITC_TX_INVID0		0x0200
#define HDMITC_TX_INSTUFFING		0x0201
#define HDMITC_TX_GYDATA0		0x0202
#define HDMITC_TX_GYDATA1		0x0203
#define HDMITC_TX_RCRDATA0		0x0204
#define HDMITC_TX_RCRDATA1		0x0205
#define HDMITC_TX_BCBDATA0		0x0206
#define HDMITC_TX_BCBDATA1		0x0207

/* Video Packetizer Registers */
#define HDMITC_VP_STATUS		0x0800
#define HDMITC_VP_PR_CD			0x0801
#define HDMITC_VP_STUFF			0x0802
#define HDMITC_VP_REMAP			0x0803
#define HDMITC_VP_CONF			0x0804
#define HDMITC_VP_MASK			0x0807

/* Frame Composer Registers */
#define HDMITC_FC_INVIDCONF		0x1000
#define HDMITC_FC_INHACTIV0		0x1001
#define HDMITC_FC_INHACTIV1		0x1002
#define HDMITC_FC_INHBLANK0		0x1003
#define HDMITC_FC_INHBLANK1		0x1004
#define HDMITC_FC_INVACTIV0		0x1005
#define HDMITC_FC_INVACTIV1		0x1006
#define HDMITC_FC_INVBLANK		0x1007
#define HDMITC_FC_HSYNCINDELAY0		0x1008
#define HDMITC_FC_HSYNCINDELAY1		0x1009
#define HDMITC_FC_HSYNCINWIDTH0		0x100A
#define HDMITC_FC_HSYNCINWIDTH1		0x100B
#define HDMITC_FC_VSYNCINDELAY		0x100C
#define HDMITC_FC_VSYNCINWIDTH		0x100D
#define HDMITC_FC_INFREQ0		0x100E
#define HDMITC_FC_INFREQ1		0x100F
#define HDMITC_FC_INFREQ2		0x1010
#define HDMITC_FC_CTRLDUR		0x1011 //?
#define HDMITC_FC_EXCTRLDUR		0x1012 //?
#define HDMITC_FC_EXCTRLSPAC		0x1013 //?
#define HDMITC_FC_CH0PREAM		0x1014
#define HDMITC_FC_CH1PREAM		0x1015
#define HDMITC_FC_CH2PREAM		0x1016

#define HDMITC_FC_AVICONF0		0x1019
#define HDMITC_FC_AVICONF1		0x101a
#define HDMITC_FC_AVICONF2		0x101b
#define HDMITC_FC_AVIVID		0x101c
#define HDMITC_FC_AVIETB0		0x101d
#define HDMITC_FC_AVIETB1		0x101e
#define HDMITC_FC_AVISBB0		0x101f
#define HDMITC_FC_AVISBB1		0x1020
#define HDMITC_FC_AVIELB0		0x1021
#define HDMITC_FC_AVIELB1		0x1022
#define HDMITC_FC_AVISRB0		0x1023
#define HDMITC_FC_AVISRB1		0x1024
#define HDMITC_FC_AUDICONF0		0x1025
#define HDMITC_FC_AUDICONF1		0x1026
#define HDMITC_FC_AUDICONF2		0x1027
#define HDMITC_FC_AUDSCONF		0x1063
#define HDMITC_FC_AUDSV			0x1065
#define HDMITC_FC_AUDSCHNLS0		0x1067
#define HDMITC_FC_AUDSCHNLS2		0x1069
#define HDMITC_FC_AUDSCHNLS3		0x106a
#define HDMITC_FC_AUDSCHNLS4		0x106b
#define HDMITC_FC_AUDSCHNLS5		0x106c
#define HDMITC_FC_AUDSCHNLS6		0x106d
#define HDMITC_FC_AUDSCHNLS7		0x106e
#define HDMITC_FC_AUDSCHNLS8		0x106f

#define HDMITC_FC_MASK0			0x10D2
#define HDMITC_FC_MASK1			0x10D6
#define HDMITC_FC_MASK2			0x10DA
#define HDMITC_FC_DATAUTO0		0x10B3
#define HDMITC_FC_DATAUTO1		0x10B4
#define HDMITC_FC_DATAUTO2		0x10B5



#define HDMITC_FC_PRCONF		0x10E0 //Pixel Repetition

#define HDMITC_FC_DBGFORCE		0x1200
#define HDMITC_FC_DBGAUD0CHN0		0x1201
#define HDMITC_FC_DBGAUD1CHN0		0x1202
#define HDMITC_FC_DBGAUD2CHN0		0x1203
#define HDMITC_FC_DBGTMDS0		0x1219
#define HDMITC_FC_DBGTMDS1		0x121A
#define HDMITC_FC_DBGTMDS2		0x121B

/* PHY Register */
#define HDMITC_PHY_CONF0		0x3000
#define HDMITC_PHY_TST0			0x3001
#define HDMITC_PHY_TST1			0x3002
#define HDMITC_PHY_TST2			0x3003
#define HDMITC_PHY_STAT0		0x3004
#define HDMITC_PHY_INT0			0x3005
#define HDMITC_PHY_MASK0		0x3006
#define HDMITC_PHY_POL0			0x3007
#define HDMITC_PHY_PCLFREQ0		0x3008
#define HDMITC_PHY_PCLFREQ1		0x3009
#define HDMITC_PHY_PLLCFGFREQ0		0x300A
#define HDMITC_PHY_PLLCFGFREQ1		0x300B
#define HDMITC_PHY_PLLCFGFREQ2		0x300C

/*
 * I2C Master PHY Registers
 *
 * 0x3020 ~ 0x3033
 * These registers are functional when, PHY_GEN2 = 1 or PHY_EXTERNAL = 1
 * Not use in Rossini
 */
#define HDMITC_PHY_I2CM_INT		0x3027
#define HDMITC_PHY_I2CM_CTLINT		0x3028

/* Audio Sampler Registers */
#define HDMITC_AUD_CONF0		0x3100
#define HDMITC_AUD_CONF1		0x3101
#define HDMITC_AUD_INT			0x3102
#define HDMITC_AUD_INT1			0x3104
#define HDMITC_AUD_N1				0x3200
#define HDMITC_AUD_N2				0x3201
#define HDMITC_AUD_N3				0x3202
#define HDMITC_AUD_CTS1			0x3203
#define HDMITC_AUD_CTS2			0x3204
#define HDMITC_AUD_CTS3			0x3205
#define HDMITC_AUD_INPUTCLKFS		0x3206
#define HDMITC_AUD_SPDIFINT		0x3302 /* AUDIO_IF = SPDIF or DOUBLE*/
#define HDMITC_AUD_SPDIFINT1		0x3303
#define HDMITC_AUD_DMA_MASK		0x3614
#define HDMITC_AUD_DMA_BUFMASK	0x3619
/*
 * Generic Parallel Audio Interface Registers
 *
 * These registers are only present when the AUDIO_IF = GPAUD (6) or GDOUBLE
 * Not in Rossini
 */

/*
 * Audio DMA Registers
 *
 * These registers are only present when the AUDIO_IF = AHBAUDDMA
 * Not in Rossini
 */

/* Main Controller Registers */
#define HDMITC_MC_CLKDIS		0x4001
#define HDMITC_MC_SWRSTZREQ		0x4002
#define HDMITC_MC_OPCTRL		0x4003
#define HDMITC_MC_FLOWCTRL		0x4004
#define HDMITC_MC_PHYRSTZ		0x4005
#define HDMITC_MC_LOCKONCLOCK		0x4006
#define HDMITC_MC_HEACPHY_RST		0x4007
#define HDMITC_MC_LOCKONCLOCK_2		0x4009
#define HDMITC_MC_SWRSTZREQ_2		0x400A

/* Color Space Converter Registers */
#define HDMITC_CSC_CFG			0x4100
#define HDMITC_CSC_SCALE		0x4101
#define HDMITC_CSC_COEF_A1_MSB		0x4102
#define HDMITC_CSC_COEF_A1_LSB		0x4103
#define HDMITC_CSC_COEF_A2_MSB		0x4104
#define HDMITC_CSC_COEF_A2_LSB		0x4105
#define HDMITC_CSC_COEF_A3_MSB		0x4106
#define HDMITC_CSC_COEF_A3_LSB		0x4107
#define HDMITC_CSC_COEF_A4_MSB		0x4108
#define HDMITC_CSC_COEF_A4_LSB		0x4109
#define HDMITC_CSC_COEF_B1_MSB		0x410A
#define HDMITC_CSC_COEF_B1_LSB		0x410B
#define HDMITC_CSC_COEF_B2_MSB		0x410C
#define HDMITC_CSC_COEF_B2_LSB		0x410D
#define HDMITC_CSC_COEF_B3_MSB		0x410E
#define HDMITC_CSC_COEF_B3_LSB		0x410F
#define HDMITC_CSC_COEF_B4_MSB		0x4110
#define HDMITC_CSC_COEF_B4_LSB		0x4111
#define HDMITC_CSC_COEF_C1_MSB		0x4112
#define HDMITC_CSC_COEF_C1_LSB		0x4113
#define HDMITC_CSC_COEF_C2_MSB		0x4114
#define HDMITC_CSC_COEF_C2_LSB		0x4115
#define HDMITC_CSC_COEF_C3_MSB		0x4116
#define HDMITC_CSC_COEF_C3_LSB		0x4117
#define HDMITC_CSC_COEF_C4_MSB		0x4118
#define HDMITC_CSC_COEF_C4_LSB		0x4119
#define HDMITC_CSC_SPARE_1		0x411A
#define HDMITC_CSC_SPARE_2		0x411B

/*
 * HDCP Encryption Engine Registers
 * HDCP BKSV Registers
 * HDCP AN Registers
 * Encrypted DPK Embedded Storage Registers
 *
 * These registers are present when hardware configuration parameter HDCP = 1 (True)
 * Not in Rossini
 */

/* CEC Engine Registers */
#define HDMITC_CEC_CTRL				0X7D00
#define HDMITC_CEC_MASK				0X7D02
#define HDMITC_CEC_ADDR_L			0X7D05
#define HDMITC_CEC_ADDR_H			0X7D06
#define HDMITC_CEC_TX_CNT			0X7D07
#define HDMITC_CEC_RX_CNT			0X7D08
#define HDMITC_CEC_TX_DATA0			0X7D10
#define HDMITC_CEC_TX_DATA1			0X7D10
#define HDMITC_CEC_TX_DATA15			0X7D1F
#define HDMITC_CEC_RX_DATA0			0X7D20
#define HDMITC_CEC_RX_DATA15			0X7D2F
#define HDMITC_CEC_LOCK				0X7D30
#define HDMITC_CEC_WKUPCTRL			0X7D31

/* I2C Master Registers (E-DDC) */
#define HDMITC_I2CM_SLAVE			0x7E00
#define HDMITC_I2CM_ADDRESS			0x7E01
#define HDMITC_I2CM_DATAO			0x7E02
#define HDMITC_I2CM_DATAI			0x7E03
#define HDMITC_I2CM_OPERATION			0x7E04
#define HDMITC_I2CM_INT				0x7E05
#define HDMITC_I2CM_CTLINT			0x7E06
#define HDMITC_I2CM_DIV				0x7E07
#define HDMITC_I2CM_SEGADDR			0X7E08
#define HDMITC_I2CM_SOFTRSTZ			0X7E09
#define HDMITC_I2CM_SEGPTR			0X7E0A
#define HDMITC_I2CM_SS_SCL_HCNT_1_ADDR		0X7E0B
#define HDMITC_I2CM_SS_SCL_HCNT_0_ADDR		0X7E0C
#define HDMITC_I2CM_SS_SCL_LCNT_1_ADDR		0X7E0D
#define HDMITC_I2CM_SS_SCL_LCNT_0_ADDR		0X7E0E
#define HDMITC_I2CM_FS_SCL_HCNT_1_ADDR		0X7E0F
#define HDMITC_I2CM_FS_SCL_HCNT_0_ADDR		0X7E10
#define HDMITC_I2CM_FS_SCL_LCNT_1_ADDR		0X7E11
#define HDMITC_I2CM_FS_SCL_LCNT_0_ADDR		0X7E12
#define HDMITC_I2CM_SDA_HOLD			0x7E13

/*
 * Bit definition part
 */
/* IH_DECODE */
#define IH_CEC_STAT0_WAKEUP			(1 << 6)
#define IH_CEC_STAT0_ERR_FOLL			(1 << 5)
#define IH_CEC_STAT0_ERR_INIT			(1 << 4)
#define IH_CEC_STAT0_ARB_LOST			(1 << 3)
#define IH_CEC_STAT0_NACK			(1 << 2)
#define IH_CEC_STAT0_EOM			(1 << 1)
#define IH_CEC_STAT0_DONE			(1 << 0)

#define IH_DECODE_AUDIO				(1 << 4)
#define IH_DECODE_PHY				(1 << 3)
#define IH_DECODE_I2CM_STAT0			(1 << 2)
#define IH_DECODE_CEC_STAT0			(1 << 1)

/* TX_INVID0 */
#define TX_INVID0_VIDEO_MAP_RGB_8BITS		(0x01)
#define TX_INVID0_VIDEO_MAP_YUV422_8BITS	(0x16)
#define TX_INSTUFFING_GY			(1 << 0)
#define TX_INSTUFFING_RCR			(1 << 1)
#define TX_INSTUFFING_BCB			(1 << 2)

/* VP_PR_CD */
#define VP_PR_CD_COLOR_DEPTH_24			(0x4 << 4) /*Default: 0x0 << 4 also 24BIT*/
#define VP_PR_CD_COLOR_DEPTH_24_MASK		(0xF << 4)
#define VP_PR_CD_DESIRED_PR_FACTOR_1T		(0x0 << 0) /* send once only */
#define VP_PR_CD_DESIRED_PR_FACTOR_2T		(0x1 << 0) /* repeated once */
#define VP_PR_CD_DESIRED_PR_FACTOR_MASK		(0xF << 0)

/* VP_STUFF */
#define VP_STUFF_YCC422_STUFFING		(1 << 2)
#define VP_STUFF_PP_STUFFING			(1 << 1)
#define VP_STUFF_PR_STUFFING			(1 << 0)
/* VP_REMAP */
#define VP_REMAP_YCC422_8			(0)
#define VP_REMAP_YCC422_10			(1)
#define VP_REMAP_YCC422_12			(2)
/* VP_CONF */
#define VP_CONF_BYPASS_EN			(1 << 6)
#define VP_CONF_PP_EN				(1 << 5)
#define VP_CONF_PR_EN				(1 << 4)
#define VP_CONF_YCC422_EN			(1 << 3)
#define VP_CONF_BYPASS_SELECT_PR		(0 << 2)
#define VP_CONF_BYPASS_SELECT_VP		(1 << 2)
#define VP_CONF_OUTPUT_SELECT_PP		(0 << 0)
#define VP_CONF_OUTPUT_SELECT_YCC422		(1 << 0)
#define VP_CONF_OUTPUT_SELECT_8_BYPASS		(3 << 0)
#define VP_CONF_OUTPUT_SELECT_MASK		(3 << 0)

/* FC_INVIDCONF */
#define FC_INVIDCONF_VSYNC_IN_POLARITY		(1 << 6)
#define FC_INVIDCONF_HSYNC_IN_POLARITY		(1 << 5)
#define FC_INVIDCONF_DE_IN_POLARITY		(1 << 4)
#define FC_INVIDCONF_DVI_MODEZ			(1 << 3)  /*Note: Active low*/
#define FC_INVIDCONF_VBLANKOSC			(1 << 1)
#define FC_INVIDCONF_IN_I_P			(1 << 0)
/* FC_DATAUTO0 */
#define FC_DATAUTO0_SPD_AUTO 			(1 << 4)
#define FC_DATAUTO0_VSD_AUTO 			(1 << 3)
#define FC_DATAUTO0_ISCR2_AUTO 			(1 << 2)
#define FC_DATAUTO0_ISCR1_AUTO 			(1 << 1)
#define FC_DATAUTO0_ACP_AUTO 			(1 << 0)
/* FC_DBGFORCE */
#define FC_DBGFORCE_AUDIO			(1 << 4)
#define FC_DBGFORCE_VIDEO			(1 << 0)
/* FC_PRCONF */
#define FC_PROCONF_IN_PR_FACTOR_0 		(1 << 4)
#define FC_PROCONF_IN_PR_FACTOR_1 		(2 << 4)
#define FC_PROCONF_IN_PR_FACTOR_MASK 		(15 << 4)
/* MC_CLKDIS */
#define MC_CLKDIS_HDCPCLK			(1 << 6)
#define MC_CLKDIS_CECCLK			(1 << 5)
#define MC_CLKDIS_CSCCLK			(1 << 4)
#define MC_CLKDIS_AUDCLK			(1 << 3)
#define MC_CLKDIS_PREPCLK			(1 << 2)
#define MC_CLKDIS_TMDSCLK			(1 << 1)
#define MC_CLKDIS_PIXELCLK			(1 << 0)
/* PHY_CONF0 */
#define PHY_CONF0_PDZ_DOWN			(0 << 7) // power down
#define PHY_CONF0_PDZ_UP			(1 << 7) // power up
#define PHY_CONF0_ENTMDS_EN			(1 << 6) //
#define PHY_CONF0_ENTMDS_DIS			(0 << 6) //
#define PHY_CONF0_SELDATAENPOL_HI		(1 << 1)
#define PHY_CONF0_SELDATAENPOL_LOW		(0 << 1)
#define PHY_CONF0_SELDATAENPOL_MASK		(1 << 1)
#define PHY_CONF0_SELDIPIF_AUX			(1 << 0)
#define PHY_CONF0_SELDIPIF_DATA			(0 << 0)
#define PHY_CONF0_SELDIPIF_MASK			(1 << 0)
/* PHY_TST0 */
#define PHY_TST0_TESTCLR_HI			(1 << 5)
#define PHY_TST0_TESTCLR_MASK			(1 << 5)
#define PHY_TST0_TESTEN_HI			(1 << 4)
#define PHY_TST0_TESTEN_MASK			(1 << 4)
#define PHY_TST0_TESTCLK_HI			(1 << 0)
#define PHY_TST0_TESTCLK_MASK			(1 << 0)
/* PHY_STAT0 */
#define PHY_STAT0_TX_PHY_LOCK			(1 << 0)
/* PHY_POL0 */
#define PHY_POL0_HPD_MASK			(1 << 1)

/* I2CM_OPERATION */
#define I2CM_OPERATION_WR			(1 << 4)
#define I2CM_OPERATION_RD_EXT			(1 << 1)
#define I2CM_OPERATION_RD			(1 << 0)
/* I2CM_DIV */
#define I2CM_DIV_FAST_STD_MODE			(1 << 3)

/* CSC_SCALE */
#define CSC_SCALE_SCALE_MASK			(3 << 0)
#define CSC_SCALE_COLOR_DEPTH_24		(0x4 << 4)
#define CSC_SCALE_COLOR_DEPTH_MASK		(0xF << 4)

/* CEC_MASK */
#define CEC_CTRL_STANDBY			(1 << 4)
#define CEC_CTRL_FRAME_TYPE_3BP			(0 << 1)
#define CEC_CTRL_FRAME_TYPE_5BP			(1 << 1)
#define CEC_CTRL_FRAME_TYPE_7BP			(2 << 1)
#define CEC_CTRL_FRAME_TYPE_MASK		(3 << 1)
#define CEC_CTRL_SEND				(1 << 0)

#define CEC_MASK_WAKEUP				(1 << 6)
#define CEC_MASK_ERROR_FLOW			(1 << 5)
#define CEC_MASK_ERROR_INITIATOR		(1 << 4)
#define CEC_MASK_ARB_LOST			(1 << 3)
#define CEC_MASK_NACK				(1 << 2)
#define CEC_MASK_EOM				(1 << 1)
#define CEC_MASK_DONE				(1 << 0)

/* HW Feature */
#define HDMITC_HW_FEAT_PREPEN			(1 << 7)
#define HDMITC_HW_FEAT_AUDSPDIF			(1 << 5)
#define HDMITC_HW_FEAT_AUDI2S			(1 << 4)
#define HDMITC_HW_FEAT_HDMI14			(1 << 3)
#define HDMITC_HW_FEAT_CSC			(1 << 2)
#define HDMITC_HW_FEAT_CEC			(1 << 1)
#define HDMITC_HW_FEAT_HDCP			(1 << 0)

#define HDMITC_HW_FEAT_CONFAPB			0x00000002
#define HDMITC_HW_FEAT_CONFAHBAUDDMA		0x00000002
#define HDMITC_HW_FEAT_CONFPGAUD		0x00000001

#endif //__VPL_HDMITC_REGS_H__
