/*
 * $Header:$
 *
 * vpl_voc
 * Driver for VPL VOC
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#ifndef __VPL_VOC_H__
#define __VPL_VOC_H__

/* ============================================================================================== */
#include <linux/ioctl.h>

#include "typedef.h"
#include "vivo_codec.h"
#include "vpl_voc_fb.h"

/* ============================================================================================== */
#define VPL_VOC_VERSION MAKEFOURCC(2, 0, 0, 7)
#define VPL_VOC_ID_VERSION "2.0.0.7"

/* ============================================================================================== */
#define VIDEO_MAX_FRAME 32

/* ============================================================================================== */
typedef struct voc_init_options {
	DWORD dwInStride;
	EPixelFormatFlags eInPixFormat;
	DWORD dwSrcMcmprMode;
	DWORD dwPIPSrcMcmprMode;
} TVOCInitOptions;

/* ============================================================================================== */
typedef struct video_buffer
{
	DWORD dwIndex;
	DWORD dwFrameCount;
	BYTE *pbyYFrame;
	BYTE *pbyCbFrame;
	BYTE *pbyCrFrame;
} TVideoBuffer;

/* ============================================================================================== */
typedef struct voc_pip_info
{
	DWORD dwWidth;
	DWORD dwHeight;
	DWORD dwStride;
	DWORD dwXPos;
	DWORD dwYPos;
} TPIPInfo;

/* ============================================================================================== */
typedef struct vpl_voc_info
{
	DWORD dwVersion; // MMR 0
	DWORD dwCtrl; // MMR 1
	DWORD dwStat; // MMR 2

	/* Video Buffer Address Registers */
	DWORD dwYBuff0Addr; // MMR 3
	DWORD dwCbBuff0Addr; // MMR 4
	DWORD dwCrBuff0Addr; // MMR 5
	DWORD dwYBuff1Addr; // MMR 6
	DWORD dwCbBuff1Addr; // MMR 7
	DWORD dwCrBuff1Addr; // MMR 8

	/* Video Signal Contrl Registers */
	DWORD dwInSize; // MMR 9
	DWORD dwOutSize; // MMR 10
	DWORD dwOutSizeCtrl; // MMR 11
	DWORD dwHSyncCtrl; // MMR 12
	DWORD dwVSyncCtrl; // MMR 13

	/* Color Space convert Registers */
	DWORD dwSBCCtrl; //MMR 14
	DWORD dwYCbCr2RGBCoeff0; //MMR 15
	DWORD dwYCbCr2RGBCoeff1; //MMR 16
	DWORD dwYCbCr2RGBCoeff2; //MMR 17

	/* I80 interface Control Registers */
	DWORD dwI80Ctrl; // MMR 18
	DWORD dwI80Timing; // MMR 19
	DWORD dwI80WTCONData; // MMR 20
	DWORD dwI80RTCONReg; // MMR 21

	/* Index OSD Control Registers */
	DWORD dwIndexOSDCtrl; // MMR 22
	DWORD dwIndexOSDAddr; // MMR 23
	DWORD dwIndexOSDSize; // MMR 24
	DWORD dwIndexOSDAxis; // MMR 25
	DWORD dwIndexOSDPalette; // MMR 26
	DWORD dwIndexOSDReadPalette; // MMR 27

	/* Global Registers */
	DWORD dwStrideSetting; // MMR 28

	/* PIP */
	DWORD dwPIPCtrl; //MMR29
	DWORD dwPIPYBuff0Addr; // MMR 30
	DWORD dwPIPCbBuff0Addr; // MMR 31
	DWORD dwPIPCrBuff0Addr; // MMR 32
	DWORD dwPIPYBuff1Addr; // MMR 33
	DWORD dwPIPCbBuff1Addr; // MMR 34
	DWORD dwPIPCrBuff1Addr; // MMR 35
	DWORD dwPIPSize; //MMR 36
	DWORD dwPIPAxis; //MMR 37

} TVPLVOCInfo;

/* ============================================================================================== */
#define VPL_VOC_IOC_MAGIC 243

#define VPL_VOC_IOC_START			_IO     (VPL_VOC_IOC_MAGIC,  0)
#define VPL_VOC_IOC_WAIT_COMPLETE		_IO     (VPL_VOC_IOC_MAGIC,  1)
#define VPL_VOC_IOC_SHARE_MMR_INFO_SPACE	_IOW    (VPL_VOC_IOC_MAGIC,  2, DWORD)
#define VPL_VOC_IOC_GET_VERSION_NUMBER		_IOR    (VPL_VOC_IOC_MAGIC,  3, DWORD)
#define VPL_VOC_IOC_GET_BANDWIDTH		_IOR    (VPL_VOC_IOC_MAGIC,  4, DWORD)
#define VPL_VOC_IOC_GET_RG_INTERVAL		_IOR    (VPL_VOC_IOC_MAGIC,  5, DWORD)
#define VPL_VOC_IOC_GET_REQ_TIMES		_IOR    (VPL_VOC_IOC_MAGIC,  6, DWORD)
#define VPL_VOC_IOC_CLEAR_PROFILE		_IO     (VPL_VOC_IOC_MAGIC,  7)
#define VPL_VOC_IOC_RESET			_IO     (VPL_VOC_IOC_MAGIC,  8)
#define VPL_VOC_IOC_STOP			_IO     (VPL_VOC_IOC_MAGIC,  9)
#define VPL_VOC_IOC_INITIAL			_IOW    (VPL_VOC_IOC_MAGIC, 10, DWORD)
#define VPL_VOC_IOC_SET_BRIGHTNESS		_IOW    (VPL_VOC_IOC_MAGIC, 11, DWORD)
#define VPL_VOC_IOC_SET_CONTRAST		_IOW    (VPL_VOC_IOC_MAGIC, 12, DWORD)
#define VPL_VOC_IOC_SET_SATURATION		_IOW    (VPL_VOC_IOC_MAGIC, 13, DWORD)
#define VPL_VOC_IOC_QUEUE_BUF			_IOW    (VPL_VOC_IOC_MAGIC, 14, DWORD)
#define VPL_VOC_IOC_DEQUEUE_BUF			_IOR    (VPL_VOC_IOC_MAGIC, 15, DWORD)

#define VPL_VOC_IOC_PIP_START			_IO     (VPL_VOC_IOC_MAGIC, 16)
#define VPL_VOC_IOC_PIP_STOP			_IO     (VPL_VOC_IOC_MAGIC, 17)
#define VPL_VOC_IOC_PIP_QUEUE_BUF		_IOW    (VPL_VOC_IOC_MAGIC, 18, DWORD)
#define VPL_VOC_IOC_PIP_DEQUEUE_BUF		_IOR    (VPL_VOC_IOC_MAGIC, 19, DWORD)
#define VPL_VOC_IOC_PIP_SET_IMAGE		_IOW    (VPL_VOC_IOC_MAGIC, 20, DWORD)

#define VPL_VOC_IOC_GET_FRAME_CNT		_IOR    (VPL_VOC_IOC_MAGIC, 21, DWORD)

#define VPL_VOC_IOC_MAX_NUMBER	21

/* ============================================================================================== */
#endif //__VPL_VOC_H__

/* ============================================================================================== */
