/*
 * $Header:$
 *
 * vpl_voc
 * Driver for VPL VOC
 *
 * Copyright (C) 2007-2012  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#ifndef __VPL_VOC_DRIVER_H__
#define __VPL_VOC_DRIVER_H__

/* ============================================================================================== */
#include <linux/interrupt.h>
#include <linux/mm.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/ioctl.h>
#include <linux/fs.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/irqdomain.h>
#include <linux/clk.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/cache.h>
#include <mach/platform.h>
#include <mach/irqs.h>


#include "vpl_voc.h"

/* ============================================================================================== */
#undef PDEBUG
#ifdef _DEBUG
	#ifdef __KERNEL__
		#define LOGLEVEL KERN_DEBUG
		#define PDEBUG(fmt, args...) printk(LOGLEVEL "VPL_VOC: " fmt, ## args)
	#else
		#define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
	#endif
#else
	#define PDEBUG(fmt, args...)
#endif

/* ============================================================================================== */
#define SYSC_CLK_EN_MMR (IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x98)
#define VPL_VOC_CLK_EN_NUM 0x12
#define VPL_VDAC_CLK_EN_NUM 0xe
#define SYSC_RST_CTRL_MMR (IO_ADDRESS(VPL_SYSC_MMR_BASE)+0x24)

#define VPL_VOC_MASTER_NUM	0x03
/* ============================================================================================== */
enum videobuf_state {
	BUF_STATE_DEQUEUED = 0,
	BUF_STATE_PREPARED,
	BUF_STATE_QUEUED,
	BUF_STATE_ACTIVE,
	BUF_STATE_DONE,
	BUF_STATE_ERROR,
};

/* ============================================================================================== */
enum vpl_voc_signal_polarity {
	ACTIVE_LOW, /* Oops, the datasheed defined high/law is "data puls" not "sync puls" */
	ACTIVE_HIGH,
};

enum vpl_voc_signal_edge {
	POSITIVE_EDGE_ALIGNED = 0,
	NEGATIVE_EDGE_ALIGNED = 2,
};

/* ============================================================================================== */
typedef struct vpl_voc_buf_info
{
	DWORD                   dwIndex;
	DWORD			dwFrameCount;
	struct list_head        queue;
	enum videobuf_state     state;
	BYTE                    *pbyYFrame;
	BYTE                    *pbyCbFrame;
	BYTE                    *pbyCrFrame;
} TVPLVOCBufInfo;

/* ============================================================================================== */
#define VOC_MODE_LEN 32
typedef struct vpl_voc_timing
{
	char  ConnectorName[VOC_MODE_LEN]; // Otus add
	char  name[VOC_MODE_LEN];
	int dwActiveWidth; /* In width */
	int dwActiveHeight; /* In height */
	int dwRefresh;
	int dwPixClock;

	int dwOutWidth;
	int dwOutHeight;
	int dwHsyncFrontPorch;
	int dwHsyncBackPorch;
	int dwVsyncFrontPorch;
	int dwVsyncBackPorch;

	int dwInterOutSPH;    /*Bt1120. interlace only */
	int dwInterF0Overlap;
	int dwInterF1Overlap;
	int dwInterF0Height;

	enum vpl_voc_signal_polarity dwHSyncPol;
	enum vpl_voc_signal_polarity dwVSyncPol;
	enum vpl_voc_signal_polarity dwBlankPol;
	enum vpl_voc_signal_edge dwPClkPol;

	bool bInterlaced;
} TVPLVOCTiming;

/* ============================================================================================== */
typedef struct vpl_voc_csc_matrix
{
	DWORD adwMatrix[3][3];
	DWORD adwOffset[3];
} TVPLVOCCSCMatrix;

/* ============================================================================================== */
typedef struct vpl_pllc_info
{
	DWORD dwVersion;
	DWORD dwReserved[8];
	DWORD dwPLLC4CTRL;
	DWORD dwPLLC4DIV;
} TVPLPLLCInfo;

/* ============================================================================================== */
typedef struct vocfb_osd_pos TVPLVOCOSDPOS;

/* ============================================================================================== */
typedef struct vpl_voc_dev_info
{
	volatile TVPLVOCInfo *ptMMRInfo;
	volatile TVPLPLLCInfo *ptPLLCMMRInfo;
	volatile DWORD *pdwSYSCVOCCtrlMMR;

	DWORD *pdwProfileClr;
	DWORD *pdwBandwidth;
	DWORD *pdwRGInterval;
	DWORD *pdwReqTimes;

#ifdef __PROFILE__
	DWORD dwBandwidth;
	DWORD dwRGInterval;
	DWORD dwReqTimes;
#endif //__PROFILE__
	DWORD dwIrq;
	spinlock_t lock;

	DWORD dwFrameCnt;

	wait_queue_head_t wq;

	TVPLVOCBufInfo atVOCBufInfo[VIDEO_MAX_FRAME];
	struct list_head queued_list;
	struct list_head done_list;
	TVPLVOCBufInfo *ptCur_Frm;
	TVPLVOCBufInfo *ptNext_Frm;
	BOOL bfirst_int;

	/*TODO pip buffer: ugly code by repeat above data */
	BOOL bpip_on;
	DWORD dwFrameCnt_pip;
	wait_queue_head_t wq_pip;
	TVPLVOCBufInfo atVOCBufInfo_pip[VIDEO_MAX_FRAME];
	struct list_head queued_list_pip;

	struct list_head done_list_pip;
	TVPLVOCBufInfo *ptCur_Frm_pip;
	TVPLVOCBufInfo *ptNext_Frm_pip;
	BOOL bfirst_int_pip;

	TVOCInitOptions tCurtOptions;

	struct clk *clk;
	int open_count;

} TVPLVOCDevInfo;

/* ============================================================================================== */
//struct voc_fb_device(overlay/osd) {
//	struct device   *dev; /* well, plateform device */
//	struct vocfb_mem_info mem_info;
//	struct vocfb_alpha_ctrl alpha_ctrl;
//	bool mem_initialized;
//	bool osd_is_on;
//	/* FB */
//	struct fb_info  *fb_info;
//	u32 palette[PALETTE_SIZE];
//	u32 pseudo_palette[16]; /* MEMO: For TRUECOLOR, Beethoven */
//
//	u8 padding[2];
//	/*MEMO :struct xxx pannel(provide sync) */
//};

/* ============================================================================================== */
DWORD VPL_VOC_GetDevInfoSize(void);
SCODE VPL_VOC_SetMMRInfo(HANDLE, volatile TVPLVOCInfo *, volatile TVPLPLLCInfo *ptPLLCMMRInfo, volatile DWORD *pdwSYSCVOCCtrlMMR);
DWORD VPL_VOC_GetMMRInfo(HANDLE);

SCODE VPL_VOC_InitProfile(HANDLE);
SCODE VPL_VOC_CloseProfile(HANDLE);
SCODE VPL_VOC_InitProfileInfo(TVPLVOCDevInfo *);

//SCODE VPL_VOC_GetProfileInfo(HANDLE, TVPLVOCObjInfo *, DWORD);
SCODE VPL_VOC_SetupProfile(TVPLVOCDevInfo *, DWORD, DWORD);

DWORD VPL_VOC_GetVersion(HANDLE);
//DWORD VPL_VOC_StartHead(HANDLE);
//void VPL_VOC_SetChipVersionInfo(HANDLE);
//void VPL_VOC_StartTail(HANDLE, DWORD, TVPLVOCInfo *);
void VPL_VOC_IntrEnable(HANDLE);
void VPL_VOC_IntrDisable(HANDLE);
void VPL_VOC_IntrClear(HANDLE);
void VPL_VOC_Reset(HANDLE);
void VPL_VOC_Open(HANDLE);
//DWORD VPL_VOC_ISRHead(HANDLE);
//void VPL_VOC_ISRTail(HANDLE, DWORD);
void VPL_VOC_Set_Saturation(HANDLE hDevInfo, DWORD dwValue);
void VPL_VOC_Set_Brightness(HANDLE hDevInfo, DWORD dwValue);
void VPL_VOC_Set_Contrast(HANDLE hDevInfo, DWORD dwValue);
void VPL_VOC_Set_CSC(HANDLE hDevInfo, TVPLVOCCSCMatrix *ptCSCTable);
void VPL_VOC_Set_Timing(HANDLE hDevInfo, const struct vpl_voc_timing *timing);
void VPL_VOC_Init(HANDLE hDevInfo, struct voc_init_options *ptInitOptions, bool keep_boot_settings);
SCODE VPL_VOC_Start(HANDLE hDevInfo);
void VPL_VOC_Stop(HANDLE hDevInfo);
int VPL_VOC_QBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf);
int VPL_VOC_DQBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf);
void VPL_VOC_ClearQBuf(HANDLE hDevInfo);
/* I80 Control */
int i80_init(HANDLE hDevInfo);
/* OSD Control*/
void VPL_VOC_Set_OSD_Addr(HANDLE hDevInfo, DWORD dwPaddr);
void VPL_VOC_Set_OSD_DISP(HANDLE hDevInfo, bool enabled, bool bgmode);
void VPL_VOC_Set_OSD_Image(HANDLE hDevInfo, DWORD dwWidth, DWORD dwHeight, DWORD dwStride);
void VPL_VOC_Set_OSD_Pos(HANDLE hDevInfo, TVPLVOCOSDPOS *ptOSDPos);
/* PIP */
SCODE VPL_VOC_PIP_START(HANDLE hDevInfo);
void VPL_VOC_PIP_STOP(HANDLE hDevInfo);
int VPL_VOC_PIP_QBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf);
int VPL_VOC_PIP_DQBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf);
void VPL_VOC_PIP_ClearQBuf(HANDLE hDevInfo);
void VPL_VOC_Set_PIP_Image(HANDLE hDevInfo, DWORD dwWidth, DWORD dwHeight, DWORD dwStride);
void VPL_VOC_Set_PIP_Pos(HANDLE hDevInfo, DWORD dwXPos, DWORD dwYPos);

/* ============================================================================================== */
void VPL_VOC_SetPalette(HANDLE hDevInfo, DWORD dwIndex, DWORD dwAlpha, DWORD dwYValue, DWORD dwCbValue, DWORD dwCrValue);
int vocfb_do_probe(HANDLE hDevInfo);
void vocfb_do_release(void);

int voc_connect_mgr_init(void);
void voc_connect_mgr_remove(void);
int voc_compute_pll_and_div(u32 pclk_target, u32 *f_estim, u32 *fb_div_p, u32 *ref_div_p, u32 *post_div_p, u32 *voc_div_p);
/* ============================================================================================== */
#endif //__VPL_VOC_DRIVER_H__

/* ============================================================================================== */
