/*
 * $Header:$
 *
 * Copyright (C) 2007-2012 VATICS Inc. All rights reserved.
 *
 * Description:
 *
 *
 *
 * $History:$
 *
 */
/* ============================================================================================== */
#include "vpl_voc_locals.h"
#include <linux/delay.h>

//dwI80TimingSetting
//dwI80WTCONData
//dwI80RTCONReg

#define I80_CONT_CMD_FLAG	(0x1 << 22)
#define I80_CMD_LEN_MASK	(0x3 << 20)
#define I80_DATA_LEN_MASK	(0xff << 8)
#define I80_CMPT_FLAG		(0x1 << 0)

/* VOC_I80_TIMING_SETTING */
#define I80_NDEX_ADDR_MSB_MASK	0xFFFF0000
#define I80_NDEX_ADDR_MSB_SHIFT 16
#define I80_NDEX_ADDR_MSB_SHIFT 16
#define I80_WBUF_RDY_FLAG	(0x1 << 9)


#define CMD_INDEX_ONE_BYTE 0x0
#define CMD_INDEX_TWO_BYTE 0x0
#define CMD_INDEX_THREE_BYTE 0x0
#define CMD_INDEX_FOUR_BYTE 0x0

#define CMD_TYPE_NOACT   0x0
#define CMD_TYPE_WR_REG  0x1
#define CMD_TYPE_RE_REG  0x2
#define CMD_TYPE_WR_SYS  0x3  /* Index(Command) only, No Data */
#define CMD_TYPE_NOP     0x4  /* NOP to interrupt other command */
#define CMD_TYPE_GRAM    0x5

struct i80_msg {
	u32 index;
	u32 len;
	u8  *buf;
};

struct i80_lcd_info {
	u32 cmd_index_width;
	u32 te_mode;
	u32 te_pol;
	u32 read_low_pulse_w;
	u32 read_high_pulse_w;
};
struct vpl_voc_subdev {
	struct i80_lcd_info lcd_info;

};

/* ============================================================================================== */
static int i80_cmd_wait_cmpt(volatile struct vpl_voc_info *ptMMRInfo)
{
	unsigned long curr;
	unsigned long finish = jiffies + 3 * HZ;

	do {
		curr = jiffies;
		if (ptMMRInfo->dwI80Ctrl & I80_CMPT_FLAG)
			cpu_relax();
		else
			return 0;
	} while (!time_after_eq(curr, finish));

	return -EBUSY;
}

/* ============================================================================================== */
static int i80_send_cmdargs(HANDLE hDevInfo, u32 cmd, int argc, u8 *argv)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile u32 reg_value;
	int i = 0;

	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD complete timeout\n");
		return -EBUSY;
	}

	do {} while(!(ptDevInfo->ptMMRInfo->dwI80Timing & I80_WBUF_RDY_FLAG));

	ptDevInfo->ptMMRInfo->dwI80WTCONData = argv[0];
	printk("write (%x) %x\n", cmd, (u32)ptDevInfo->ptMMRInfo->dwI80WTCONData);

	reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
	set_field(reg_value, VOC_I80_TIMING_CMD_MSB, (cmd >> 8)&0xFFFF);
	ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;
	printk("i80 timing %x\n", (u32)reg_value);

	reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
	set_field(reg_value, VOC_I80_CTRL_CMD_LSB, cmd & 0xFF);
	set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
	set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_WR_REG);
	set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 0);
	set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
	ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
	printk("i80 ctrl %x\n", (u32)reg_value);

	for (i = 1; i < argc; i++) {
		if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
			printk("Wait CMD complete timeout\n");
			return -EBUSY;
		}

		do {} while(!(ptDevInfo->ptMMRInfo->dwI80Timing & I80_WBUF_RDY_FLAG));
		ptDevInfo->ptMMRInfo->dwI80WTCONData = argv[i];
		printk("write (%x) %x\n", cmd, (u32)ptDevInfo->ptMMRInfo->dwI80WTCONData);

		reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
		set_field(reg_value, VOC_I80_TIMING_CMD_MSB, (cmd >> 8)&0xFFFF);
		ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;
		printk("i80 timing %x\n", (u32)reg_value);

		reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
		set_field(reg_value, VOC_I80_CTRL_CMD_LSB, cmd & 0xFF);
		set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
		set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_WR_REG);
		set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 1);
		set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
		ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
		printk("i80 ctrl %x\n", (u32)reg_value);
	}


	return i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
static int i80_read_cmdargs(HANDLE hDevInfo, u32 cmd, int argc, u8 *argv)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile u32 reg_value;
	int i = 0;

	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD complete timeout\n");
		return -EBUSY;
	}

	reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
	set_field(reg_value, VOC_I80_TIMING_CMD_MSB, (cmd >> 8)&0xFFFF);
	ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;
//	printk("i80 timing %x\n", (u32)reg_value);

	reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
	set_field(reg_value, VOC_I80_CTRL_CMD_LSB, cmd & 0xFF);
	set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
	set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_RE_REG);
	set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 0);
	set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
	ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
//	printk("i80 ctrl %x\n", (u32)reg_value);

	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD finis fail\n");
		return -EBUSY;
	}

	do {} while(!(ptDevInfo->ptMMRInfo->dwI80Timing & 0x100));
	argv[0] = ptDevInfo->ptMMRInfo->dwI80RTCONReg;
	printk("read (%x) %02x", cmd, (u32)argv[0]);

	for (i = 1; i < argc; i++) {
		reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
		set_field(reg_value, VOC_I80_CTRL_CMD_LSB, cmd & 0xFF);
		set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
		set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_RE_REG);
		set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 1);
		set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
		ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
//		printk("i80 ctrl %x\n", (u32)reg_value);

		if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
			printk("Wait CMD finis fail\n");
			return -EBUSY;
		}
		do {} while(!(ptDevInfo->ptMMRInfo->dwI80Timing & 0x100));
		argv[i] = ptDevInfo->ptMMRInfo->dwI80RTCONReg;
		printk(" %02x", (u32)argv[i]);
	}
	printk("\n");
	return 0;
}
/* ============================================================================================== */
static int i80_cmd_write(HANDLE hDevInfo, u32 index)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile u32 reg_value;
	u32 write_len = 0;

	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD complete timeout\n");
		return -EBUSY;
	}

	reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
	set_field(reg_value, VOC_I80_TIMING_CMD_MSB, (index >> 8)&0xFFFF);
	ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;
	printk("i80 timing %x\n", (u32)reg_value);

	reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
	set_field(reg_value, VOC_I80_CTRL_CMD_LSB, index & 0xFF);
	set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
	set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_WR_SYS);
	set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 0);
	set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
	ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
	printk("i80 ctrl %x\n", (u32)reg_value);

	return i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
static int i80_cmd_read(HANDLE hDevInfo, u32 index, u32 len)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile u32 reg_value;
	u32 read_len = 0;

	/* Check if pervios cmd complete */
	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD complete timeout\n");
		return -EBUSY;
	}

	reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
	set_field(reg_value, VOC_I80_TIMING_CMD_MSB, (index >> 8)&0xFFFF);
	ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;
//	printk("i80 timing %x\n", reg_value);

	reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
	set_field(reg_value, VOC_I80_CTRL_CMD_LSB, index & 0xFF);
	set_field(reg_value, VOC_I80_CTRL_DATA_LEN, len-1);
	set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_RE_REG);
	set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 0);
	set_field(reg_value, VOC_I80_CTRL_CMPT_FLAG, 0x1);
	ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;
//	printk("i80 ctrl %x\n", reg_value);

	if (i80_cmd_wait_cmpt(ptDevInfo->ptMMRInfo)) {
		printk("Wait CMD finis fail\n");
		return -EBUSY;
	}

	do {
		do {} while(!(ptDevInfo->ptMMRInfo->dwI80Timing & 0x100));
		printk("read in (%x) %x %x\n", index, (u32)ptDevInfo->ptMMRInfo->dwI80RTCONReg, ptDevInfo->ptMMRInfo->dwI80Ctrl);
		read_len+=4;
	} while (read_len<len);

	return 0;
}
struct regtabl {
	u16 cmd;
	u8 value[15];
	u32 num;
};

struct regtabl tbl[] = {
	{0xc8, {0xff, 0x93, 0x42}, 3}, // set EXTC
//	{0xB6, {0x0A, 0xA2, 0x1D, 0x04}, 4}, //Display Function Control
	{0x35, {0x00}, 1}, //Tearing Effect Line ON
	{0x36, {0x08}, 1}, //Memory Access Control //0x08?
	{0x3a, {0x66}, 1}, //Pixel Format Set
	{0xC0, {0x0f, 0x0f}, 2},
	{0xC1, {0x05}, 1}, //
	{0xC5, {0xDF}, 1}, //VCOM Control 1
	{0xb4, {0x02}, 1},
//	{0x2A, {0x00,0x00,0x01,0x3f}, 4},
//	{0x2B, {0x00,0x00,0x00,0xEf}, 4},
	{0xE0, {0x00, 0x08, 0x13, 0x08, 0x16, 0x09, 0x44, 0x67, 0x54, 0x06, 0x0c, 0x08, 0x24, 0x26, 0x0f}, 15},
	{0xE1, {0x00, 0x2a, 0x2f, 0x00, 0x0c, 0x01, 0x42, 0x22, 0x52, 0x05, 0x0e, 0x0d, 0x36, 0x38, 0x0f}, 15},
};
/* ============================================================================================== */
int i80_init(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile u32 reg_value;
	int i;
	u8 tmp[5] = {0,0,0,0,0};
	/* Reset I80 internal satus machine and count, DOESN'T clear MMR */
	set_field(ptDevInfo->ptMMRInfo->dwI80Ctrl, VOC_I80_CTRL_RESET, 0);
	printk("i80 reset\n");
	do {} while (ptDevInfo->ptMMRInfo->dwI80Ctrl & 0x80);
	printk("i80 reset done\n");
	/* Set Pixel Sequence */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_RGB_SEL, 0x0);

	/* Set TE mode */
	set_field(ptDevInfo->ptMMRInfo->dwI80Ctrl, VOC_I80_CTRL_TE_MODE, 0x0);

	/* Set Read timing */
	reg_value = ptDevInfo->ptMMRInfo->dwI80Timing;
	set_field(reg_value, VOC_I80_TIMING_RLPW, 0x3);
	set_field(reg_value, VOC_I80_TIMING_RHPW, 0x3);
	set_field(reg_value, VOC_I80_TIMING_CD_DELAY, 0x0);
	ptDevInfo->ptMMRInfo->dwI80Timing = reg_value;

	/* Set CMD propertise */
	set_field(ptDevInfo->ptMMRInfo->dwI80Ctrl, VOC_I80_CTRL_CMD_LEN, 0x0); /* 2 byte?*/

	i80_cmd_write(hDevInfo, 0x01);

	mdelay(1000);


	i80_read_cmdargs(hDevInfo, 0xd3, 5, tmp);
	//************* Start Initial Sequence **********//
	for (i = 0; i < ARRAY_SIZE(tbl); i++) {
		i80_send_cmdargs(hDevInfo, tbl[i].cmd, tbl[i].num, tbl[i].value);
	}

	i80_cmd_write(hDevInfo, 0x11);
	mdelay(1000);
	i80_cmd_write(hDevInfo, 0x11);
	mdelay(1000);
#if 0
	//*************Power On sequence ****************//
	mdelay(50); //Delay 50ms
	i80_cmd_write(hDevInfo, 0x0010, 0x000A, 2); // Set SAP,DSTB,STB
	i80_cmd_write(hDevInfo, 0x0011, 0x3B10, 2); // Set APON,PON,AON,VCI1EN,VC
	mdelay(50); // Delay 50ms
	i80_cmd_write(hDevInfo, 0x0012, 0x2131, 2); // Internal reference voltage= Vci;
	i80_cmd_write(hDevInfo, 0x0013, 0x7300, 2); // Set GVDD
	i80_cmd_write(hDevInfo, 0x0014, 0x6848, 2); // Set VCOMH/VCOML voltage
	//------------------------ Set GRAM area --------------------------------//
	i80_cmd_write(hDevInfo, 0x30, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x31, 0xDB00, 2);
	i80_cmd_write(hDevInfo, 0x32, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x33, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x34, 0xDB00, 2);
	i80_cmd_write(hDevInfo, 0x35, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x36, 0xAF00, 2);
	i80_cmd_write(hDevInfo, 0x37, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x38, 0xDB00, 2);
	i80_cmd_write(hDevInfo, 0x39, 0x0000, 2);
	// ----------- Adjust the Gamma Curve ----------//
	i80_cmd_write(hDevInfo, 0x0050, 0x0004, 2);
	i80_cmd_write(hDevInfo, 0x0051, 0x0B08, 2);
	i80_cmd_write(hDevInfo, 0x0052, 0x0C0E, 2);
	i80_cmd_write(hDevInfo, 0x0053, 0x0301, 2);//0x0103
	i80_cmd_write(hDevInfo, 0x0054, 0x0101, 2);//0c0e
	i80_cmd_write(hDevInfo, 0x0055, 0x080B, 2);
	i80_cmd_write(hDevInfo, 0x0056, 0x0400, 2);
	i80_cmd_write(hDevInfo, 0x0057, 0x0103, 2);
	i80_cmd_write(hDevInfo, 0x0058, 0x0000, 2);
	i80_cmd_write(hDevInfo, 0x0059, 0x0000, 2);

	mdelay(50); // Delay 50ms
	i80_cmd_write(hDevInfo, 0x0007, 0x1710, 2);

	/* Exit Stand by */
//	i80_cmd_write(hDevInfo, 0x0010, 0x000A, 2); // Exit Sleep/ Standby mode
//	i80_cmd_write(hDevInfo, 0x0011, 0x3810, 2); // // Set APON,PON,AON,VCI1EN,VC
//	delay(50)
//	i80_cmd_write(hDevInfo, 0x0007, 0x1710, 2); // Set D1=0, D0=1
#endif
//	i80_read_cmdargs(hDevInfo, 0x04, 4, tmp);
//	i80_read_cmdargs(hDevInfo, 0x09, 5, tmp);
//	i80_read_cmdargs(hDevInfo, 0x0a, 2, tmp);
//	i80_read_cmdargs(hDevInfo, 0x0B, 2, tmp);
//	i80_read_cmdargs(hDevInfo, 0x0C, 2, tmp);
//	i80_read_cmdargs(hDevInfo, 0x51, 2, tmp);
//	i80_read_cmdargs(hDevInfo, 0x52, 2, tmp);
//	i80_read_cmdargs(hDevInfo, 0x2A, 4, tmp);
//	i80_read_cmdargs(hDevInfo, 0xC8, 3, tmp);
	i80_read_cmdargs(hDevInfo, 0x35, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0x09, 5, tmp);
	i80_read_cmdargs(hDevInfo, 0xC0, 3, tmp);
	i80_read_cmdargs(hDevInfo, 0xC1, 2, tmp);
#if 0
	i80_read_cmdargs(hDevInfo, 0x3, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0x8, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0xC, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0xF, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0x20, 2, tmp);
	i80_read_cmdargs(hDevInfo, 0x21, 2, tmp);

	i80_read_cmdargs(hDevInfo, 0x0010, 2, tmp); // Set SAP,DSTB,STB
	i80_read_cmdargs(hDevInfo, 0x0011, 2, tmp); // Set APON,PON,AON,VCI1EN,VC
	i80_read_cmdargs(hDevInfo, 0x0012, 2, tmp); // Internal reference voltage= Vci;
	i80_read_cmdargs(hDevInfo, 0x0013, 2, tmp); // Set GVDD
	i80_read_cmdargs(hDevInfo, 0x0014, 2, tmp); // Set VCOMH/VCOML voltage
	i80_read_cmdargs(hDevInfo, 0x30,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x31,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x32,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x33,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x34,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x35,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x36,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x37,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x38,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x39,2, tmp);
	i80_read_cmdargs(hDevInfo, 0x0050, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0051, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0052, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0053, 2,tmp);//0x0103
	i80_read_cmdargs(hDevInfo, 0x0054, 2,tmp);//0c0e
	i80_read_cmdargs(hDevInfo, 0x0055, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0056, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0057, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0058, 2,tmp);
	i80_read_cmdargs(hDevInfo, 0x0059, 2,tmp);

	set_field(ptDevInfo->ptMMRInfo->dwI80Ctrl, VOC_I80_CTRL_RESET, 1);
	do {} while (ptDevInfo->ptMMRInfo->dwI80Ctrl & 0x80);
#endif
	i80_cmd_write(hDevInfo, 0x29);
	mdelay(1000);
	i80_cmd_write(hDevInfo, 0x2C);
	reg_value = ptDevInfo->ptMMRInfo->dwI80Ctrl;
	set_field(reg_value, VOC_I80_CTRL_CMD_LSB, 0x2c);
	set_field(reg_value, VOC_I80_CTRL_CMD_TYPE, CMD_TYPE_GRAM);
	set_field(reg_value, VOC_I80_CTRL_DATA_LEN, 0);
	set_field(reg_value, VOC_I80_CTRL_CONT_CMD_FLAG, 0);
	reg_value |= (1<<6) | 0x1;
	printk("start %x\n", reg_value);
	ptDevInfo->ptMMRInfo->dwI80Ctrl = reg_value;

	return 0;
}
