/*
 * $Header:$
 *
 * Copyright 2007-2012 VATICS Inc. All rights reserved.
 *
 * Description:
 *
 *	Generated by Code Generator Version 4.4.0.11.
 *
 * $History:$
 *
 */

/* ============================================================================================== */
#include <linux/fb.h>
#include "vpl_voc_locals.h"
#include "tv_encoder.h"
#include "hdmi_tx.h"
/* ============================================================================================== */
//#define __HDMI
//#define __I80
#define __TV
#ifdef __TV
extern struct tv_encoder_device tv_encoder_ops;
static struct tv_encoder_device *TVEncoder = &tv_encoder_ops;
#endif
#ifdef __HDMI
extern struct hdmi_tx_device hdmi_tx_ops;
static struct hdmi_tx_device *HDMITX = &hdmi_tx_ops;
#endif
extern struct voc_device_mgr voc_dev_mgr;
#define BURST_NUM 120 //30//46 //120
#define PIP_MODE 0x0 //0x4
#define PIP_LOCK 0x2
/* ============================================================================================== */
static TVPLVOCCSCMatrix default_itu601_csc = {
	{
		{298, 0, 409},
		{298, 100, 208},
		{298, 516, 0}
	},
	{16, 128, 128}
};

/* ============================================================================================== */
DWORD VPL_VOC_GetDevInfoSize(void)
{
	return sizeof(TVPLVOCDevInfo);
}

/* ============================================================================================== */
SCODE VPL_VOC_SetMMRInfo(HANDLE hDevInfo, volatile TVPLVOCInfo *ptMMRInfo, volatile TVPLPLLCInfo *ptPLLCMMRInfo, volatile DWORD *pdwSYSCVOCCtrlMMR)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo = ptMMRInfo;
	ptDevInfo->ptPLLCMMRInfo = ptPLLCMMRInfo;
	ptDevInfo->pdwSYSCVOCCtrlMMR = pdwSYSCVOCCtrlMMR;

	if ((ptDevInfo->ptMMRInfo->dwVersion&0xFF000000) == 0)
	{
		PDEBUG("Device does not exist !!\n");
		return S_FAIL;
	}

	PDEBUG("Remapped base address = 0x%08X\n", (int)ptDevInfo->ptMMRInfo);

	return S_OK;
}

/* ============================================================================================== */
DWORD VPL_VOC_GetMMRInfo(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	return (DWORD)(ptDevInfo->ptMMRInfo);
}

/* ============================================================================================== */
SCODE VPL_VOC_InitProfile(HANDLE hDevInfo)
{
#ifdef __PROFILE__
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD), "VPL_VOC Profile Clear");
	ptDevInfo->pdwProfileClr = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x108), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_VOC Bandwidth");
	ptDevInfo->pdwBandwidth = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_VOC_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_VOC Request Grant Interval");
	ptDevInfo->pdwRGInterval = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x148+((VPL_VOC_MASTER_NUM-1)<<2)), sizeof(DWORD));

	request_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD), "VPL_VOC Request Times");
	ptDevInfo->pdwReqTimes = (DWORD *)ioremap((int)(VPL_AHBC_1_MMR_BASE+0x184+((VPL_VOC_MASTER_NUM-1)<<2)), sizeof(DWORD));

#endif //__PROFILE__

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_VOC_CloseProfile(HANDLE hDevInfo)
{
#ifdef __PROFILE__
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	if (ptDevInfo->pdwProfileClr != NULL)
	{
		iounmap(ptDevInfo->pdwProfileClr);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x108, sizeof(DWORD));
	}

	if (ptDevInfo->pdwBandwidth != NULL)
	{
		iounmap(ptDevInfo->pdwBandwidth);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x10C+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->pdwRGInterval != NULL)
	{
		iounmap(ptDevInfo->pdwRGInterval);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x148+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD));
	}

	if (ptDevInfo->pdwReqTimes != NULL)
	{
		iounmap(ptDevInfo->pdwReqTimes);
		release_mem_region(VPL_AHBC_1_MMR_BASE+0x184+((VPL_VOC_MASTER_NUM-1)<<2), sizeof(DWORD));
	}
#endif //__PROFILE__

	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_VOC_InitProfileInfo(TVPLVOCDevInfo *ptDevInfo)
{
#ifdef __PROFILE__
	ptDevInfo->dwBandwidth = 0;
	ptDevInfo->dwRGInterval = 0;
	ptDevInfo->dwReqTimes = 0;
#endif //__PROFILE__
	return S_OK;
}

/* ============================================================================================== */
SCODE VPL_VOC_SetupProfile(TVPLVOCDevInfo *ptDevInfo, DWORD dwArg, DWORD dwCmd)
{
#ifdef __PROFILE__
	int scError = 0;
	switch (dwCmd)
	{
		case VPL_VOC_IOC_GET_BANDWIDTH:
			scError = copy_to_user((DWORD *)dwArg, ptDevInfo->pdwBandwidth, sizeof(DWORD));
			break;
		case VPL_VOC_IOC_GET_RG_INTERVAL:
			scError = copy_to_user((DWORD *)dwArg, ptDevInfo->pdwRGInterval, sizeof(DWORD));
			break;
		case VPL_VOC_IOC_GET_REQ_TIMES:
			scError = copy_to_user((DWORD *)dwArg, ptDevInfo->pdwReqTimes, sizeof(DWORD));
			break;
		case VPL_VOC_IOC_CLEAR_PROFILE:
			writel((0x1<<VPL_VOC_MASTER_NUM), ptDevInfo->pdwProfileClr);
			break;
		default:
			return S_FAIL;
	}
#endif //__PROFILE__

	return S_OK;
}

/* ============================================================================================== */
DWORD VPL_VOC_GetVersion(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	return ptDevInfo->ptMMRInfo->dwVersion;
}

/* ============================================================================================== */
void VPL_VOC_IntrEnable(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl | 0x00000002;

	PDEBUG("Interrupt enabled !!\n");
}

/* ============================================================================================== */
void VPL_VOC_IntrDisable(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFD;

	PDEBUG("Interrupt disabled !!\n");
}

/* ============================================================================================== */
void VPL_VOC_IntrClear(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwCtrl = ptDevInfo->ptMMRInfo->dwCtrl & 0xFFFFFFFE;

	PDEBUG("Interrupt cleared !!\n");
}

/* ============================================================================================== */
void VPL_VOC_Reset(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	PDEBUG("Enter Reset function...\n");

	writel(readl(SYSC_RST_CTRL_MMR)&~(1<<16), SYSC_RST_CTRL_MMR);
	writel(readl(SYSC_RST_CTRL_MMR)|(1<<16), SYSC_RST_CTRL_MMR);

	ptDevInfo->ptMMRInfo->dwCtrl = 0x30000000; /* voc dpi, always open now*/

	PDEBUG("Exit Reset function !!\n");
}

/* ============================================================================================== */
void VPL_VOC_Open(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	int i;

	init_waitqueue_head(&ptDevInfo->wq);
	init_waitqueue_head(&ptDevInfo->wq_pip);

	for (i = 0; i < VIDEO_MAX_FRAME; i++) {
        	ptDevInfo->atVOCBufInfo[i].state = BUF_STATE_DEQUEUED;
		ptDevInfo->atVOCBufInfo_pip[i].state = BUF_STATE_DEQUEUED;
	}
	INIT_LIST_HEAD(&ptDevInfo->queued_list);
	INIT_LIST_HEAD(&ptDevInfo->done_list);

	INIT_LIST_HEAD(&ptDevInfo->queued_list_pip);
	INIT_LIST_HEAD(&ptDevInfo->done_list_pip);

	spin_lock_init(&ptDevInfo->lock);
	ptDevInfo->ptCur_Frm = ptDevInfo->ptNext_Frm = NULL;
	ptDevInfo->ptCur_Frm_pip = ptDevInfo->ptNext_Frm_pip = NULL;
	ptDevInfo->dwFrameCnt = 0;
	ptDevInfo->dwFrameCnt_pip = 0;
}

/* ============================================================================================== */
void VPL_VOC_Set_Saturation(HANDLE hDevInfo, DWORD dwValue)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	set_field(ptDevInfo->ptMMRInfo->dwSBCCtrl, VOC_SBC_SATURATION, dwValue);
}

/* ============================================================================================== */
void VPL_VOC_Set_Brightness(HANDLE hDevInfo, DWORD dwValue)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	set_field(ptDevInfo->ptMMRInfo->dwSBCCtrl, VOC_SBC_BRIGHTNESS, dwValue);
}

/* ============================================================================================== */
void VPL_VOC_Set_Contrast(HANDLE hDevInfo, DWORD dwValue)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	set_field(ptDevInfo->ptMMRInfo->dwSBCCtrl, VOC_SBC_CONTRAST, dwValue);
}

/* ============================================================================================== */
void VPL_VOC_Set_CSC(HANDLE hDevInfo, TVPLVOCCSCMatrix *ptCSCMatrix)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	/*Oops, be careful, don't confuse MMR's naming and filed's naming, both "coeffx" in datasheet */
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff0, VOC_CSC_COEFF0, ptCSCMatrix->adwMatrix[0][0]);
	/* ptCSCMatrix->adwMatrix[0][1] is 0, can't change */
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff0, VOC_CSC_COEFF1, ptCSCMatrix->adwMatrix[0][2]);
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff0, VOC_CSC_COEFF2, ptCSCMatrix->adwMatrix[1][0]);

	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff1, VOC_CSC_COEFF3, ptCSCMatrix->adwMatrix[1][1]);
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff1, VOC_CSC_COEFF4, ptCSCMatrix->adwMatrix[1][2]);
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff1, VOC_CSC_COEFF5, ptCSCMatrix->adwMatrix[2][0]);

	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff2, VOC_CSC_COEFF6, ptCSCMatrix->adwMatrix[2][1]);
	/* ptCSCMatrix->adwMatrix[2][2] is 0, can't change */

	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff2, VOC_CSC_YOFFSET, ptCSCMatrix->adwOffset[0]);
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff2, VOC_CSC_CBOFFSET, ptCSCMatrix->adwOffset[1]);
	set_field(ptDevInfo->ptMMRInfo->dwYCbCr2RGBCoeff2, VOC_CSC_CROFFSET, ptCSCMatrix->adwOffset[2]);
}

/* ============================================================================================== */
void VPL_VOC_SetPalette(HANDLE hDevInfo, DWORD dwIndex, DWORD dwAlpha, DWORD dwYValue, DWORD dwCbValue, DWORD dwCrValue)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile DWORD dwValue = 0;

	set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_PALETTE_INDEX, dwIndex);

	set_field(dwValue, VOC_OSD_PALETTE_DATA_ALPHA, dwAlpha);
	set_field(dwValue, VOC_OSD_PALETTE_DATA_Y, dwYValue);
	set_field(dwValue, VOC_OSD_PALETTE_DATA_CB, dwCbValue);
	set_field(dwValue, VOC_OSD_PALETTE_DATA_CR, dwCrValue);
	ptDevInfo->ptMMRInfo->dwIndexOSDPalette = dwValue;
}

/* ============================================================================================== */
static void VPL_VOC_PLLC_Config(TVPLVOCDevInfo *ptDevInfo, u32 plldiv, u32 voc_clk_div, bool fast_slewrate)
{
#define VDAC_BG_CTRL  0x04
#define VDAC_LDO_CTRL 0x08
	volatile TVPLPLLCInfo *ptPLLCMMRInfo = ptDevInfo->ptPLLCMMRInfo;
	struct voc_device_mgr *mgr = &voc_dev_mgr;
	EVideoSignalFormat eOutSignalFormat = mgr->curt_connector->signal_format;

	void __iomem *vdac_base;
	int limit = 10;
	u32 sys_voc;

	writel(readl(SYSC_CLK_EN_MMR)|(0x1<<VPL_VDAC_CLK_EN_NUM), SYSC_CLK_EN_MMR);
	vdac_base = ioremap(VPL_VDAC_MMR_BASE, SZ_4K);

	ptPLLCMMRInfo->dwPLLC4DIV = plldiv;
	ptPLLCMMRInfo->dwPLLC4CTRL = 0x1;

	/*Wait for PLL Update Done and Lock*/
	while(limit--) {
		if ((ptPLLCMMRInfo->dwPLLC4CTRL & 0x31) == 0x30)
			break;
		mdelay(10);
	}
	if (limit < 0)
		PDEBUG("VPL_VOC: Can't lock stable PLL clock output for a limited time\n");

	/* Set SYSC VOC Ctrl */
	sys_voc = *ptDevInfo->pdwSYSCVOCCtrlMMR;
	sys_voc &= ~0x110010F;

	/* Set Pixel Clock Divider */
	sys_voc |= voc_clk_div;

	/* set srgb/I80 output and div3 clock source */
	if (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_SRGB)
		sys_voc |= 0x100;

	if (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_I80)
		sys_voc |= 0x100100;

	/* Set pad slew rate for high frequency clock */
	if (fast_slewrate)
		sys_voc |= 0x1000000;

	/* Restart VOC to sync clock phase */
	*ptDevInfo->pdwSYSCVOCCtrlMMR = sys_voc | 0x10;
	*ptDevInfo->pdwSYSCVOCCtrlMMR = sys_voc;

#if 1   //vdac move to standalone
	writel(0x1, vdac_base+VDAC_BG_CTRL);
	writel(0x1, vdac_base+VDAC_LDO_CTRL);

	limit = 10;
	while(limit--) {
		if (readl(vdac_base+VDAC_BG_CTRL) & 0x80000000)
			break;
		mdelay(10);
	}

	if (limit < 0)
		PDEBUG("Dac BG not good\n");
#endif
}

/* ============================================================================================== */
static void VPL_VOC_Set_PCLK(TVPLVOCDevInfo *ptDevInfo, DWORD dwPixelClk)
{
	u32 pclk_out;
	u32 pll_fb, pll_ref, pll_div, voc_div;
	int ret;

	DWORD dwPClkDiv = 0;
	DWORD dwPLLRatio;

	ret = voc_compute_pll_and_div(dwPixelClk, &pclk_out, &pll_fb, &pll_ref, &pll_div, &voc_div);

	if (ret) {
		PDEBUG("Can't find PLL parameters for required Pixel Clock %d\n", dwPixelClk);
		return;
	}

	dwPLLRatio = ((pll_fb - 1) << 16) | ((pll_div - 1) << 8) | (pll_ref - 1);
	dwPClkDiv = (voc_div - 1) & 0xF;

	PDEBUG("request PCLK: %d\n", dwPixelClk);
	PDEBUG("actual  PCLK: %d\n", pclk_out);
	PDEBUG("pll_fb %d\n", pll_fb);
	PDEBUG("pll_ref %d\n", pll_ref);
	PDEBUG("pll_div %d\n", pll_div);
	PDEBUG("voc_div %d\n", voc_div);
	PDEBUG("dwPLLRatio %08x\n", dwPLLRatio);
	PDEBUG("dwPClkDiv %08x\n", dwPClkDiv);

	/*TODO: set slew rate by frequency */
	VPL_VOC_PLLC_Config(ptDevInfo, dwPLLRatio, dwPClkDiv, 0);
}

/* ============================================================================================== */
void VPL_VOC_Set_Timing(HANDLE hDevInfo, const struct vpl_voc_timing *timing)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile DWORD dwValue = 0;
	PDEBUG("timings %d %d %d %d %d %d %d %d %d %d %d %d %d %d %s %s %s %s %d\n",
			timing->dwActiveWidth,
			timing->dwActiveHeight,
			timing->dwRefresh,
			timing->dwPixClock,
			timing->dwOutWidth,
			timing->dwOutHeight,
			timing->dwHsyncFrontPorch,
			timing->dwHsyncBackPorch,
			timing->dwVsyncFrontPorch,
			timing->dwVsyncBackPorch,
			timing->dwInterOutSPH,
			timing->dwInterF0Overlap,
			timing->dwInterF1Overlap,
			timing->dwInterF0Height,
			(timing->dwHSyncPol == ACTIVE_HIGH)?"ACTIVE_HIGH":"ACTIVE_LOW",
			(timing->dwVSyncPol == ACTIVE_HIGH)?"ACTIVE_HIGH":"ACTIVE_LOW",
			(timing->dwBlankPol == ACTIVE_HIGH)?"ACTIVE_HIGH":"ACTIVE_LOW",
			(timing->dwPClkPol == POSITIVE_EDGE_ALIGNED)?"POSITIVE_EDGE_ALIGNED":"NEGATIVE_EDGE_ALIGNED",
			timing->bInterlaced
	      );
	/* Total size */
	set_field(dwValue, VOC_OUT_SIZE_WIDTH, timing->dwOutWidth);
	set_field(dwValue, VOC_OUT_SIZE_HEIGHT, timing->dwOutHeight);
	ptDevInfo->ptMMRInfo->dwOutSize = dwValue;
	/* Active size */
	set_field(dwValue, VOC_IN_SIZE_WIDTH, timing->dwActiveWidth);
	set_field(dwValue, VOC_IN_SIZE_HEIGHT, timing->dwActiveHeight);
	ptDevInfo->ptMMRInfo->dwInSize = dwValue;
	/* HSync */
	dwValue = 0;
	set_field(dwValue, VOC_HSYNC_CTRL_DELAY_END, timing->dwHsyncFrontPorch);
	set_field(dwValue, VOC_HSYNC_CTRL_DELAY_START, timing->dwHsyncBackPorch | 0x800);
	set_field(dwValue, VOC_HSYNC_CTRL_POLARITY, timing->dwHSyncPol);
	ptDevInfo->ptMMRInfo->dwHSyncCtrl = dwValue;
	/* VSync */
	dwValue = 0;
	set_field(dwValue, VOC_VSYNC_CTRL_DELAY_END, timing->dwVsyncFrontPorch);
	set_field(dwValue, VOC_VSYNC_CTRL_DELAY_START, timing->dwVsyncBackPorch | 0x800);
	set_field(dwValue, VOC_VSYNC_CTRL_POLARITY, timing->dwVSyncPol);
	set_field(dwValue, VOC_VSYNC_CTRL_INTERLACED, timing->bInterlaced);
	ptDevInfo->ptMMRInfo->dwVSyncCtrl = dwValue;

	/* Blank Pol*/
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_BLANK_POL, timing->dwBlankPol);

	/* PClk Pol*/
	dwValue = *ptDevInfo->pdwSYSCVOCCtrlMMR;
	dwValue &= ~0x3000;
	dwValue |= (timing->dwPClkPol << 12);
	*ptDevInfo->pdwSYSCVOCCtrlMMR = dwValue;

	/* data lock */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_CBCR_DATA_LOCK, 1);
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_LC_DATA_LOCK, 1);

	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_LK_GATING_BPSS, 1);
	/* Set Out size ctrl, only have effect in CCIR656 interlace or BT1120 interlace mode */
	dwValue = 0;
	set_field(dwValue, VOC_OUT_SIZE_CTRL_F0_OLAP, timing->dwInterF0Overlap);
	set_field(dwValue, VOC_OUT_SIZE_CTRL_F1_OLAP, timing->dwInterF1Overlap);
	set_field(dwValue, VOC_OUT_SIZE_CTRL_F0_HEIGHT, timing->dwInterF0Height);
	ptDevInfo->ptMMRInfo->dwOutSizeCtrl =  dwValue;

	ptDevInfo->ptMMRInfo->dwIndexOSDCtrl = timing->dwInterOutSPH<<16;
	/* Set Pixel Clock */
	VPL_VOC_Set_PCLK(ptDevInfo, timing->dwPixClock);
}

/* ============================================================================================== */
static void VPL_VOC_Set_OutFormat(HANDLE hDevInfo, EVideoSignalFormat eOutSigformat)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	volatile DWORD dwValue = ptDevInfo->ptMMRInfo->dwCtrl;

	dwValue &= 0xFFFF1FBF; /*clear bit 13:15, bit 6*/

	switch (eOutSigformat)
	{
		case VIDEO_SIGNAL_FORMAT_INTERLACE_CCIR656:
			set_field(dwValue, VOC_CTRL_OUT_FORMAT, 0x1);
			break;
		case VIDEO_SIGNAL_FORMAT_PROGRESSIVE_RAW_16BITS:
		case VIDEO_SIGNAL_FORMAT_PROGRESSIVE_BT1120:
		case VIDEO_SIGNAL_FORMAT_INTERLACE_BT1120: /* 0x34 VSYNC_CTRL INTERLACED was set when set timing */
		case VIDEO_SIGNAL_FORMAT_INTERLACE_RAW_16BITS: /* 0x34 VSYNC_CTRL INTERLACED was set when set timing */
			set_field(dwValue, VOC_CTRL_BT1120P_EN, 0x1);
			break;
		case VIDEO_SIGNAL_FORMAT_RGB24:
			set_field(dwValue, VOC_CTRL_OUT_FORMAT, 0x0);
			break;
		case VIDEO_SIGNAL_FORMAT_I80:
			set_field(dwValue, VOC_CTRL_I80_EN, 0x1);
			break;
		case VIDEO_SIGNAL_FORMAT_SRGB:
			set_field(dwValue, VOC_CTRL_SRGB_EN, 0x1);
			break;
		default:
			PDEBUG("Unsupport format\n");
	}
	ptDevInfo->ptMMRInfo->dwCtrl = dwValue;
}

/* ============================================================================================== */
void VPL_VOC_Init(HANDLE hDevInfo, struct voc_init_options *ptInitOptions, bool keep_boot_settings)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	struct voc_device_mgr *mgr = &voc_dev_mgr;
	EVideoSignalFormat eOutSignalFormat = mgr->curt_connector->signal_format;
	DWORD dwHwStride = ptInitOptions->dwInStride;

	/* Setup Default SBC */
	VPL_VOC_Set_Brightness(hDevInfo, 0);
	VPL_VOC_Set_Contrast(hDevInfo, 0);
	VPL_VOC_Set_Saturation(hDevInfo, 128);

	/* Setup Default Color Space Conversion Matrix */
	VPL_VOC_Set_CSC(hDevInfo, &default_itu601_csc);

	/* Setup Input format */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_IN_FORMAT, (ptInitOptions->eInPixFormat == YUV422)?1:0);

	/* Setup Input buffer stride */
	if ((eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_CCIR656) ||
		(eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_BT1120) ||
		(eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_RAW) ||
		(eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_RAW_16BITS))	{
		dwHwStride = (ptInitOptions->dwInStride << 1);
	}

	set_field(ptDevInfo->ptMMRInfo->dwStrideSetting, VOC_IN_STRIDE, dwHwStride);
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_BURST_NUM, BURST_NUM);

	/* Decompression rate */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_MCMPR_CFG, ptInitOptions->dwSrcMcmprMode);
	set_field(ptDevInfo->ptMMRInfo->dwPIPCtrl, VOC_PIP_CTRL_MCMPR_CFG, ptInitOptions->dwPIPSrcMcmprMode);

	/* Setup Output Signal Format */
	VPL_VOC_Set_OutFormat(hDevInfo, eOutSignalFormat);
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_OUTPIN_SEL, mgr->curt_connector->data_arrangement);
	if ((eOutSignalFormat == VIDEO_SIGNAL_FORMAT_RGB24) ||
	    (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_I80) ||
	    (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_SRGB)) {
		set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_RGB_SEL, mgr->curt_connector->color_order);
	}

	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_OUTPIN_SEL, mgr->curt_connector->data_arrangement);

	/* Setup Output Signal Timings */
	VPL_VOC_Set_Timing(hDevInfo, &mgr->curt_mode);
	ptDevInfo->tCurtOptions = *ptInitOptions;

#ifdef __I80
	if(!keep_boot_settings)
	{
	    ptDevInfo->ptMMRInfo->dwI80Ctrl = 0;
	    ptDevInfo->ptMMRInfo->dwI80Timing = 0;
	}

	if(!keep_boot_settings && (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_I80))
	{
	    i80_init(hDevInfo);
	}
#endif
}

/* ============================================================================================== */
static void VPL_VOC_Set_Connector(TVOCInitOptions *ptCurtOpt)
{
	struct voc_device_mgr *mgr = &voc_dev_mgr;
	struct voc_connector *curt_connector;
	struct vpl_voc_timing *curt_mode;

	curt_connector = mgr->curt_connector;
	curt_mode = &mgr->curt_mode;

	if (curt_connector == NULL)
		return;

	if (sysfs_streq(curt_connector->name, "Composite")) {
		int dwTVStdMode = 0;
		if (sysfs_streq(curt_mode->name, "720x480i"))
			dwTVStdMode = 0;
		else if (sysfs_streq(curt_mode->name, "720x576i"))
			dwTVStdMode = 1;
		else if (sysfs_streq(curt_mode->name, "960x480i"))
			dwTVStdMode = 2;
		else if (sysfs_streq(curt_mode->name, "960x576i"))
			dwTVStdMode = 3;
		TVEncoder->open(dwTVStdMode);
	}
#if 0
	else 	if (sysfs_streq(curt_connector->name, "HDMI-B")) {
		/* Do nothing for internal HDMI*/
	} else {
		curt_connector->setup(curt_connector);
	}
#endif
#ifdef __HDMI //external HDMI Tx, don't need it now.
	enum CEA_VID vid = ((int)ptCurtTimings - (int)voc_cea_modes)/sizeof(struct vpl_voc_timing);
	if (ptCurtOpt->eOutSignalFormat == VIDEO_SIGNAL_FORMAT_RGB24)
	{
		HDMITX->open(vid, ptCurtTimings->dwPixClock/1000, FORMAT_RGB444, INSIG_SYNCSEP, FORMAT_RGB444);
	}
	else if ((ptCurtOpt->eOutSignalFormat == VIDEO_SIGNAL_FORMAT_PROGRESSIVE_RAW_16BITS) ||
		(ptCurtOpt->eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_RAW_16BITS))
	{
		HDMITX->open(vid, ptCurtTimings->dwPixClock/1000, FORMAT_YUV422, INSIG_SYNCSEP, FORMAT_RGB444);
	}
	else if ((ptCurtOpt->eOutSignalFormat == VIDEO_SIGNAL_FORMAT_PROGRESSIVE_BT1120) ||
		 (ptCurtOpt->eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_BT1120))
	{
		HDMITX->open(vid, ptCurtTimings->dwPixClock/1000, FORMAT_YUV422, INSIG_SYNCEMB, FORMAT_RGB444);
	}
#endif
}

/* ============================================================================================== */
SCODE VPL_VOC_Start(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	if (list_empty(&ptDevInfo->queued_list) && ptDevInfo->ptCur_Frm == NULL) {
		PDEBUG("VPL_VOC_IOC_START: At least ADD one buffer before start\n");
		return -EINVAL;
	}
	if (ptDevInfo->ptCur_Frm == NULL)
	{
		ptDevInfo->ptCur_Frm = ptDevInfo->ptNext_Frm = list_first_entry(&ptDevInfo->queued_list, TVPLVOCBufInfo, queue);

		list_del_init(&ptDevInfo->ptCur_Frm->queue);
		ptDevInfo->ptCur_Frm->state = BUF_STATE_ACTIVE;

		ptDevInfo->ptMMRInfo->dwYBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyYFrame);
		ptDevInfo->ptMMRInfo->dwCbBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyCbFrame);
		ptDevInfo->ptMMRInfo->dwCrBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyCrFrame);
		ptDevInfo->ptMMRInfo->dwYBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyYFrame);
		ptDevInfo->ptMMRInfo->dwCbBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyCbFrame);
		ptDevInfo->ptMMRInfo->dwCrBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm->pbyCrFrame);

		ptDevInfo->bfirst_int = 1;
	}

	/* Enable Complete ACK to trigger ISR */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_OP_CMPT_ACK_EN, 1);

	/* Enable VOC Operation */
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_OP_EN, 1);

	/* some encoder need to reset after signal are provided */
	VPL_VOC_Set_Connector(&ptDevInfo->tCurtOptions);

	return S_OK;
}

/* ============================================================================================== */
void VPL_VOC_Stop(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	/*PAD Disable */
	//writel(readl(SYSC_PAD_EN_CTRL_6)&(~(0x7<<24)), SYSC_PAD_EN_CTRL_6_MMR);
	/*Stop VOC Operation*/
	set_field(ptDevInfo->ptMMRInfo->dwCtrl, VOC_CTRL_LK_GATING_BPSS, 1);
	udelay(100);
	ptDevInfo->ptMMRInfo->dwCtrl &= 0xFFFFFFFB;
}

/* ============================================================================================== */
int VPL_VOC_QBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf)
{
	int ret = 0;
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	TVPLVOCBufInfo *ptVOCBufInfo;
	unsigned long flags = 0;

	spin_lock_irqsave(&ptDevInfo->lock, flags);

	if (ptVideoBuf->dwIndex > VIDEO_MAX_FRAME)
	{
		PDEBUG("VPL_VOC_QBUF: Index out of range\n");
		goto done;
	}

	ptVOCBufInfo = &(ptDevInfo->atVOCBufInfo[ptVideoBuf->dwIndex]);

	switch(ptVOCBufInfo->state)
	{
		case BUF_STATE_DEQUEUED:
			ptVOCBufInfo->dwIndex = ptVideoBuf->dwIndex;
			ptVOCBufInfo->pbyYFrame = ptVideoBuf->pbyYFrame;
			ptVOCBufInfo->pbyCbFrame = ptVideoBuf->pbyCbFrame;
			ptVOCBufInfo->pbyCrFrame = ptVideoBuf->pbyCrFrame;
			ptVOCBufInfo->state = BUF_STATE_PREPARED;
		case BUF_STATE_PREPARED:
			break;
		default:
			PDEBUG("VPL_VOC_QBUF: buffer is already queued or active.\n");
			ret = -EINVAL;
			goto done;
	}
	PDEBUG("Enter QBuf index %d !!\n", ptVOCBufInfo->dwIndex);
	list_add_tail(&ptVOCBufInfo->queue, &ptDevInfo->queued_list);
	ptVOCBufInfo->state = BUF_STATE_QUEUED;

done:
	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	return ret;
}

/* ============================================================================================== */
int VPL_VOC_DQBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf)
{
	int retval;
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	TVPLVOCBufInfo *ptVOCBufInfo;
	unsigned long flags = 0;

	spin_lock_irqsave(&ptDevInfo->lock, flags);

check:
	if (list_empty(&ptDevInfo->done_list)) {
		spin_unlock_irqrestore(&ptDevInfo->lock, flags);
		PDEBUG("no avaliable dequeue\n");
		retval = wait_event_interruptible(ptDevInfo->wq, !list_empty(&ptDevInfo->done_list));
		spin_lock_irqsave(&ptDevInfo->lock, flags);

		if (retval == -ERESTARTSYS)
			goto check;
	}

	ptVOCBufInfo = list_first_entry(&ptDevInfo->done_list, TVPLVOCBufInfo, queue);

	ptVideoBuf->dwIndex = ptVOCBufInfo->dwIndex;
	ptVideoBuf->dwFrameCount = ptVOCBufInfo->dwFrameCount;
	ptVideoBuf->pbyYFrame = ptVOCBufInfo->pbyYFrame;
	ptVideoBuf->pbyCbFrame = ptVOCBufInfo->pbyCbFrame;
	ptVideoBuf->pbyCrFrame = ptVOCBufInfo->pbyCrFrame;

	list_del(&ptVOCBufInfo->queue);
	PDEBUG("Enter DQBuf index %d !!\n", ptVOCBufInfo->dwIndex);
	ptVOCBufInfo->state = BUF_STATE_DEQUEUED;

	retval = 0;

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	return retval;
}

/* ============================================================================================== */
void VPL_VOC_ClearQBuf(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	int i;
	unsigned long flags = 0;

	spin_lock_irqsave(&ptDevInfo->lock, flags);
	for (i = 0; i < VIDEO_MAX_FRAME; i++)
	{
		if (/*(ptDevInfo->atVOCBufInfo[i].state == BUF_STATE_ACTIVE) ||*/
				(ptDevInfo->atVOCBufInfo[i].state == BUF_STATE_QUEUED))
		{
			ptDevInfo->atVOCBufInfo[i].state = BUF_STATE_DONE;
			{
				list_move_tail(&(ptDevInfo->atVOCBufInfo[i].queue), &ptDevInfo->done_list);
			}
		}
	}

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	wake_up_all(&ptDevInfo->wq);
}

/* ============================================================================================== */
void VPL_VOC_Set_OSD_Addr(HANDLE hDevInfo, DWORD dwPaddr)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	ptDevInfo->ptMMRInfo->dwIndexOSDAddr = dwPaddr;
}

/* ============================================================================================== */
void VPL_VOC_Set_OSD_DISP(HANDLE hDevInfo, bool enabled, bool bgmode)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;

	if (enabled) {/* Restore when Enable*/
		set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_EN, enabled);
		set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_BUSLOCK, 0x1);
		set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_BG, bgmode);
	} else { /* MUST disable Background mode before disable OSD */
		set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_BG, 0);
		set_field(ptDevInfo->ptMMRInfo->dwIndexOSDCtrl, VOC_OSD_CTRL_EN, enabled);
	}
}

/* ============================================================================================== */
void VPL_VOC_Set_OSD_Image(HANDLE hDevInfo, DWORD dwWidth, DWORD dwHeight, DWORD dwStride)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	struct voc_device_mgr *mgr = &voc_dev_mgr;
	EVideoSignalFormat eOutSignalFormat = mgr->curt_connector->signal_format;
	/* IN interlace CCIR656, OSD buffer also need double stride for one field only access */
	if (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_CCIR656)
		dwStride<<=1;

	ptDevInfo->ptMMRInfo->dwIndexOSDSize = ((dwWidth<<16) | dwHeight);
	set_field(ptDevInfo->ptMMRInfo->dwStrideSetting, VOC_OSD_STRIDE, dwStride);
}

/* ============================================================================================== */
void VPL_VOC_Set_OSD_Pos(HANDLE hDevInfo, TVPLVOCOSDPOS *ptOSDPos)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	ptDevInfo->ptMMRInfo->dwIndexOSDAxis = ((ptOSDPos->xpos << 16) | ptOSDPos->ypos);
}

/* ============================================================================================== */
void VPL_VOC_Set_PIP_Image(HANDLE hDevInfo, DWORD dwWidth, DWORD dwHeight, DWORD dwStride)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	struct voc_device_mgr *mgr = &voc_dev_mgr;
	EVideoSignalFormat eOutSignalFormat = mgr->curt_connector->signal_format;
	/* IN interlace CCIR656, OSD buffer also need double stride for one field only access */
	if (eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_CCIR656 || eOutSignalFormat == VIDEO_SIGNAL_FORMAT_INTERLACE_RAW_16BITS)
		dwStride<<=1;

	set_field(ptDevInfo->ptMMRInfo->dwPIPCtrl, VOC_PIP_CTRL_STRIDE, dwStride);

	ptDevInfo->ptMMRInfo->dwPIPSize = (dwWidth << 16 | dwHeight);
	PDEBUG("PIPIMAG %x\n", (u32)ptDevInfo->ptMMRInfo->dwPIPSize);
}

/* ============================================================================================== */
void VPL_VOC_Set_PIP_Pos(HANDLE hDevInfo, DWORD dwXPos, DWORD dwYPos)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	ptDevInfo->ptMMRInfo->dwPIPAxis = ((dwXPos & 0xFFFE) << 16) | dwYPos;
	PDEBUG("PIPOIS %x\n", (u32)ptDevInfo->ptMMRInfo->dwPIPAxis);
}

/* ============================================================================================== */
SCODE VPL_VOC_PIP_START(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	unsigned long flags = 0;

	spin_lock_irqsave(&ptDevInfo->lock, flags);

	if (list_empty(&ptDevInfo->queued_list_pip) && ptDevInfo->ptCur_Frm_pip == NULL) {
		spin_unlock_irqrestore(&ptDevInfo->lock, flags);
		PDEBUG("VPL_VOC_IOC_START: At least ADD one buffer before start\n");
		return -EINVAL;
	}

	if (ptDevInfo->ptCur_Frm_pip == NULL)
	{
		ptDevInfo->ptCur_Frm_pip = ptDevInfo->ptNext_Frm_pip = list_first_entry(&ptDevInfo->queued_list_pip, TVPLVOCBufInfo, queue);

		list_del_init(&ptDevInfo->ptCur_Frm_pip->queue);
		ptDevInfo->ptCur_Frm_pip->state = BUF_STATE_ACTIVE;

		ptDevInfo->ptMMRInfo->dwPIPYBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyYFrame);
		ptDevInfo->ptMMRInfo->dwPIPCbBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyCbFrame);
		ptDevInfo->ptMMRInfo->dwPIPCrBuff0Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyCrFrame);
		ptDevInfo->ptMMRInfo->dwPIPYBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyYFrame);
		ptDevInfo->ptMMRInfo->dwPIPCbBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyCbFrame);
		ptDevInfo->ptMMRInfo->dwPIPCrBuff1Addr = (DWORD)(ptDevInfo->ptCur_Frm_pip->pbyCrFrame);

		ptDevInfo->bfirst_int_pip = 1;
	}

	ptDevInfo->ptMMRInfo->dwPIPCtrl |= (PIP_MODE | PIP_LOCK); /* overlay mode, lock */
	set_field(ptDevInfo->ptMMRInfo->dwPIPCtrl, VOC_PIP_CTRL_EN, 1);

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);

	ptDevInfo->bpip_on = true;

	return S_OK;
}

/* ============================================================================================== */
void VPL_VOC_PIP_STOP(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	unsigned long flags = 0;
	int i;

	spin_lock_irqsave(&ptDevInfo->lock, flags);

	set_field(ptDevInfo->ptMMRInfo->dwPIPCtrl, VOC_PIP_CTRL_EN, 0);
	ptDevInfo->bpip_on = false;

	INIT_LIST_HEAD(&ptDevInfo->queued_list_pip);
	INIT_LIST_HEAD(&ptDevInfo->done_list_pip);
	ptDevInfo->ptCur_Frm_pip = ptDevInfo->ptNext_Frm_pip = NULL;
	ptDevInfo->dwFrameCnt_pip = 0;

	for (i = 0; i < VIDEO_MAX_FRAME; i++) {
		ptDevInfo->atVOCBufInfo_pip[i].state = BUF_STATE_DEQUEUED;
	}

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	wake_up_all(&ptDevInfo->wq_pip);
}

/* ============================================================================================== */
int VPL_VOC_PIP_QBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf)
{
	int ret = 0;
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	TVPLVOCBufInfo *ptVOCBufInfo;
	unsigned long flags = 0;
	spin_lock_irqsave(&ptDevInfo->lock, flags);

	if (ptVideoBuf->dwIndex > VIDEO_MAX_FRAME)
	{
		PDEBUG("VPL_VOC_QBUF: Index out of range\n");
		goto done;
	}

	ptVOCBufInfo = &(ptDevInfo->atVOCBufInfo_pip[ptVideoBuf->dwIndex]);

	switch(ptVOCBufInfo->state)
	{
		case BUF_STATE_DEQUEUED:
			ptVOCBufInfo->dwIndex = ptVideoBuf->dwIndex;
			ptVOCBufInfo->pbyYFrame = ptVideoBuf->pbyYFrame;
			ptVOCBufInfo->pbyCbFrame = ptVideoBuf->pbyCbFrame;
			ptVOCBufInfo->pbyCrFrame = ptVideoBuf->pbyCrFrame;
			ptVOCBufInfo->state = BUF_STATE_PREPARED;
		case BUF_STATE_PREPARED:
			break;
		default:
			PDEBUG("VPL_VOC_QBUF: buffer is already queued or active.\n");
			ret = -EINVAL;
			goto done;
	}

	list_add_tail(&ptVOCBufInfo->queue, &ptDevInfo->queued_list_pip);
	ptVOCBufInfo->state = BUF_STATE_QUEUED;

done:
	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	return ret;
}

/* ============================================================================================== */
int VPL_VOC_PIP_DQBuf(HANDLE hDevInfo, TVideoBuffer *ptVideoBuf)
{
	int retval;
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	TVPLVOCBufInfo *ptVOCBufInfo;
	unsigned long flags = 0;
	spin_lock_irqsave(&ptDevInfo->lock, flags);
check:
	if (list_empty(&ptDevInfo->done_list_pip)) {
		spin_unlock_irqrestore(&ptDevInfo->lock, flags);
		retval = wait_event_interruptible(ptDevInfo->wq_pip, !list_empty(&ptDevInfo->done_list_pip));
		spin_lock_irqsave(&ptDevInfo->lock, flags);

		if (retval == -ERESTARTSYS)
			goto check;
	}

	ptVOCBufInfo = list_first_entry(&ptDevInfo->done_list_pip, TVPLVOCBufInfo, queue);

	ptVideoBuf->dwIndex = ptVOCBufInfo->dwIndex;
	ptVideoBuf->dwFrameCount = ptVOCBufInfo->dwFrameCount;
	ptVideoBuf->pbyYFrame = ptVOCBufInfo->pbyYFrame;
	ptVideoBuf->pbyCbFrame = ptVOCBufInfo->pbyCbFrame;
	ptVideoBuf->pbyCrFrame = ptVOCBufInfo->pbyCrFrame;

	list_del(&ptVOCBufInfo->queue);

	ptVOCBufInfo->state = BUF_STATE_DEQUEUED;

	retval = 0;

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	return retval;
}

/* ============================================================================================== */
void VPL_VOC_PIP_ClearQBuf(HANDLE hDevInfo)
{
	TVPLVOCDevInfo *ptDevInfo = (TVPLVOCDevInfo *)hDevInfo;
	int i;
	unsigned long flags = 0;

	spin_lock_irqsave(&ptDevInfo->lock, flags);
	for (i = 0; i < VIDEO_MAX_FRAME; i++)
	{
		if (/*(ptDevInfo->atVOCBufInfo[i].state == BUF_STATE_ACTIVE) ||*/
			(ptDevInfo->atVOCBufInfo_pip[i].state == BUF_STATE_QUEUED))
		{
			ptDevInfo->atVOCBufInfo_pip[i].state = BUF_STATE_DONE;
			{
				list_move_tail(&(ptDevInfo->atVOCBufInfo_pip[i].queue), &ptDevInfo->done_list_pip);
			}
		}
	}

	spin_unlock_irqrestore(&ptDevInfo->lock, flags);
	wake_up_all(&ptDevInfo->wq_pip);
}
