/*
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: ChangHsien Ho <vincent.ho@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __VPL_VOC_MGR_H__
#define __VPL_VOC_MGR_H__

#include "vpl_voc_sub.h"
#include "vpl_voc_driver.h"
#define VOC_MAX_CONNECTOR 3
#define HDMI_1080i_60FPS

struct voc_device_mgr {
	int num_connector;
	struct voc_connector *curt_connector;
	struct vpl_voc_timing curt_mode;
	struct voc_connector *connectors[VOC_MAX_CONNECTOR];
};

int voc_class_init(void);
void voc_class_exit(void);
int voc_sysfs_add_connector(struct voc_connector *connector);
void videomode_to_voc_timing(const struct videomode *vm, struct vpl_voc_timing *voc_timing);
int voc_connect_lcd_init(void);

#endif /* __VPL_VOC_MGR_H__ */
