/*
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: ChangHsien Ho <vincent.ho@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __VPL_VOC_SUB_H__
#define  __VPL_VOC_SUB_H__

#include <linux/device.h>
#include <video/videomode.h>
#include "vivo_codec.h"

#define SUBCONNECT_IF_VERSION 0x01000000
#define SUBCONNECT_NAME_SIZE 32

/*
 * Check datasheet, DPI Output Data Arrangements
 *                      sRGB		16-bit YCbCr            8-bit YCbCr
 * ARRANGEMENT_POS_0:   D[23:16]        Cb/Cr  D[15:8]          Y/Cb/Cr D[7:0]
 *                                      Y      D[7:0]
 *
 * ARRANGEMENT_POS_1:   D[15:8]         Cb/Cr  D[23:16]         Y/Cb/Cr D[15:8]
 *                                      Y      D[15:8]
 *
 * ARRANGEMENT_POS_2:   D[7:0]          Cb/Cr  D[7:0]           Y/Cb/Cr D[23:16]
 *                                      Y      D[23:16]
 */
enum dpi_data_arrangement {
	ARRANGEMENT_POS_0 = 0,
	ARRANGEMENT_POS_1 = 1,
	ARRANGEMENT_POS_2 = 2,
};

/*
 * Color order applied on 24Bit RGB, 8-Bit SRGB adn I80
 *
 *                      24-bit		SRGB,I80
 * COLOR_ORDER_RGB:     R D[23:16]        R->G->B
 *                      G D[15:8]
 *                      B D[7:0]
 *
 * COLOR_ORDER_GBR:     G D[23:16]       G->R->B
 *                      B D[15:8]
 *                      R D[7:0]
 *
 * and so on.
 */
enum rgb_color_order {
	COLOR_ORDER_RGB = 0,
	COLOR_ORDER_GBR = 1,
	COLOR_ORDER_BRG = 2,
	COLOR_ORDER_RBG = 3,
	COLOR_ORDER_BGR = 4,
	COLOR_ORDER_GRB = 5,
};

/**
  * voc_connector - voc sub-connector hook structure
  * @name: Name of the connector device
  * @num_modes: number of videomode
  * @modes: ponter to modes array;
  * @setup: Function to setup sub-connector
  */
struct voc_connector;

struct voc_connector {
	u32 if_version;
	struct device dev;
	char name[SUBCONNECT_NAME_SIZE];
	enum video_signal_format signal_format;
	enum dpi_data_arrangement data_arrangement;
	enum rgb_color_order color_order;
	unsigned int num_modes;
	const struct videomode *modes;
	void (*setup)(struct voc_connector *connector);
};

int voc_register_connector(struct voc_connector *connector);
int voc_unregister_connector(struct voc_connector *connector);

#endif /* __VPL_VOC_SUB_H__ */
