/*
 * drivers/clk/pesaro/clk-gate.h
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: ChangHsien Ho <vincent.ho@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#define SYSC_MMR_BASE IO_ADDRESS(VPL_SYSC_MMR_BASE)
#define SYSC_UARTC_CTRL        SYSC_MMR_BASE+0x78
#define SYSC_CLK_EN_CTRL_0 SYSC_MMR_BASE+0x94
#define SYSC_CLK_EN_CTRL_1 SYSC_MMR_BASE+0x98

#ifndef __CLK_PESARO_CLK_GATE_H
#define __CLK_PESARO_CLK_GATE_H

/* SYSC_UARTC_CTRL */
#define UART_0_CLK_SRC_SEL             6   //UARTC 3 clock source selection 20M
#define UART_1_CLK_SRC_SEL             14   //UARTC 2 clock source selection 20M
#define UART_2_CLK_SRC_SEL             22   //UARTC 1 clock source selection 20M
#define UART_3_CLK_SRC_SEL             30   //UARTC 0 clock source selection 20M

/* SYSC_CLK_EN_CTRL_0 */
#define MSHC_0_CLK_EN		31 //MSHC 0 clock enable control.
#define MIPIRC_CLK_EN		30 //MIPIRC clock enable control.
#define MEAE_CLK_EN		29 //MEAE clock enable control.
#define JEBE_CLK_EN		28 //JEBE clock enable control.
#define ISPE_CLK_EN		27 //ISPE clock enable control.
#define IRDAC_CLK_EN		26 //IRDAC clock enable control.
#define INTC_CLK_EN		25 //INTC clock enable control.
#define I2SSC_CLK_EN		24 //I2SSC clock enable control.
#define I2CC_2_CLK_EN		23 //I2CC 2 clock enable control.
#define I2CC_1_CLK_EN		22 //I2CC 1 clock enable control.
#define I2CC_0_CLK_EN		21 //I2CC 0 clock enable control.
#define HDMITC_CLK_EN		20 //HDMITC clock enable control.
#define H4EE_CLK_EN		19 //H.264 encoding clock enable control.
#define H4DE_CLK_EN		18 //H.264 decoding clock enable control.
#define GPIOC_2_CLK_EN		17 //GPIOC 2 clock enable control.
#define GPIOC_1_CLK_EN		16 //GPIOC 1 clock enable control.
#define GPIOC_0_CLK_EN		15 //GPIOC 0 clock enable control.
#define GPADC_CLK_EN		14 //GPADC clock enable control.
#define GMAC_RMII_CLK_EN	13 //GMAC RMII clock enable control.
#define GMAC_CLK_EN		12 //GMAC clock enable control.
#define DMAC_CLK_EN		11 //DMAC clock enable control.
#define DDR32SDMC_CLK_EN	10 //DDR32SDMC clock enable control.
#define DCE_CLK_EN		9  //DCE clock enable control.
#define CCE_CLK_EN		8  //CCE clock enable control.
#define BRC_CLK_EN		7  //BRC clock enable control.
#define ARM926U_CLK_EN		6  //ARM926U clock enable control.
#define APBC_CLK_EN		5  //APBC clock enable control.
#define APB3C_CLK_EN		4  //APB3C clock enable control.
#define AHBC_2_CLK_EN		3  //AHBC 2 clock enable control.
#define AHBC_1_CLK_EN		2  //AHBC 1 clock enable control.
#define AGPOC_CLK_EN		1  //AGPOC clock enable control.
#define ACDCC_CLK_EN		0  //ACDCC clock enable control.

/* SYSC_CLK_EN_CTRL_1 */
#define WDTC_CLK_EN		19  //WDTC clock enable control.
#define VOC_CLK_EN		18  //VOCclock enable control.
#define VIC_MUX_CLK_EN		17  //VIC MUX clock enable control.
#define VIC_DEV_1_CLK_EN	16  //VIC device 1 clock enable control.
#define VIC_DEV_0_CLK_EN	15  //VIC device 0 clock enable control.
#define VDAC_CLK_EN		14  //VDAC clock enable control.
#define USBC_CLK_EN		13  //USBC clock enable control.
#define UARTC_3_CLK_EN		12  //UARTC 3 clock enable control.
#define UARTC_2_CLK_EN		11  //UARTC 2 clock enable control.
#define UARTC_1_CLK_EN		10  //UARTC 1 clock enable control.
#define UARTC_0_CLK_EN		9   //UARTC 0 clock enable control.
#define TVEC_CLK_EN		8   //TVEC clock enable control.
#define TMRC_CLK_EN		7   //TMRC clock enable control.
#define SYSC_CLK_EN		6   //SYSC clock enable control.
#define SSIC_CLK_EN		5   //SSIC clock enable control.
#define RTCC_CLK_EN		4   //RTCC clock enable control.
#define PLLC_CLK_EN		3   //PLLC clock enable control.
#define NFC_CLK_EN		2   //NFC clock enable control.
#define MSHC_1_CLK_EN		0   //MSHC 1 clock enable control

#endif /* __CLK_PESARO_CLK_GATE_H */
