/*
 * drivers/clk/pesaro/clk-pll.h
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __CLK_PESARO_CLK_PLL_H
#define __CLK_PESARO_CLK_PLL_H

#define PLLC_BASE IO_ADDRESS(VPL_PLLC_MMR_BASE)
#define PLLC_0    PLLC_BASE + VPL_PLLC_CTRL_0
#define PLLC_1    PLLC_BASE + VPL_PLLC_CTRL_1
#define PLLC_2    PLLC_BASE + VPL_PLLC_CTRL_2
#define PLLC_3    PLLC_BASE + VPL_PLLC_CTRL_3
#define PLLC_4    PLLC_BASE + VPL_PLLC_CTRL_4
#define PLLC_5    PLLC_BASE + VPL_PLLC_CTRL_5


struct pesaro_clk_pll_freq_table {
	unsigned long	input_rate;
	unsigned long	output_rate;
	u16		m;
	u8		n;
	u8		p;
};

struct pesaro_clk_pll_params {
	unsigned long	input_min;
	unsigned long	input_max;
	unsigned long	cf_min;
	unsigned long	cf_max;
	unsigned long	vco_min;
	unsigned long	vco_max;

	u32		base_reg;
	u32		misc_reg;
	u32		lock_reg;
	u32		lock_mask;
	u32		lock_enable_bit_idx;
	u32		iddq_reg;
	u32		iddq_bit_idx;
	u32		aux_reg;
	u32		dyn_ramp_reg;
	u32		ext_misc_reg[3];
	int		stepa_shift;
	int		stepb_shift;
	int		lock_delay;
	int		max_p;
};

struct pesaro_clk_pll {
	struct clk_hw	hw;
	void __iomem	*clk_base;
	void __iomem	*pmc;
	u32		flags;
	unsigned long	fixed_rate;
	spinlock_t	*lock;
	u8		divn_shift;
	u8		divn_width;
	u8		divm_shift;
	u8		divm_width;
	u8		divp_shift;
	u8		divp_width;
	struct pesaro_clk_pll_freq_table *freq_table;
	struct pesaro_clk_pll_params	 *params;
};
#define to_clk_pll(_hw) container_of(_hw, struct pesaro_clk_pll, hw)

struct clk *pesaro_clk_register_pll(const char *name, const char *parent_name,
		void __iomem *clk_base,
		unsigned long flags, unsigned long fixed_rate,
		struct pesaro_clk_pll_params *pll_params, u32 pll_flags,
		struct pesaro_clk_pll_freq_table *freq_table, spinlock_t *lock);
#endif /* __CLK_PESARO_CLK_PLL_H */
