#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/err.h>
#include <linux/kdev_t.h>
#include <linux/string.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/irqdomain.h>
#include <linux/clk.h>
#include <asm/io.h>
#include <linux/sched.h>
#include <mach/hardware.h>
#include <mach/maps.h>
#include <mach/irqs.h>
#include <linux/irqchip/pesaro.h>

#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <asm/uaccess.h>

#define GPADC_CTRL 		0x04
#define GPADC_DATA 		0x08
static struct platform_driver vpl_gpadc_driver;
struct gpadc_data{
	int irq;
	int channel;
};
static void* adc_base;

DECLARE_COMPLETION(gpadc_complete);

int vpl_get_adc(int chn)
{
	u32 reg = 0x3;//defaul, bit 0 = enable, bit 1 = start
	reg |= chn << 2;
	writel(reg, adc_base + GPADC_CTRL);
	wait_for_completion(&gpadc_complete);
	return readl(adc_base + GPADC_DATA);
}
EXPORT_SYMBOL(vpl_get_adc);

static ssize_t vpl_adc_show(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	struct gpadc_data *gpdev = dev_get_drvdata(dev);

	return sprintf(buf, "%d\n", vpl_get_adc(gpdev->channel));
}
static ssize_t vpl_adc_store(struct device *dev,
		struct device_attribute *attr, const char *buf, size_t size)
{
	struct gpadc_data *gpdev = dev_get_drvdata(dev);
	int chn;
	chn = simple_strtol(buf, NULL, 10);
	if (chn>=0 && chn <=3)
		gpdev->channel = chn;
	else
		dev_err(dev, "error channel number");
	return size;
}
static /*const*/ DEVICE_ATTR(adc, 0644,
		vpl_adc_show, vpl_adc_store);

static irqreturn_t vpl_gpadc_isr(int irq, void *dev_id)
{
	complete(&gpadc_complete);
	return IRQ_HANDLED;
}
static int vpl_gpadc_probe(struct platform_device *pdev)
{
	struct gpadc_data *data;
	int ret;
	struct clk *clk;

	clk = clk_get(NULL, "vpl_gpadc");
	if (IS_ERR(clk)) {
		dev_err(&pdev->dev, "Failed to get clock\n");
		return PTR_ERR(clk);
	}
	clk_prepare(clk);
	clk_enable(clk);

	adc_base = ioremap(VPL_GPADC_MMR_BASE, 0x10);

	// enable gpadc phy
	writel(0x1, adc_base + GPADC_CTRL);
	data = kzalloc(sizeof(struct gpadc_data), GFP_KERNEL);
	data->channel = 0;
	data->irq = irq_create_mapping(NULL, GPADC_IRQ_NUM);
	ret = request_irq(data->irq, vpl_gpadc_isr, IRQF_DISABLED | IRQF_TRIGGER_RISING,
			"vpl_gpadc", pdev);
	if (ret) {
		dev_err(&pdev->dev, "failed to allocate irq.\n");
	}
	
	platform_set_drvdata(pdev, data);
	device_create_file(&pdev->dev, &dev_attr_adc);
	return 0;
}

static int vpl_gpadc_remove(struct platform_device *pdev)
{
	struct gpadc_data* data = platform_get_drvdata(pdev);

	free_irq(data->irq, data);
	kfree(data);
	iounmap(adc_base);
	platform_driver_unregister(&vpl_gpadc_driver);
	return 0;
}
static struct platform_driver vpl_gpadc_driver = {
	.probe		= vpl_gpadc_probe,
	.remove		= vpl_gpadc_remove,
	.driver		= {
		.name	= "vpl_gpadc",
	},
};


static struct platform_device *gpadc_device;
static int __init vpl_gpadc_init(void)
{
	gpadc_device = platform_device_alloc("vpl_gpadc", -1);
	platform_device_add(gpadc_device);
	return platform_driver_register(&vpl_gpadc_driver);
}

static void __exit vpl_gpadc_exit(void)
{
	return;
}

module_init(vpl_gpadc_init);
module_exit(vpl_gpadc_exit);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("VPL GPADC driver");
MODULE_AUTHOR("Paul Chen <paul.chen@vatics.com.tw>");

