/*
 *  drivers/net/dwmac/dweqos.h
 *
 *  Copyright (C) 2007-2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __DWEQOS_H__
#define __DWEQOS_H__

/*
 * MAC BLOCK defines
 */
#define GMAC_CONTROL		0x00000000	/* Configuration */
#define GMAC_EXT_CONTROL	0x00000004	/* Extended Configuration */
#define GMAC_PACKET_FILTER	0x00000008	/* Packet Filter */
#define GMAC_WATCHDOG_TIMEOUT	0x0000000c	/* Watchdog Timeout */
#define GMAC_HASH_TBL0		0x00000010	/* Multicast Hash Table 0 */
#define GMAC_HASH_TBL1		0x00000014	/* Multicast Hash Table 1 */
#define GMAC_VLAN_TAG		0x00000050	/* VLAN Tag */
#define GMAC_VLAN_HASH		0x00000058	/* VLAN Hash Table */
#define GMAC_VLAN_INCL		0x00000060	/* VLAN Tag for insertion or replacement */
#define GMAC_INNER_VLAN_INCL	0x00000064	/* Inner VLAN Tag for insertion or replacement */
#define GMAC_Q0_TX_FLOW_CTRL	0x00000070	/* Tx Queue 0 Flow Control */
#define GMAC_RX_FLOW_CTRL	0x00000090	/* Rx Flow Control */
#define GMAC_INT_STATUS		0x000000B0	/* interrupt status register */
enum dwmac1000_irq_status {
	tx_time_stamp_irq = 0x10000,
	gpio_irq = 0x8000,
	rx_irq = 0x4000,
	tx_irq = 0x2000,
	time_stamp_irq = 0x1000,
	mmc_rx_csum_offload_irq = 0x0800,
	mmc_tx_irq = 0x0400,
	mmc_rx_irq = 0x0200,
	mmc_irq = 0x0100,
	lpiis_irq = 0x0020,
	pmt_irq = 0x0010,
	phy_irq = 0x0008,
	pcs_ane_irq = 0x0004,
	pcs_link_irq = 0x0002,
	rgmii_irq = 0x0001,
};
#define GMAC_INT_ENABLE		0x000000B4	/* Interrupt enable register */
#define GMAC_RX_TX_STATUS	0x000000B8	/* Receive and Transmit Error status */
#define GMAC_VERSION		0x00000110	/* GMAC CORE Version */
#define GMAC_HW_FEATURE0	0x0000011c	/* HW Feature0 Register */
#define GMAC_HW_FEATURE1	0x00000120	/* HW Feature1 Register */
#define GMAC_HW_FEATURE2	0x00000124	/* HW Feature2 Register */
#define GMAC_MII_ADDR		0x00000200	/* MII Address */
#define GMAC_MII_DATA		0x00000204	/* MII Data */

/* GMAC HW ADDR regs */
#define GMAC_ADDR_HIGH(reg)	(0x00000300 + (reg * 8))
#define GMAC_ADDR_LOW(reg)	(0x00000304 + (reg * 8))
#define GMAC_MAX_PERFECT_ADDRESSES	32

/* GMAC Control Defines */
#define GMAC_CONTROL_IPC	0x08000000  /* Checksum Offload */
enum inter_packet_gap {
	GMAC_CONTROL_IPG_88 = 0x01000000,
	GMAC_CONTROL_IPG_80 = 0x02000000,
	GMAC_CONTROL_IPG_40 = 0x07000000,
};
#define GMAC_CONTROL_GPSLCE	0x00800000  /* Enable Giant Packet Size Limit Control */
#define GMAC_CONTROL_S2KP	0x00400000  /* Support for 2K Packets */
#define GMAC_CONTROL_CST	0x00200000  /* CRC stripping */
#define GMAC_CONTROL_ACS	0x00100000  /* Auto Pad/FCS Stripping */
#define GMAC_CONTROL_WD		0x00080000  /* Disable Watchdog on receive */
#define GMAC_CONTROL_BE		0x00040000  /* Frame Burst Enable */
#define GMAC_CONTROL_JD		0x00020000  /* Jabber disable */
#define GMAC_CONTROL_JE		0x00010000  /* Jumbo frame */
#define GMAC_CONTROL_PS		0x00008000  /* Port Select 0:GMI 1:MII */
#define GMAC_CONTROL_FES	0x00004000  /* Speed 0:10 1:100 */
#define GMAC_CONTROL_DM		0x00002000  /* Duplex Mode */
#define GMAC_CONTROL_LM		0x00001000  /* Loop-back mode */
#define GMAC_CONTROL_ECRSFD	0x00000800  /* Enable Carrier Sense BeforeTransmission */
#define GMAC_CONTROL_DO		0x00000400  /* Disable Rx Own */
#define GMAC_CONTROL_DCRS	0x00000200  /* Disable carrier sense */
#define GMAC_CONTROL_DR		0x00000100  /* Disable Retry */
#define GMAC_CONTROL_DC		0x00000010  /* Deferral Check */
#define GMAC_CONTROL_TE		0x00000002  /* Transmitter Enable */
#define GMAC_CONTROL_RE		0x00000001  /* Receiver Enable */

#define GMAC_CORE_INIT (GMAC_CONTROL_JD | GMAC_CONTROL_PS | GMAC_CONTROL_ACS |\
			GMAC_CONTROL_JE | GMAC_CONTROL_BE)

/* GMAC VLAN Tag Defines */
#define GMAC_VLAN_INCL_VLTI		0x00100000
#define GMAC_VLAN_INCL_VLP		0x00040000
#define GMAC_VLAN_INCL_INS		0x00020000

/* GMAC FLOW CTRL defines */
#define GMAC_TX_FLOW_CTRL_PT_MASK	0xffff0000	/* Pause Time Mask */
#define GMAC_TX_FLOW_CTRL_PT_SHIFT	16
#define GMAC_TX_FLOW_CTRL_TFE		0x00000002	/* Tx Flow Control Enable */
#define GMAC_TX_FLOW_CTRL_FCB_BPA	0x00000001	/* Flow Control Busy ... */
#define GMAC_RX_FLOW_CTRL_RFE		0x00000001	/* Rx Flow Control Enable */

/* GMAC INT_STATUS defines */
#define GMAC_INT_STATUS_GPIIS	0x00008000	/* GMAC GPI interrupt */
#define GMAC_INT_STATUS_GLPIIS	0x00000020	/* GMAC LPI interrupt */
#define GMAC_INT_STATUS_PMTIS	0x00000010	/* GMAC PMT interrupt */
#define GMAC_INT_STATUS_PHYIS	0x00000008	/* GMAC PHY interrupt */

#define DMA_STATUS_GMI		0x08000000	/* MMC interrupt */
#define DMA_STATUS_GLI		0x04000000	/* GMAC Line interface int */
#define DMA_STATUS_GMI		0x08000000
#define DMA_STATUS_GLI		0x04000000


/*
 * DMA BLOCK defines
 */
/*DMA CRS Control and Status Register Mapping */
#define DMA_MODE		0x00001000	/* Operating mode */
#define DMA_SYSBUS_MODE		0x00001004	/* AHB bus control, burst spliting */
#define DMA_INTR_STATUS		0x00001008	/* DMA Interrupt Status Register */
#define DMA_DEBUG_STATUS0	0x0000100c	/* DMA Debug Status 0 Register */
#define DMA_DEBUG_STATUS1	0x00001010	/* DMA Debug Status 1 Register */
#define DMA_DEBUG_STATUS2	0x00001014	/* DMA Debug Status 2 Register */
#define DMA_CH0_CONTROL		0x00001100	/* DMA Channel 0 control */
#define DMA_CH0_TX_CONTROL	0x00001104	/* DMA Channel 0 Tx control */
#define DMA_CH0_RX_CONTROL	0x00001108	/* DMA Channel 0 Rx control */
#define DMA_CH0_TX_BASE_ADDR	0x00001114	/* Transmit List Base */
#define DMA_CH0_RX_BASE_ADDR	0x0000111c	/* Receive List Base */
#define DMA_CH0_TX_TAIL_ADDR	0x00001120	/* Transmit List Tail Address */
#define DMA_CH0_RX_TAIL_ADDR	0x00001128	/* Receive List Tail Address */
#define DMA_CH0_TX_LEN_ADDR	0x0000112c	/* Transmit List Length Address */
#define DMA_CH0_RX_LEN_ADDR	0x00001130	/* Receive List Length Address */
#define DMA_CH0_INTR_ENA	0x00001134	/* Interrupt Enable */
#define DMA_CH0_CUR_TX_ADDR	0x00001144	/* Current Host Tx Descriptor */
#define DMA_CH0_CUR_RX_ADDR	0x0000114c	/* Current Host Rx Descriptor */
#define DMA_CH0_CUR_TX_BUF_ADDR	0x00001154	/* Current Host Tx Buffer */
#define DMA_CH0_CUR_RX_BUF_ADDR	0x0000115c	/* Current Host Rx Buffer */
#define DMA_CH0_STATUS		0x00001160	/* DMA interrupt status */

/* DMA Mode defines */
#define DMA_MODE_SFT_RESET	0x00000001	/* Software Reset */
#define DMA_MODE_DA		0x00000002	/* Arbitration scheme */
#define DMA_MODE_TXPR		0x00000800	/* Transmit Priority */
enum rx_tx_priority_ratio {
	double_ratio = 0x00001000,	/*2:1 */
	triple_ratio = 0x00002000,	/*3:1 */
	quadruple_ratio = 0x00003000,	/*4:1 */
	quintuple_ratio = 0x00004000,	/*5:1 */
	sextuple_ratio = 0x00005000,	/*6:1 */
	septuple_ratio = 0x00006000,	/*7:1 */
	octuple_ratio = 0x00007000,	/*8:1 */
};

/* DMA System Bus Mode defines */
#define DMA_SYSBUS_MODE_MB		0x00004000	/* Mixed burst */
#define DMA_SYSBUS_MODE_AAL		0x00001000
#define DMA_SYSBUS_MODE_BLEN16		0x00000008	/* Burst length 16*/
#define DMA_SYSBUS_MODE_BLEN8		0x00000004	/* Burst length 8*/
#define DMA_SYSBUS_MODE_BLEN4		0x00000002	/* Burst length 4*/
#define DMA_SYSBUS_MODE_UNDEF		0x00000001	/* Fixed burst */

/* DMA INTR Status defines */
#define DMA_INTR_STATUS_MACIS		0x00020000	/* MAC Interrupt */
#define DMA_INTR_STATUS_MTLIS		0x00010000	/* MTL Interrupt */
#define DMA_INTR_STATUS_DC0IS		0x00000001	/* DMA Channel 0 Interrupt */

/* DMA Debug Status 0 defines*/
#define DMA_DEBUG_STATUS0_TS_MASK	0x0000F000	/* Transmit Process State */
#define DMA_DEBUG_STATUS0_TS_SHIFT	12
#define DMA_DEBUG_STATUS0_RS_MASK	0x00000F00	/* Receive Process State */
#define DMA_DEBUG_STATUS0_RS_SHIFT	8

/* DMA Channel Control register defines */
#define DMA_CH_CONTROL_MSS_MASK		0x00003fff
#define DMA_CH_CONTROL_MSS_SHIFT	0
#define DMA_CH_CONTROL_PBLx8		0x00010000
#define DMA_CH_CONTROL_DSL_MASK		0x001c0000	/* Descriptor Skip Length */
#define DMA_CH_CONTROL_DSL_SHIFT	18		/*   (in DWORDS)      */
#define DMA_CH_CONTROL_SPH		0x01000000	/* Split Headers */

/* DMA Channel Tx Control register */
#define DMA_CH_TX_CONTROL_PBL_MASK	0x00003f00	/* Programmable Burst Len */
#define DMA_CH_TX_CONTROL_PBL_SHIFT	16
#define DMA_CH_TX_CONTROL_IPBL		0x00008000	/* Ignore PBL requirement */
#define DMA_CH_TX_CONTROL_TSE		0x00001000	/* TCP Segmentation */
#define DMA_CH_TX_CONTROL_OSP		0x00000010	/* Operate on Second Packet */
#define DMA_CH_TX_CONTROL_ST		0x00000001	/* Start */

/* DMA Channel Rx Control register */
#define DMA_CH_RX_CONTROL_MAMS		0x08000000	/* MAC Address Match Status */
#define DMA_CH_RX_CONTROL_PBL_MASK	0x00003f00	/* Programmable Burst Len */
#define DMA_CH_RX_CONTROL_PBL_SHIFT	16
#define DMA_CH_RX_CONTROL_RBSZ_MASK	0x00007FFE	/* Receive Buffer size */
#define DMA_CH_RX_CONTROL_RBSZ_SHIFT	1
#define DMA_CH_RX_CONTROL_SR		0x00000001	/* Start */

/* DMA Channel Interrupt Enable */
#define DMA_CH_INTR_ENA_NIE		0x00010000	/* Normal Interrupt Summary */
#define DMA_CH_INTR_ENA_ERIE		0x00000800	/* Early Receive */
#define DMA_CH_INTR_ENA_RIE		0x00000040	/* Receive Interrupt */
#define DMA_CH_INTR_ENA_TIE		0x00000001	/* Transmit Interrupt */
#define DMA_CH_INTR_ENA_TBUE		0x00000004	/* Transmit Buffer Unavailable */

#define DMA_CH_INTR_NORMAL	(DMA_CH_INTR_ENA_NIE | DMA_CH_INTR_ENA_RIE | DMA_CH_INTR_ENA_TIE)

/* DMA Abnormal interrupt */
#define DMA_CH_INTR_ENA_AIE		0x00008000	/* Abnormal Interrupt Summary */
#define DMA_CH_INTR_ENA_CDEE		0x00002000	/* Context Descriptor Error */
#define DMA_CH_INTR_ENA_FBEE		0x00001000	/* Fatal Bus Error */
#define DMA_CH_INTR_ENA_ETIE		0x00000400	/* Early Transmit Interrupt */
#define DMA_CH_INTR_ENA_RWTE		0x00000200	/* Receive Watchdog */
#define DMA_CH_INTR_ENA_RSE		0x00000100	/* Receive Stopped */
#define DMA_CH_INTR_ENA_RBUE		0x00000080	/* Receive Buffer Unavailable */
#define DMA_CH_INTR_ENA_TXSE		0x00000002	/* Transmit Stopped */

#define DMA_CH_INTR_ABNORMAL	(DMA_CH_INTR_ENA_AIE | DMA_CH_INTR_ENA_FBEE | DMA_CH_INTR_ENA_RBUE | DMA_CH_INTR_ENA_RSE)

/* DMA default interrupt mask */
#define DMA_CH_INTR_DEFAULT_MASK	(DMA_CH_INTR_NORMAL | DMA_CH_INTR_ABNORMAL)

/* DMA Channel Interrupt Status */
#define DMA_CH_STATUS_REB_MASK	0x00380000	/* RX Error Bits Mask */
#define DMA_CH_STATUS_TEB_MASK	0x00070000	/* TX Error Bits Mask */
#define DMA_CH_STATUS_NIS	0x00008000	/* Normal Interrupt Summary */
#define DMA_CH_STATUS_AIS	0x00004000	/* Abnormal Interrupt Summary */
#define DMA_CH_STATUS_CDE	0x00002000	/* Context Descriptor Error */
#define DMA_CH_STATUS_FBE	0x00001000	/* Fatal Bus Error Interrupt */
#define DMA_CH_STATUS_ERI	0x00000800	/* Early Receive Interrupt */
#define DMA_CH_STATUS_ETI	0x00000400	/* Early Transmit Interrupt */
#define DMA_CH_STATUS_RWT	0x00000200	/* Receive Watchdog Timeout */
#define DMA_CH_STATUS_RPS	0x00000100	/* Receive Process Stopped */
#define DMA_CH_STATUS_RBU	0x00000080	/* Receive Buffer Unavailable */
#define DMA_CH_STATUS_RI	0x00000040	/* Receive Interrupt */
#define DMA_CH_STATUS_TBU	0x00000004	/* Transmit Buffer Unavailable */
#define DMA_CH_STATUS_TPS	0x00000002	/* Transmit Process Stopped */
#define DMA_CH_STATUS_TI	0x00000001	/* Transmit Interrupt */

/*
 * MTL BLOCK defines
 */
/*MTL CRS Control and Status Register Mapping */
#define MTL_OPERATION_MODE			0x00000c00
#define MTL_INTERRUPT_STATUS			0x00000c20
#define MTL_TXQ0_OPERATION_MODE			0x00000d00
#define MTL_TXQ0_UNDERFLOW			0x00000d04
#define MTL_TXQ0_INTERRUPT_CONTROL_STATUS	0x00000d2c
#define MTL_RXQ0_OPERATION_MODE			0x00000d30
#define MTL_RXQ0_CONTROL			0x00000d3c

/* register defines */
#define MTL_INTERRUPT_STATUS_Q0IS		0x00000001

#define MTL_TXQ_OPERATION_MODE_TTC
enum ttc_control {
	MTL_TXQ_OPERATION_MODE_TTC_32 = 0x00000000,
	MTL_TXQ_OPERATION_MODE_TTC_64 = 0x00000010,
	MTL_TXQ_OPERATION_MODE_TTC_96 = 0x00000020,
	MTL_TXQ_OPERATION_MODE_TTC_128 = 0x00000030,
	MTL_TXQ_OPERATION_MODE_TTC_192 = 0x00000040,
	MTL_TXQ_OPERATION_MODE_TTC_256 = 0x00000050,
	MTL_TXQ_OPERATION_MODE_TTC_384 = 0x00000060,
	MTL_TXQ_OPERATION_MODE_TTC_512 = 0x00000070,
};

#define MTL_TXQ_OPERATION_MODE_TSF	0x00000002 /* Transmit Store and Forward */
#define MTL_TXQ_OPERATION_MODE_FTQ	0x00000001 /* Flush transmit Queue */
#define MTL_TXQ_OPERATION_MODE_TTC_MASK	0x70	   /* Transmit Threshold Control*/

/* Threshold for Deactivating the FC */
enum rfd {
	deac_full_minus_1 = 0x00000000,
	deac_full_minus_2 = 0x00002000,
	deac_full_minus_4 = 0x00004000,
	deac_full_minus_5 = 0x00006000,
	deac_full_minus_6 = 0x00008000,
	deac_full_minus_8 = 0x0000A000,
	deac_full_minus_12 = 0x0000c000,
	deac_full_minus_24 = 0x0000e000,
};

/* Threshold for Activating the FC */
enum rfa {
	act_full_minus_1 = 0x00000000,
	act_full_minus_2 = 0x00000100,
	act_full_minus_4 = 0x00000200,
	act_full_minus_5 = 0x00000300,
	act_full_minus_6 = 0x00000400,
	act_full_minus_8 = 0x00000500,
	act_full_minus_12 = 0x00000600,
	act_full_minus_24 = 0x00000700,
};

#define MTL_RXQ_OPERATION_MODE_EHFC	0x00000080
#define MTL_RXQ_OPERATION_MODE_DT	0x00000040 /* Disable Drop TCP/IP csum error */
#define MTL_RXQ_OPERATION_MODE_RSF	0x00000020 /* Receive Store and Forward */
#define MTL_RXQ_OPERATION_MODE_FEP	0x00000010 /* Forward error packets */
#define MTL_RXQ_OPERATION_MODE_FUP	0x00000008 /* Forward Undersized Good Packets */
#define MTL_RXQ_OPERATION_MODE_RTC_MASK	0x00000003 /* Receive Queue Threshold Control */

enum rtc_control {
	MTL_RXQ0_OPERATION_MODE_RTC_64 = 0x00000000,
	MTL_RXQ0_OPERATION_MODE_RTC_32 = 0x00000001,
	MTL_RXQ0_OPERATION_MODE_RTC_96 = 0x00000002,
	MTL_RXQ0_OPERATION_MODE_RTC_128 = 0x00000003,
};

/* Max Size of a single tx buffer */
#define TX_MAX_BUF_SIZE			0x3fffU

/* Tx Descriptors needed, worst case */
#define TXD_USE_COUNT(S) DIV_ROUND_UP((S), TX_MAX_BUF_SIZE)

#endif /* __DWEQOS_H__ */
