/*******************************************************************************
  Copyright (C) 2007-2009  STMicroelectronics Ltd

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Author: Giuseppe Cavallaro <peppe.cavallaro@st.com>
*******************************************************************************/

#ifndef __STMMAC_H__
#define __STMMAC_H__

#define STMMAC_RESOURCE_NAME	"dwmac"
#define DRV_MODULE_VERSION	"Oct_2011"
#include <linux/phy.h>
#include "dweqos_platform.h"
#include "common.h"
#include "descs.h"

struct dweqos_buffer {
    struct sk_buff *skbuff;
    dma_addr_t skbuff_dma;
    u32 skbuff_dma_len;
};

struct stmmac_priv {
	/* Frequently used values are kept adjacent for cache effect */
	struct dma_tx_desc *dma_tx ____cacheline_aligned;
	dma_addr_t dma_tx_phy;
	struct dweqos_buffer *tx_buffer_info;
	unsigned int cur_tx;
	unsigned int dirty_tx;
	unsigned int tx_desc_count;
	int tx_coalesce;

	struct dma_rx_desc *dma_rx;
	unsigned int cur_rx;
	unsigned int dirty_rx;
	struct dweqos_buffer *rx_buffer_info;

	struct net_device *netdev;
	dma_addr_t dma_rx_phy;
	unsigned int rx_desc_count;
	unsigned int dma_buf_sz;
	struct device *dev;
	struct mac_device_info *hw;
	void __iomem *ioaddr;
	unsigned short cur_mss;
	unsigned short cur_vlan_ctag;
	struct stmmac_extra_stats xstats;
	struct napi_struct napi;
	int no_csum_insertion;
	int id;

	struct phy_device *phydev;
	int oldlink;
	int speed;
	int oldduplex;
	unsigned int flow_ctrl;
	unsigned int pause;
	struct mii_bus *mii_bus;

	u32 msg_enable;
	spinlock_t lock;
	spinlock_t tx_lock;
	int wolopts;
	int wol_irq;
	struct dweqos_platform_data *plat;
	struct stmmac_counters mmc;
	struct mac_features mac_cap;
	int hw_cap_support;
	struct clk *stmmac_clk;
	int clk_csr;
	int synopsys_id;
};

extern int dweqos_mdio_register(struct net_device *ndev);
extern int dweqos_mdio_unregister(struct net_device *ndev);
extern void dweqos_set_ethtool_ops(struct net_device *netdev);
extern const struct stmmac_desc_ops ndesc_ops;

int stmmac_probe(struct net_device *ndev);
int stmmac_hw_init(struct stmmac_priv *priv);
void stmmac_clk_csr_set(struct stmmac_priv *priv);
#endif /* __STMMAC_H__ */
