/*
 *	webcam.h -- USB webcam gadget driver header
 *
 *	Copyright (C) 2016-2017 OTUS
 *  OTUS added header file, to allow kernel-mode driver and use-mode application
 *  sharing the same compiler options.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 */

#ifndef __WEBCAM_H__
#define __WEBCAM_H__

#define UVC_ISO_MAX_TRANSFER	1024	//1024, 2048, 3072

#define WEBCAM_UVC_BULK_PIPE		1	// 1 if enabled, 0 if disabled
#define WEBCAM_UAC_AUDIO_ENABLE		0	// 1 if enabled, 0 if disabled

#define WEBCAM_CAMERA_TERMINAL_ID	1
#define WEBCAM_PROCESS_UNIT_ID		2
#define WEBCAM_USB_TERMINAL_ID		3
#define WEBCAM_EXTENSION_UNIT_ID	0	// 5 if enabled, 0 if disabled
#define WEBCAM_YUV420_640x480		1	// 1 if enabled, 0 if disabled
#define WEBCAM_YUV420_1280x720		1	// 1 if enabled, 0 if disabled
#define WEBCAM_YUV420_1920x1080		1	// 1 if enabled, 0 if disabled
#define WEBCAM_MJPEG_640x480		1	// 1 if enabled, 0 if disabled
#define WEBCAM_MJPEG_1280x720		1	// 1 if enabled, 0 if disabled
#define WEBCAM_MJPEG_1920x1080		1	// 1 if enabled, 0 if disabled
#define WEBCAM_H264_640x480			1	// 1 if enabled, 0 if disabled
#define WEBCAM_H264_1280x720		1	// 1 if enabled, 0 if disabled
#define WEBCAM_H264_1920x1080		1	// 1 if enabled, 0 if disabled

#if WEBCAM_UVC_BULK_PIPE == 1

#if WEBCAM_YUV420_640x480 > 0
#define WEBCAM_YUV420_640x480_FPS_0	15
#define WEBCAM_YUV420_640x480_FPS_1	10
#define WEBCAM_YUV420_640x480_FPS_2	5
#endif
#if WEBCAM_YUV420_1280x720 > 0
#define WEBCAM_YUV420_1280x720_FPS_0	5
#define WEBCAM_YUV420_1280x720_FPS_1	3
#define WEBCAM_YUV420_1280x720_FPS_2	2
#endif
#if WEBCAM_YUV420_1920x1080 > 0
#define WEBCAM_YUV420_1920x1080_FPS_0	3
#define WEBCAM_YUV420_1920x1080_FPS_1	2
#define WEBCAM_YUV420_1920x1080_FPS_2	1
#endif

#if WEBCAM_MJPEG_640x480 > 0
#define WEBCAM_MJPEG_640x480_FPS_0	30
#define WEBCAM_MJPEG_640x480_FPS_1	15
#define WEBCAM_MJPEG_640x480_FPS_2	10
#endif
#if WEBCAM_MJPEG_1280x720 > 0
#define WEBCAM_MJPEG_1280x720_FPS_0	15	// 30
#define WEBCAM_MJPEG_1280x720_FPS_1	10	// 15
#define WEBCAM_MJPEG_1280x720_FPS_2	6	// 10
#endif
#if WEBCAM_MJPEG_1920x1080 > 0
#define WEBCAM_MJPEG_1920x1080_FPS_0	10	// 30
#define WEBCAM_MJPEG_1920x1080_FPS_1	6	// 15
#define WEBCAM_MJPEG_1920x1080_FPS_2	5	// 10
#endif

#if WEBCAM_H264_640x480 > 0
#define WEBCAM_H264_640x480_FPS_0	30
#define WEBCAM_H264_640x480_FPS_1	15
#define WEBCAM_H264_640x480_FPS_2	10
#endif
#if WEBCAM_H264_1280x720 > 0
#define WEBCAM_H264_1280x720_FPS_0	30
#define WEBCAM_H264_1280x720_FPS_1	15
#define WEBCAM_H264_1280x720_FPS_2	10
#endif
#if WEBCAM_H264_1920x1080 > 0
#define WEBCAM_H264_1920x1080_FPS_0	30
#define WEBCAM_H264_1920x1080_FPS_1	15
#define WEBCAM_H264_1920x1080_FPS_2	10
#endif

#else

#if WEBCAM_YUV420_640x480 > 0
#define WEBCAM_YUV420_640x480_FPS_0	15
#define WEBCAM_YUV420_640x480_FPS_1	10
#define WEBCAM_YUV420_640x480_FPS_2	5
#endif
#if WEBCAM_YUV420_1280x720 > 0
#define WEBCAM_YUV420_1280x720_FPS_0	5
#define WEBCAM_YUV420_1280x720_FPS_1	3
#define WEBCAM_YUV420_1280x720_FPS_2	2
#endif
#if WEBCAM_YUV420_1920x1080 > 0
#define WEBCAM_YUV420_1920x1080_FPS_0	3
#define WEBCAM_YUV420_1920x1080_FPS_1	2
#define WEBCAM_YUV420_1920x1080_FPS_2	1
#endif

#if WEBCAM_MJPEG_640x480 > 0
#define WEBCAM_MJPEG_640x480_FPS_0	7	// 30
#define WEBCAM_MJPEG_640x480_FPS_1	5	// 15
#define WEBCAM_MJPEG_640x480_FPS_2	3	// 10
#endif
#if WEBCAM_MJPEG_1280x720 > 0
#define WEBCAM_MJPEG_1280x720_FPS_0	3	// 30
#define WEBCAM_MJPEG_1280x720_FPS_1	2	// 15
#define WEBCAM_MJPEG_1280x720_FPS_2	1	// 10
#endif
#if WEBCAM_MJPEG_1920x1080 > 0
#define WEBCAM_MJPEG_1920x1080_FPS_0	3	// 15
#define WEBCAM_MJPEG_1920x1080_FPS_1	2	// 12
#define WEBCAM_MJPEG_1920x1080_FPS_2	1	// 10
#endif

#if WEBCAM_H264_640x480 > 0
#define WEBCAM_H264_640x480_FPS_0	30	// 30
#define WEBCAM_H264_640x480_FPS_1	15	// 15
#define WEBCAM_H264_640x480_FPS_2	10	// 10
#endif
#if WEBCAM_H264_1280x720 > 0
#define WEBCAM_H264_1280x720_FPS_0	30	// 30
#define WEBCAM_H264_1280x720_FPS_1	15	// 15
#define WEBCAM_H264_1280x720_FPS_2	10	// 10
#endif
#if WEBCAM_H264_1920x1080 > 0
#define WEBCAM_H264_1920x1080_FPS_0	20	// 30, may see dropped USB packet if set to 30 fps.
#define WEBCAM_H264_1920x1080_FPS_1	15	// 15
#define WEBCAM_H264_1920x1080_FPS_2	10	// 10
#endif

#endif


#if (WEBCAM_YUV420_640x480 > 0) || (WEBCAM_YUV420_1280x720 > 0) || (WEBCAM_YUV420_1920x1080 > 0)
#define WEBCAM_YUV420_FORMAT		1
#else
#define WEBCAM_YUV420_FORMAT		0
#endif
#if (WEBCAM_MJPEG_640x480 > 0) || (WEBCAM_MJPEG_1280x720 > 0) || (WEBCAM_MJPEG_1920x1080 > 0)
#define WEBCAM_MPJEG_FORMAT			1
#else
#define WEBCAM_MPJEG_FORMAT			0
#endif
#if (WEBCAM_H264_640x480 > 0) || (WEBCAM_H264_1280x720 > 0) || (WEBCAM_H264_1920x1080 > 0)
#define WEBCAM_H264_FORMAT			1
#else
#define WEBCAM_H264_FORMAT			0
#endif
#define WEBCAM_FORMAT_NUMBERS		(WEBCAM_YUV420_FORMAT + WEBCAM_MPJEG_FORMAT + WEBCAM_H264_FORMAT)

#if WEBCAM_FORMAT_NUMBERS == 0
#undef  WEBCAM_FORMAT_NUMBERS
#define WEBCAM_FORMAT_NUMBERS		1
#error at least one WEBCAM format is required!
#endif

enum yuv420_frame_index
{
	you420_frame_index_na = 0,
#if WEBCAM_YUV420_640x480 > 0
	yuv420_frame_index_640x480,
#endif
#if WEBCAM_YUV420_1280x720 > 0
	yuv420_frame_index_1280x720,
#endif
#if WEBCAM_YUV420_1920x1080 > 0
	yuv420_frame_index_1920x1080,
#endif
	yuv420_frame_index_max
};

enum mjpeg_frame_index
{
	mjpeg_frame_index_na = 0,
#if WEBCAM_MJPEG_640x480 > 0
	mjpeg_frame_index_640x480,
#endif
#if WEBCAM_MJPEG_1280x720 > 0
	mjpeg_frame_index_1280x720,
#endif
#if WEBCAM_MJPEG_1920x1080 > 0
	mjpeg_frame_index_1920x1080,
#endif
	mjpeg_frame_index_max
};

enum h264_frame_index
{
	h264_frame_index_na = 0,
#if WEBCAM_H264_640x480 > 0
	h264_frame_index_640x480,
#endif
#if WEBCAM_H264_1280x720 > 0
	h264_frame_index_1280x720,
#endif
#if WEBCAM_H264_1920x1080 > 0
	h264_frame_index_1920x1080,
#endif
	h264_frame_index_max
};

enum uvc_format_index
{
	uvc_format_index_na = 0,
#if WEBCAM_H264_FORMAT > 0
	uvc_format_index_h264,
#endif
#if WEBCAM_MPJEG_FORMAT > 0
	uvc_format_index_mjpeg,
#endif
#if WEBCAM_YUV420_FORMAT > 0
	uvc_format_index_yuv420,
#endif
	uvc_format_index_max
};

#endif

