#ifndef    __N9_HEAD_H
#define    __N9_HEAD_H

/* OSDE start*/
#define OSDE_SHARE_BUF_SIZE             0xF000
#define OSDE_SHARE_ADDR                 0x4500000
#define INTR_CMD_ADDR                   OSDE_SHARE_ADDR + OSDE_SHARE_BUF_SIZE
#define INTR_CMD_DONE                   INTR_CMD_ADDR
#define INTR_BUF_DONE                   INTR_CMD_ADDR + 0x04
#define INTR_CMD_NUM                    INTR_CMD_ADDR + 0x08
/* OSDE_SHARE_BUF_SIZE + INTR_xxx_SIZE */
#define TOTAL_SHARE_BUF_SIZE            0xF00C
#define INTR_STATUS_SIZE				0xC
#define MBQP_COMPUTE                    0x10
#define AUDIO_AEC                    	0x20
#define WBLEND                          0x30
#define DELTA_INTERLACE                 0x40

#define DELTA_FLAG 						0
/* OSDE end*/

/*TODO: arrange the data order sequence*/
/*TODO: change to union message for saving memory
 *      struct vMessage {
 *      	int head;
 *      	union
 *      	{
 *		struct osde osde;
 *		struct mbqp mbqp;
 *		};
 *      };
 *	struct osde {
 *		int src;
 *		int dst;
 *	};
 *	struct mbqp {
 *		unsigned int env_w;
 *		unsigned int env_h;
 *	};
 *
 * */
typedef struct vMBQP
{
	unsigned int enc_w;
	unsigned int enc_h;
	unsigned int rsize_w;
	unsigned int rsize_h;
	unsigned int fv_w;
	unsigned int mgrid_w;
	unsigned int mgrid_h;
	unsigned int istate_grid_w;
	unsigned int istate_grid_h;
	void*        rsize_y_ptr;
	void*        mask_buf;
	void*        fv_addr;

} mbqp_t;

typedef struct vAEC
{
	void*        input_buf;
	void*        ref_buf;
	char*        config_ptr;
	void*	     output_buf;
} aec_t;

typedef struct vPWM
{
	unsigned int pwm_start;		// 1: go, 0:stop
	int 	     pwm_count[4];
	unsigned int pwm_gap; 		// count numbers for n9
	unsigned int pwm_gpioc;		// gpio controller
	unsigned int pwm_gpio_num[4];	// gpio number:[group]
	unsigned int pwm_gpio_pin[4][4];// gpio pin[group][pin]
	unsigned int pwm_status_num[4]; // 1~8, [group]
	unsigned short pwm_status[4][4][8];// [group][pin][status]
} pwm_t;

typedef struct vWeightedBlending
{
        void *phy_buf;
        void *filter_table;
        void *filter_256;
        int blending_size;
        int stride;
        int height;
        unsigned int skip_blending_width;
        unsigned int bottom_data_offset[2][3];
        unsigned int top_data_offset[2][3];
        unsigned int flush_data_offset[3];
} weighted_blending_msg_t;

typedef struct image_data
{
        int width;
        int height;
        uint8_t *data[4];
} IMAGE_DATA;

#if DELTA_FLAG
typedef struct vDelta
{
	/*IMAGE_DATA *yuv420_input_buf;
	IMAGE_DATA *yuv422_output_buf;
	* */
	int width;
	int height;
	int mirror;
	int flip;
	uint8_t *data_in[4];
	uint8_t *data_out[4];
} delta_t;
#endif

typedef struct _ipc_message{
	int head;
	union {
		mbqp_t mbqp;
		aec_t  aec;
		pwm_t  pwm;
		weighted_blending_msg_t wblend;
#if DELTA_FLAG
		delta_t delta;
#endif
	};
}ipc_message_t;

#define PWM_INFO_CHANNEL        0
#define PWM_STATUS_CHANNEL      1 
void n9_pwm_init(void);
int n9_pwm_status(void);
void n9_pwm_send(ipc_message_t* cmd);

#define N9_IPC_CHANNEL_BASE_ADDR	0x1404000
#define N9_IO_CHANNEL_BASE_ADDR	        0x5000000
#define N9_CHANNEL_SIZE            	8192
#define N9_CHANNEL_NUM			6
#define TX_STATUS			0x0
#define RX_STATUS			0x1
#define IPC_TYPE_BLOCKING               0x0
#define IPC_TYPE_NON_BLOCKING           0x1

#define NTA_ISR_CHANNEL			0x3
#define ATN_ISR_CHANNEL			0x4
#define OWNER_N9                        0x0
#define OWNER_ARM			0x1
#define LOOP_TIMES                      10000000
typedef struct _ipc_channel{
	volatile int 	n9[2]; 		// ONLY n9 can modify
	int		n9dummy[6];     // for n9 align with cacheline size
	volatile int	arm[2];		// ONLY arm can modify
	volatile int  	active_ch;
	volatile int    done;
	volatile int    ch_type;
	volatile int    command;
	void* 		data;
} ipc_channel_t;

#define N9_MAGIC          	     0xd1
#define N9_MBQP_COMPUTE              _IOW(N9_MAGIC, 0, ipc_channel_t)
#define N9_PWM_SEND                  _IOW(N9_MAGIC, 1, ipc_channel_t)
#define N9_AUDIO_AEC                 _IOW(N9_MAGIC, 2, ipc_channel_t)
#define N9_WBLEND                    _IOW(N9_MAGIC, 3, ipc_channel_t)
#define N9_DELTA_INTERLACE           _IOW(N9_MAGIC, 4, ipc_channel_t)
#endif

