/*
 * Watchdog Driver for VPL watchdog timer.
 *
 * Copyright (C) 2013-2018  VATICS Inc.
 *
 * Author: ChangHsien Ho <vincent.ho@vatics.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __VPL_WDT_H__
#define __VPL_WDT_H__

#define version_fourcc(a, b, c, d)\
	((__u32)(a) | ((__u32)(b) << 8) | ((__u32)(c) << 16) | ((__u32)(d) << 24))

#define VPL_WDT_VERSION version_fourcc(1, 0, 0, 0)

#define WDTC_DEFAULT_TIMEOUT 30

#define WDTC_VERSION		0x00
#define WDTC_CTRL               0x04
#define WDTC_STAT               0x08
#define WDTC_COUNT              0x0c
#define WDTC_RELOAD_VALUE       0x10
#define WDTC_MATCH_VALUE        0x14
#define WDTC_RELOAD_CTRL        0x18
#define WDTC_RST_LEN            0x1c

#define WDTC_CTRL_ACK_EN	0x2
#define WDTC_CTRL_OP_EN		0x4
#define WDTC_RELOAD_PASSWD	0x28791166
#define WDTC_RESET_LEN		0xffff

#endif /* __VPL_WDT_H__ */
