/*
 *  include/linux/irqchip/pesaro.h
 *
 *  Copyright (C) 2007-2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_IRQCHIP_PESARO_H
#define __LINUX_IRQCHIP_PESARO_H

#define INTC_VERSION                0x00
#define INTC_SRC_LO                 0x04
#define INTC_SRC_HI                 0x08
#define INTC_HOSTU_0_STAT_LO        0x0c
#define INTC_HOSTU_0_STAT_HI        0x10
#define INTC_HOSTU_1_STAT_LO        0x14
#define INTC_HOSTU_1_STAT_HI        0x18
#define INTC_HOSTU_0_MASK_LO        0x1c
#define INTC_HOSTU_0_MASK_HI        0x20
#define INTC_HOSTU_1_MASK_LO        0x24
#define INTC_HOSTU_1_MASK_HI        0x28
#define INTC_CLEAR_LO               0x2c
#define INTC_CLEAR_HI               0x30
#define INTC_TRIGGER_MODE_LO        0x34
#define INTC_TRIGGER_MODE_HI        0x38
#define INTC_SET_LO                 0x3c
#define INTC_SET_HI                 0x40
#define INTC_META_DATA_0            0x44
#define INTC_META_DATA_1            0x48
#define INTC_META_DATA_2            0x4c
#define INTC_META_DATA_3            0x50
#define INTC_HOSTU_0_IRQ_NUM        0x54
#define INTC_HOSTU_1_IRQ_NUM        0x58
#define INTC_INTR_PRI_START         0x5c
#define INTC_INTR_PRI_END           0x158

#endif /* __LINUX_IRQCHIP_PESARO_H */
