/*
 * Pesaro_Audio_dwc
 * Driver for Pesaro Audio Codec dwc.
 *
 * Copyright (C) 2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/module.h>
#include <linux/io.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/regmap.h>
#include <linux/regulator/consumer.h>
#include <linux/spi/spi.h>
#include <linux/of_device.h>

#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/initval.h>
#include <sound/tlv.h>

#include "vatics-asoc.h"

BLOCKING_NOTIFIER_HEAD(hdmi_audio_notifier_list);
int register_hdmi_audio_notifier(struct notifier_block *nb)
{
        return blocking_notifier_chain_register(&hdmi_audio_notifier_list, nb);
}
EXPORT_SYMBOL(register_hdmi_audio_notifier);

struct hdmi_priv {
	unsigned int sysclk;
	enum snd_soc_control_type control_type;
};

static int hdmi_write(struct snd_soc_codec *codec, unsigned int reg, unsigned int val)
{
	/*TODO implement it*/
	int ret = 0;
	//struct hdmi_priv *dwc = snd_soc_codec_get_drvdata(codec);
	return ret ;
}

__maybe_unused int hdmi_read(struct snd_soc_codec* codec, int reg)
{
	int data = 0;
	/*TODO implement it*/

	return data;
}

static int hdmi_hw_params(struct snd_pcm_substream *substream,
			    struct snd_pcm_hw_params *params,
			    struct snd_soc_dai *dai)
{
//TODO implement it
/*NOTE: I2S mode or sampling freq is change, reset to the data paths
 *      is recommended
 */      
	//struct snd_soc_codec *codec = dai->codec;
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}
static int hdmi_mute(struct snd_soc_dai *dai, int mute)
{
//TODO implement it
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}
static int sample_rate = 0;
static int dwc_set_dai_clkdiv(struct snd_soc_dai *codec_dai,
		int div_id, int div)
{
	VPL_DEBUG("%s +++\n", __func__);
	printk("hdmi sample rate:%d\n", div);
	sample_rate = div;
	blocking_notifier_call_chain(&hdmi_audio_notifier_list, 0, &sample_rate);
	return 0;
}

static int hdmi_set_dai_sysclk(struct snd_soc_dai *codec_dai,
		int clk_id, unsigned int freq, int dir)
{
//TODO implement it
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}

static int hdmi_set_dai_fmt(struct snd_soc_dai *codec_dai,
		unsigned int fmt)
{
//TODO implement it
/*NOTE: I2S mode or sampling freq is change, reset to the data paths
 *      is recommended
 */      
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}

static int hdmi_set_bias_level(struct snd_soc_codec *codec,
				 enum snd_soc_bias_level level)
{
//TODO implement it
	switch (level) {
		case SND_SOC_BIAS_ON:
			//VPL_DEBUG("%s, SND_SOC_BIAS_ON\n", __func__);
			break;
		case SND_SOC_BIAS_PREPARE:
			//VPL_DEBUG("%s, SND_SOC_BIAS_PREPARE\n", __func__);
			break;
		case SND_SOC_BIAS_STANDBY:
			//VPL_DEBUG("%s, SND_SOC_BIAS_STANDBY\n", __func__);
			break;
		case SND_SOC_BIAS_OFF:
			//VPL_DEBUG("%s, SND_SOC_BIAS_OFF\n", __func__);
			break;
	}

	return 0;
}
static const struct snd_soc_dai_ops hdmi_dai_ops = {
	.hw_params	= hdmi_hw_params,
	.digital_mute	= hdmi_mute,
	.set_clkdiv	= dwc_set_dai_clkdiv,
	.set_sysclk	= hdmi_set_dai_sysclk,
	.set_fmt	= hdmi_set_dai_fmt,
};

static struct snd_soc_dai_driver hdmi_dai = {
	.name = "hdmi-hifi",
	.playback = {
		.stream_name = "hdmi_Playback",
		.channels_min = 2,
		.channels_max = 8,
		.rates = (SNDRV_PCM_RATE_32000 |SNDRV_PCM_RATE_44100 |\
			  SNDRV_PCM_RATE_48000 |SNDRV_PCM_RATE_88200 |\
			  SNDRV_PCM_RATE_96000 |SNDRV_PCM_RATE_176400|\
			  SNDRV_PCM_RATE_192000),
		.formats = SNDRV_PCM_FMTBIT_S16_LE,
		},
	.ops = &hdmi_dai_ops,
};


static int hdmi_codec_probe(struct snd_soc_codec *codec)
{
	__maybe_unused struct hdmi_priv *dwc = snd_soc_codec_get_drvdata(codec);
//	struct hdmi_setup_data *pdata = codec->dev->platform_data;
//	u32 reg;
	int ret = 0;
	VPL_DEBUG("%s +++\n", __func__);
	return ret;

/*NOTE: This is supposed to be standard io function settiong*/
#if 0
	ret = snd_soc_codec_set_cache_io(codec, 8, 16, dwc->control_type);
	if (ret < 0) {
		dev_err(codec->dev, "Failed to set cache I/O: %d\n", ret);
		return ret;
	}
#endif

	hdmi_set_bias_level(codec, SND_SOC_BIAS_STANDBY);

//TODO add widgets
#if 0
	ret = snd_soc_add_codec_controls(codec, hdmi_snd_controls,
			     array_size(hdmi_snd_controls));
	if (ret)
		return ret;
	ret = hdmi_add_widgets(codec);
#endif
	return ret;
}

static int hdmi_codec_remove(struct snd_soc_codec *codec)
{
	VPL_DEBUG("%s +++\n", __func__);
	hdmi_set_bias_level(codec, SND_SOC_BIAS_OFF);
	return 0;
}

#ifdef CONFIG_PM
static int hdmi_codec_suspend(struct snd_soc_codec *codec)
{
	VPL_DEBUG("%s +++\n", __func__);
	hdmi_set_bias_level(codec, SND_SOC_BIAS_OFF);
	return 0;
}

static int hdmi_codec_resume(struct snd_soc_codec *codec)
{
	VPL_DEBUG("%s +++\n", __func__);
	hdmi_set_bias_level(codec, SND_SOC_BIAS_STANDBY);
	return 0;
}
#else
#define hdmi_codec_suspend NULL
#define hdmi_codec_resume NULL
#endif

static struct snd_soc_codec_driver soc_codec_dev_hdmi = {
	.probe =	hdmi_codec_probe,
	.remove =	hdmi_codec_remove,
	.suspend =	hdmi_codec_suspend,
	.resume =	hdmi_codec_resume,
	.set_bias_level = hdmi_set_bias_level,
	.write          = hdmi_write,
/*TODO add widget/control functions*/
#if 0
	.dapm_widgets = hdmi_dapm_widgets,
	.num_dapm_widgets = ARRAY_SIZE(hdmi_dapm_widgets),
	.dapm_routes = hdmi_intercon,
	.num_dapm_routes = ARRAY_SIZE(hdmi_intercon),
	.controls =	hdmi_snd_controls,
	.num_controls = ARRAY_SIZE(hdmi_snd_controls),
#endif
};

#if 0
static const struct of_device_id hdmi_audio_of_match[] = {
	{ .compatible = "snps,designware-audio", },
	{},
};
MODULE_DEVICE_TABLE(of, hdmi_audio_of_match);
#endif

static int hdmi_driver_probe(struct platform_device *pdev)
{
	int ret;
	struct hdmi_priv *hdmi_audio;
	VPL_DEBUG("%s +++\n", __func__);

	hdmi_audio = kzalloc(sizeof(struct hdmi_priv), GFP_KERNEL);
	if (hdmi_audio == NULL)
		return -ENOMEM;
//TODO: add support for i2sClkSrc
#if 0
	/* Setup PLL clock source */
	if(i2sClkSrc) {
		reg =  readl(IOMEM((DWORD)sysc_base + SYSC_IF_CTRL));
		reg |=  (0x1<<25); /* PLL2 Source 0:18.432 MHz / 1:24 MHz*/
		VATICS_APBC_WRITEL(reg, IOMEM((DWORD)sysc_base + SYSC_IF_CTRL));
	}
#endif

	ret = snd_soc_register_codec(&pdev->dev,
			&soc_codec_dev_hdmi, &hdmi_dai, 1);
	if(ret < 0) {
		printk("hdmi audio failed to init!!\n");
		goto err;
	}
	VPL_DEBUG("%s ---\n", __func__);
	return ret;

err:
	return ret;


}

static int hdmi_driver_exit(struct platform_device *pdev)
{
	snd_soc_unregister_codec(&pdev->dev);
	return 0;
}

MODULE_ALIAS("platform:hdmi_audio");

struct platform_driver hdmi_audio_driver = {
	.probe          = hdmi_driver_probe,
	.remove         = hdmi_driver_exit,
	.driver         = {
		.name   = "hdmi_audio",
		.owner  = THIS_MODULE,
//		.of_match_table = of_match_ptr(hdmi_audio_of_match),
	},
};


EXPORT_SYMBOL(hdmi_audio_driver);

MODULE_DESCRIPTION("ASoC hdmi audio driver");
MODULE_LICENSE("GPL");
