/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

/*FIXME: remove me later*/
#include <linux/i2c.h>

#include <asm/dma.h>
#include <mach/hardware.h>

#include "../codecs/wm8940.h"

//#define VPL_DEBUG
#include "vatics-asoc.h"

/* 24 MHz only !!! for current driver!*/
static int i2sClkSrc = 1;

static int evm_hw_params(struct snd_pcm_substream *substream, struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;
	int ret = 0;
	unsigned int sysclk_div = 0, bclk_div = 0;

	/*set fmt*/
	ret = snd_soc_dai_set_fmt(codec_dai, SND_SOC_DAIFMT_I2S |
				SND_SOC_DAIFMT_CBM_CFM);
	 if (ret < 0) {
	 	pr_warning("set fmt to codec dai failed.\n");
	 	return ret;
	 }

	/*set clksel source as internal PLL*/
	ret = snd_soc_dai_set_clkdiv(codec_dai, WM8940_CLKSEL, 1); 
	 if (ret < 0) {
	 	pr_warning("set MCLKSEL to codec dai failed.\n");
	 	return ret;
	 }

	switch (params_rate(params)) {
		case 44100:
			sysclk_div = (i2sClkSrc) ? 4 : 24;
			break;
		case 48000:
		case 32000:
		case 16000:
		case 8000:
			sysclk_div = (i2sClkSrc) ? 4 : 22;
			break;
		default:
			pr_warning("vaudio-evm: Unsupported sample rate %d\n", params_rate(params));
			return -EINVAL;
	}

	ret = snd_soc_dai_set_clkdiv(codec_dai, WM8940_MCLKDIV, 0);
	if (ret < 0) {
		pr_warning("set MCLKDIV to codec dai failed.\n");
		return ret;
	}

	ret = snd_soc_dai_set_clkdiv(cpu_dai, 0, sysclk_div);

	if (i2sClkSrc == 1) {
		ret = snd_soc_dai_set_pll(cpu_dai, 0, 0, 0, 12000000);
		ret = snd_soc_dai_set_pll(codec_dai, 0, 0, 12000000, params_rate(params)* 256);
//		ret = snd_soc_dai_set_pll(codec_dai, 0, 0, 6144000, params_rate(params)* 256);
		if (ret < 0) {
			pr_warning("set PLL to codec dai failed.\n");
			return ret;
		}
	}

	/*XXX for auto 8k, it has some issue, we hard its register in codec*/
	if (params_rate(params) != 8000) {
		bclk_div = 0x3;
		ret = snd_soc_dai_set_clkdiv(codec_dai, WM8940_BCLKDIV, bclk_div);
		if (ret < 0) {
			pr_warning("set BCLKDIV to codec dai failed.\n");
			return ret;
		}
	}
	return 0;
}

static struct snd_soc_ops evm_ops = {
	.hw_params = evm_hw_params,
};

static int evm_codec_init(struct snd_soc_pcm_runtime *rtd)
{
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}

static int hdmi_params(struct snd_pcm_substream *substream, struct snd_pcm_hw_params *params)
{
   struct snd_soc_pcm_runtime *rtd = substream->private_data;
   struct snd_soc_dai *codec_dai = rtd->codec_dai;
   struct snd_soc_dai *cpu_dai = rtd->cpu_dai;

   VPL_DEBUG("%s +++\n", __func__);
   snd_soc_dai_set_clkdiv(cpu_dai, 1, params_rate(params));
   snd_soc_dai_set_clkdiv(codec_dai, 0, params_rate(params));

   return 0;
}

static struct snd_soc_ops hdmi_ops = {
   .hw_params = hdmi_params,
};

static int dwc_audio_init(struct snd_soc_pcm_runtime *rtd)
{
   VPL_DEBUG("%s +++\n", __func__);
   return 0;
}

static int hdmi_audio_init(struct snd_soc_pcm_runtime *rtd)
{
   VPL_DEBUG("%s +++\n", __func__);
   return 0;
}

static struct snd_soc_dai_link evm_dai[] = {
    {
        .name = "EVM_WM8940",
        .stream_name = "WM8940",
        .cpu_dai_name = VPL_PLATFORM,
        .platform_name = VPL_PLATFORM,
        .codec_dai_name = "wm8940-hifi",
        /*NOTE: must use this naming style NAME.I2CBus-I2Caddr*/
        .codec_name = "wm8940.2-001a",
        .init = evm_codec_init,
        .ops = &evm_ops,
    },
    {
        .name = "Pesaro_HDMI_Audio",
        .stream_name = "hdmi_audio",
        .cpu_dai_name = VPL_PLATFORM,
        .platform_name = VPL_PLATFORM,
        .codec_dai_name = "hdmi-hifi",
        .codec_name = "hdmi_audio.0",
        /*TODO seperate the init and evm_ops here*/
        .init = hdmi_audio_init,
        .ops = &hdmi_ops,
    },
};


static struct snd_soc_card snd_soc_card_evm = {
	.name = "Vatics_evm",
	.owner = THIS_MODULE,
	.dai_link = &evm_dai,
	.num_links = ARRAY_SIZE(evm_dai),
};

static struct platform_device *evm_snd_device;

static struct platform_device *hdmi_audio_device;
extern struct platform_driver hdmi_audio_driver;

extern struct i2c_driver wm8940_i2c_driver;
static int __init evm_init(void)
{
	struct snd_soc_card *evm_snd_dev_data;
	int ret;

	VPL_DEBUG("%s +++\n", __func__);
/*FIXME: REMOVE ME
 *	 we dont need i2c(codec) driver init here in the future
 */
	i2c_add_driver(&wm8940_i2c_driver);

	platform_driver_register(&hdmi_audio_driver);
    hdmi_audio_device = platform_device_alloc("hdmi_audio", 0);
    ret = platform_device_add(hdmi_audio_device);
    if (ret)
        platform_device_put(hdmi_audio_device);

	evm_snd_dev_data = &snd_soc_card_evm;

	evm_snd_device = platform_device_alloc("soc-audio", 0);
	if (!evm_snd_device)
		return -ENOMEM;

	platform_set_drvdata(evm_snd_device, evm_snd_dev_data);

	ret = platform_device_add(evm_snd_device);
	if (ret)
		platform_device_put(evm_snd_device);

	return ret;
}

static void __exit evm_exit(void)
{
	VPL_DEBUG("%s +++\n", __func__);
	platform_device_unregister(evm_snd_device);
	return;
}

module_init(evm_init);
module_exit(evm_exit);

MODULE_LICENSE("GPL");

