/*
 * Copyright (C) 2013  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

/*FIXME: remove me later*/
#include <linux/i2c.h>

#include <asm/dma.h>
#include <mach/hardware.h>

#include "vatics-asoc.h"

#define VAUDIO_EVM_DRIVER_VERSION		"1.0.0.0"
#define VAUDIO_EVM_COMPANY				"VATICS Inc."
#define VAUDIO_EVM_PLATFORM				"EVM"

const char vaudioevm_id[] = "$VaudioEvm: "VAUDIO_EVM_DRIVER_VERSION" "VAUDIO_EVM_PLATFORM" "__DATE__" "VAUDIO_EVM_COMPANY" $";

static int dwc_params(struct snd_pcm_substream *substream, struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	__maybe_unused struct snd_soc_dai *cpu_dai = rtd->cpu_dai;

	VPL_DEBUG("%s +++\n", __func__);

	snd_soc_dai_set_pll(cpu_dai, 0, 0, 0, 12000000);
	snd_soc_dai_set_clkdiv(cpu_dai, 0, params_rate(params));
	snd_soc_dai_set_clkdiv(codec_dai, 0, params_rate(params));
	return 0;
}

static struct snd_soc_ops dwc_ops = {
	.hw_params = dwc_params,
};

static int hdmi_params(struct snd_pcm_substream *substream, struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;

	VPL_DEBUG("%s +++\n", __func__);
	snd_soc_dai_set_clkdiv(cpu_dai, 1, params_rate(params));
	snd_soc_dai_set_clkdiv(codec_dai, 0, params_rate(params));

	return 0;
}

static struct snd_soc_ops hdmi_ops = {
	.hw_params = hdmi_params,
};

static int dwc_audio_init(struct snd_soc_pcm_runtime *rtd)
{
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}

static int hdmi_audio_init(struct snd_soc_pcm_runtime *rtd)
{
	VPL_DEBUG("%s +++\n", __func__);
	return 0;
}

static struct snd_soc_dai_link pesaro_evm_dai[] = {
	{
		.name = "Pesaro_DWC_Audio",
		.stream_name = "dwc_audio",
		.cpu_dai_name = VPL_PLATFORM,
		.platform_name = VPL_PLATFORM,
		.codec_dai_name = "dwc-hifi",
		.codec_name = "dwc_audio.0",
		.init = dwc_audio_init,
		.ops = &dwc_ops,
	},
	{
		.name = "Pesaro_HDMI_Audio",
		.stream_name = "hdmi_audio",
		.cpu_dai_name = VPL_PLATFORM,
		.platform_name = VPL_PLATFORM,
		.codec_dai_name = "hdmi-hifi",
		.codec_name = "hdmi_audio.0",
		/*TODO seperate the init and evm_ops here*/
		.init = hdmi_audio_init,
		.ops = &hdmi_ops,
	},
};

static struct snd_soc_card snd_soc_card_pesaro_evm = {
	.name = "pesaro_evm",
	.owner = THIS_MODULE,
	.dai_link = pesaro_evm_dai,
	.num_links = ARRAY_SIZE(pesaro_evm_dai),
};

static struct platform_device *evm_snd_device;
static struct platform_device *dwc_audio_device;
extern struct platform_driver dwc_audio_driver;

static struct platform_device *hdmi_audio_device;
extern struct platform_driver hdmi_audio_driver;

static int __init evm_init(void)
{
	struct snd_soc_card *evm_snd_dev_data;
	int ret;

	VPL_DEBUG("%s +++\n", __func__);
       platform_driver_register(&dwc_audio_driver);
       dwc_audio_device = platform_device_alloc("dwc_audio", 0);
       ret = platform_device_add(dwc_audio_device);
       if (ret)
               platform_device_put(dwc_audio_device);

       platform_driver_register(&hdmi_audio_driver);
       hdmi_audio_device = platform_device_alloc("hdmi_audio", 0);
       ret = platform_device_add(hdmi_audio_device);
       if (ret)
               platform_device_put(hdmi_audio_device);

	evm_snd_dev_data = &snd_soc_card_pesaro_evm;

	evm_snd_device = platform_device_alloc("soc-audio", 0);
	if (!evm_snd_device)
		return -ENOMEM;

	platform_set_drvdata(evm_snd_device, evm_snd_dev_data);

	ret = platform_device_add(evm_snd_device);
	if (ret)
		platform_device_put(evm_snd_device);

	return ret;
}

static void __exit evm_exit(void)
{
	VPL_DEBUG("%s +++\n", __func__);
	platform_device_unregister(evm_snd_device);
	return;
}

module_init(evm_init);
module_exit(evm_exit);

MODULE_DESCRIPTION("VATICS Inc. Pesaro EVM ASoC driver");
MODULE_LICENSE("GPL");

