#ifndef _VATICS_ASOC_H
#define _VATICS_ASOC_H

//#define DEBUG

#ifdef DEBUG
#define VPL_DEBUG(args...) printk(KERN_INFO "[ASOC]"args);
#else
#define VPL_DEBUG(args...)
#endif

#ifdef pr_warning
#undef pr_warning
#endif

#define pr_warning(fmt, ...) \
	printk(KERN_WARNING pr_fmt("[ASOC]"fmt), ##__VA_ARGS__)

#include <mach/irqs.h>
#include <mach/maps.h>
#include <mach/hardware.h>
//#include <mach/platform.h>

#define VPL_PLATFORM "vatics-pcm"

#define PERIOD_BYTES_MAX	16380

// SSP
#define SSP0_TX                         PESARO_I2SSC_TX_MMR_BASE
#define SSP0_RX                         PESARO_I2SSC_RX_MMR_BASE

#define I2S_IER				0x00000000
#define I2S_IRER				0x00000004
#define I2S_ITER				0x00000008
#define I2S_CER				0x0000000c
#define I2S_CCR				0x00000010
#define I2S_RXFFR			0x00000014
#define I2S_TXFFR			0x00000018
#define I2S_RER				0x00000028
#define I2S_TER				0x0000002C
#define I2S_RCR				0x00000030
#define I2S_TCR				0x00000034
#define I2S_ISR				0x00000038
#define I2S_IMR				0x0000003C
#define I2S_ROR				0x00000040
#define I2S_TOR				0x00000044
#define I2S_RFCR				0x00000048
#define I2S_TFCR				0x0000004C
#define I2S_RFF0				0x00000050
#define I2S_TFF0				0x00000054
#define I2S_RXDMA			0x000001C0
#define I2S_RRXDMA			0x000001C4
#define I2S_TXDMA			0x000001C8
#define I2S_RTXDMA			0x000001CC
#define I2S_COMP_PARAM_2	0x000001F0
#define I2S_COMP_PARAM_1	0x000001F4
#define I2S_COMP_VERSION	0x000001F8
#define I2S_COMP_TYPE		0x000001FC


// APBC DMA
#define APBC_BASE			PESARO_APBC_MMR_BASE
#define V_APBC_BASE     		IO_ADDRESS(APBC_BASE)
#define APBC_VERSION		(APBC_BASE+0x80)
#define APBC_DMA_BASE		(APBC_BASE+0x88)

enum {
	DMA_CHN_0 = 0,
	DMA_CHN_1,
	DMA_CHN_2,
	DMA_CHN_3,
	DMA_CHN_4,
	DMA_CHN_5,
	DMA_CHN_6,
	DMA_CHN_7,
	DMA_CHN_8,
	DMA_CHN_9,
	DMA_CHN_10,
	DMA_CHN_11,
	DMA_CHN_12,
	DMA_CHN_13,
	DMA_CHN_14,
	DMA_CHN_15,
};

#define APBC_DMA_SRC_ADDR(chn)	(0x00000090+chn*0x10)
#define APBC_DMA_DES_ADDR(chn)	(0x00000094+chn*0x10)
#define APBC_DMA_LLP(chn)			(0x00000098+chn*0x10)
#define APBC_DMA_CTRL(chn)			(0x0000009C+chn*0x10)

#define APBC_DMA_CHN_MONITOR		0x8c

#define APBC_IRQ              0

/* ======================================================================== */
#define VATICS_VPL_SSP_READL(base, reg)		__raw_readl(IOMEM((base) + (reg)))
#define VATICS_VPL_SSP_WRITEL(base, reg, val)	__raw_writel((val), IOMEM((base) + (reg)))

#define VATICS_APBC_READL(reg)				__raw_readl(IOMEM(V_APBC_BASE + (reg)))
#define VATICS_APBC_WRITEL(reg,val)			__raw_writel((val), IOMEM(V_APBC_BASE + (reg)))

#define VATICS_ADCC_WRITEL(reg,val)			 __raw_writel((val), IOMEM(reg))
/* ======================================================================== */

struct vatics_pcm_dma_params {
	int irq;
	int irq_acks;
	int chn;		/* DMA channel */
	struct dma_regs_t *  desc_addr;
};

struct vatics_audio_dev {
	struct vatics_pcm_dma_params dma_params[2];
	void __iomem *sysc_base;
	struct device *dev;
};

struct vatics_runtime_data {
	spinlock_t lock;
	int dev_num;		/* device num */
	struct vatics_pcm_dma_params *dma_data;	/* DMA params */
};

struct dma_regs_t{
	unsigned long dwSrc_Addr;
	unsigned long dwDes_Addr;
	unsigned long dwLLP_Addr;
	unsigned long dwCtrl;
};

enum {
	VATICS_I2S0 = 0,
	VATICS_I2S_NUM,
};

static __maybe_unused unsigned int ssp_tx[VATICS_I2S_NUM] = {
	SSP0_TX
};

static __maybe_unused unsigned int ssp_rx[VATICS_I2S_NUM] = {
	SSP0_RX
};

/*symbol export to i2s driver*/
int vatics_soc_platform_register(struct device *dev);

#endif /* _VATICS_ASOC_H */
