#ifndef _VATICS_ASOC_H
#define _VATICS_ASOC_H

//#define DEBUG_APP
#define DEBUG_LOOPBACK
//#define DEBUG

#ifdef DEBUG
#define VPL_DEBUG(args...) printk(KERN_INFO "[ASOC]"args);
#else
#define VPL_DEBUG(args...)
#endif

#include <mach/irqs.h>
#include <mach/maps.h>
#include <mach/hardware.h>
#include <linux/cdev.h>
#include <linux/notifier.h>

#define VPL_PLATFORM "vatics-pcm"

#define PERIOD_BYTES_MAX	16380
// SYSC
#define SYSC_BASE               		VPL_SYSC_MMR_BASE
#define SYSC_ID_VERSION       			0x00000000
#define SYSC_I2S_CLK_PARAM 			0x0000002C
#define SYSC_I2S_CLK_ENABLE			0x00000028
#define SYSC_I2S_ENABLE				0x00000800
#define SYSC_IF_CTRL                    	0x00000048

// register offset
#define SYSC_PAD_EN_CTRL_5                      0x000000B0
#define SYSC_I2SSC_CTRL_0                       0x00000058
#define SYSC_I2SSC_CTRL_1                       0x0000005C

// SYSC_I2SSC_CTRL_0, shift
#define I2SSC_TX_WS_DIV                         24
#define I2SSC_TX_SCLK_DIV                       16
#define I2SSC_TX_MCLK_DIV                       8
#define I2SSC_RX_MCLK_DIV                       0
// SYSC_I2SSC_CTRL_1, shift
#define I2SSC_MCLK_PAD_OUT_DRV_CTRL             20
#define I2SSC_PAD_OUT_DRV_CTRL                  16
#define I2SSC_MCLK_PAD_SR_CTRL                  12
#define I2SSC_TX_DST_SRC_SEL                    8
#define I2SSC_TX_SCLK_SRC_SEL                   4
#define I2SSC_RX_SCLK_SRC_SEL                   0

#define PLLC_5_CTRL                             0x2C
#define PLLC_5_DIV                              0x30

// SSP
#define SSP0_TX                         PESARO_I2SSC_TX_MMR_BASE
#define SSP0_RX                         PESARO_I2SSC_RX_MMR_BASE

#define I2S_IER				0x00000000
#define I2S_IRER				0x00000004
#define I2S_ITER				0x00000008
#define I2S_CER				0x0000000c
#define I2S_CCR				0x00000010
#define I2S_RXFFR			0x00000014
#define I2S_TXFFR			0x00000018
#define I2S_RER				0x00000028
#define I2S_TER				0x0000002C
#define I2S_RCR				0x00000030
#define I2S_TCR				0x00000034
#define I2S_ISR				0x00000038
#define I2S_IMR				0x0000003C
#define I2S_ROR				0x00000040
#define I2S_TOR				0x00000044
#define I2S_RFCR				0x00000048
#define I2S_TFCR				0x0000004C
#define I2S_RFF0				0x00000050
#define I2S_TFF0				0x00000054
#define I2S_RXDMA			0x000001C0
#define I2S_RRXDMA			0x000001C4
#define I2S_TXDMA			0x000001C8
#define I2S_RTXDMA			0x000001CC
#define I2S_COMP_PARAM_2	0x000001F0
#define I2S_COMP_PARAM_1	0x000001F4
#define I2S_COMP_VERSION	0x000001F8
#define I2S_COMP_TYPE		0x000001FC


// APBC DMA
#define APBC_BASE			PESARO_APBC_MMR_BASE
#define V_APBC_BASE     		IO_ADDRESS(APBC_BASE)
#define APBC_VERSION		(APBC_BASE+0x80)
#define APBC_DMA_BASE		(APBC_BASE+0x88)

enum {
	DMA_CHN_0 = 0,
	DMA_CHN_1,
	DMA_CHN_2,
	DMA_CHN_3,
	DMA_CHN_4,
	DMA_CHN_5,
	DMA_CHN_6,
	DMA_CHN_7,
	DMA_CHN_8,
	DMA_CHN_9,
	DMA_CHN_10,
	DMA_CHN_11,
	DMA_CHN_12,
	DMA_CHN_13,
	DMA_CHN_14,
	DMA_CHN_15,
};

#define APBC_DMA_SRC_ADDR(chn)	(0x00000090+chn*0x10)
#define APBC_DMA_DES_ADDR(chn)	(0x00000094+chn*0x10)
#define APBC_DMA_LLP(chn)			(0x00000098+chn*0x10)
#define APBC_DMA_CTRL(chn)			(0x0000009C+chn*0x10)

#define APBC_DMA_CHN_MONITOR		0x8c

#define APBC_IRQ              0

/* ======================================================================== */
#define VATICS_VPL_SSP_READL(base, reg)		__raw_readl(IOMEM((base) + (reg)))
#define VATICS_VPL_SSP_WRITEL(base, reg, val)	__raw_writel((val), IOMEM((base) + (reg)))

#define VATICS_APBC_READL(reg)				__raw_readl(IOMEM(V_APBC_BASE + (reg)))
#define VATICS_APBC_WRITEL(reg,val)			__raw_writel((val), IOMEM(V_APBC_BASE + (reg)))

#define VATICS_ADCC_WRITEL(reg,val)			 __raw_writel((val), IOMEM(reg))
/* ======================================================================== */

struct vivo_pcm_dma_params {
	int irq;
	int irq_acks;
	int chn;		/* DMA channel */
	struct dma_regs_t *  desc_addr;
};

struct vivo_dma_buffer {
	unsigned char *area;    /* virtual pointer */
	dma_addr_t    dma_addr; /* physical address */
	size_t        bytes;    /* buffer size in bytes */
	unsigned char *app_idx;  /* app_index for the buffer */
	int direction;
	struct vivo_audio_dev *adev;
};

struct vivo_runtime_data {
	spinlock_t lock;
	int dev_num;		/* device num */
	struct vivo_pcm_dma_params *dma_data;	/* DMA params */
	struct vivo_audio_dev *adev;
};

struct vivo_audio_dev {
	//struct vivo_pcm_dma_params dma_params[2];
	void __iomem *sysc_base;
	void __iomem *pllc_base;
	void __iomem *dwc_base;
	struct vivo_dma_buffer* dma_buffer[2]; // 0: for playback, 1: for capture
	struct vivo_runtime_data* prtd[2];
	struct device *dev;
	int runtime_periods;
	int runtime_dmasize;
	int sample_rate;

	struct cdev cdev;
};

struct dma_regs_t{
	unsigned long dwSrc_Addr;
	unsigned long dwDes_Addr;
	unsigned long dwLLP_Addr;
	unsigned long dwCtrl;
};

enum {
	VATICS_I2S0 = 0,
	VATICS_I2S_NUM,
};

enum {
	AUDIO_STREAM_PLAYBACK = 0,
	AUDIO_STREAM_CAPTURE  = 1,
};

enum {
	AUDIO_TRIGGER_START = 0,
	AUDIO_TRIGGER_STOP  = 1,
};

static __maybe_unused unsigned int ssp_tx[VATICS_I2S_NUM] = {
	SSP0_TX
};

static __maybe_unused unsigned int ssp_rx[VATICS_I2S_NUM] = {
	SSP0_RX
};
/* i2s export functions */
int vivo_i2s_init(struct vivo_audio_dev *adev);
int vivo_i2s_trigger(int cmd, int direction);
/* codec export functions */
int vivo_codec_init(struct vivo_audio_dev *adev);
int vivo_codec_set_clkdiv(int div);
int vivo_codec_trigger(int cmd, int direction);
/* pcm export function */
int vivo_pcm_new(struct vivo_audio_dev *adev, int direction);
int vivo_pcm_close(struct vivo_audio_dev *adev);
int vivo_pcm_trigger(struct vivo_audio_dev *adev, int cmd, int direction);
unsigned int vivo_pcm_pointer(struct vivo_audio_dev *adev, int direction);
int register_playback_notifier(struct notifier_block *nb);
int register_capture_notifier(struct notifier_block *nb);

/* helper function */
unsigned int addr_to_period_num(struct vivo_dma_buffer *dma_buffer);
void* period_num_to_addr(struct vivo_dma_buffer *dma_buffer,
					unsigned int num);
void* get_pre_hwaddr(struct vivo_dma_buffer *dma_buffer);
void* get_next_hwaddr(struct vivo_dma_buffer *dma_buffer);

#endif /* _VATICS_ASOC_H */
