/*
 * Pesaro_Audio_dwc
 * Driver for Pesaro Audio Codec dwc.
 *
 * Copyright (C) 2014  VATICS Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/module.h>
#include <linux/io.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/regmap.h>
#include <linux/regulator/consumer.h>
#include <linux/spi/spi.h>
#include <linux/of_device.h>
#include <linux/clk.h>

#include "vivo_audio.h"

/* dwc define */
#define ACDCC_VERSION                          0x00
#define ACDCC_CTRL                             0x04
#define ACDCC_RESET                            0x14
#define ACDCC_LATCH                            0x18
#define ACDCC_CLK_SEL0                         0x1C
#define ACDCC_CLK_SEL1                         0x20
#define ACDCC_I2S_CONFIG0                      0x24
#define ACDCC_I2S_CONFIG1                      0x28
#define ACDCC_I2S_CONFIG2                      0x2C
#define ACDCC_PWR_MANAGEMENT                   0x30 
#define ACDCC_PWR_CTRL0                        0x34
#define ACDCC_PWR_CTRL1                        0x38
#define ACDCC_PWR_CTRL3                        0x40
#define ACDCC_MUTE_CTRL0                       0x48 
#define ACDCC_MUTE_CTRL1                       0x4C
#define ACDCC_RECORD_VOL                       0x54
#define ACDCC_PGA_VOL                          0x5C
#define ACDCC_PLAYBACK_VOL                     0x64 
#define ACDCC_RECORD_INPUT_SEL                 0x6C 
#define ACDCC_PLAYBACK_MIXER_CTRL              0x78 
#define ACDCC_ALC_CTRL0                        0x80 
#define ACDCC_ALC_CTRL1                        0x84
#define ACDCC_ALC_CTRL2                        0x88
#define ACDCC_ALC_RMAP_DOWN_CTRL               0x8C
#define ACDCC_ALC_RMAP_UP_CTRL                 0x90 
#define ACDCC_ALC_MAX_AUTO_GAIN                0x94 
#define ACDCC_DIGITAL_NOISE_GATE               0x98 
#define ACDCC_DIGITAL_TEST                     0x9C 
#define ACDCC_ADC_HIGH_PASS_MIXER              0xA0 
#define ACDCC_DAC_MIXER                        0xA4 
#define ACDCC_SOFT_RAMPING                     0xA8 
#define ACDCC_DIGITAL_ASS_TEST1                0xB4 
#define ACDCC_DIGITAL_ASS_TEST2                0xB8 
#define ACDCC_DIGITAL_ASS_TEST3                0xBC
#define ACDCC_DIGITAL_ASS_TEST4                0xC0
#define ACDCC_DIGITAL_ASS_TEST5                0xC4 
#define ACDCC_PURE_ANALOG_TEST0                0xC8 
#define ACDCC_PURE_ANALOG_TEST1                0xCC 
#define ACDCC_PURE_ANALOG_TEST2                0xD0 
#define ACDCC_PURE_ANALOG_TEST3                0xD4 

static void *dwc_base;
static void *sysc_base;

inline void do_latch(void)
{
        mdelay(10);
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_LATCH, 0x1);
        mdelay(10);
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_LATCH, 0x0);

}

inline void dwc_data_path_reset(void)
{
	/* reset data path */
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RESET, 0x0); // set low
	do_latch();
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RESET, 0x3); // set high
	do_latch();
}

int dwc_mute(int direction, int mute)
{
	VPL_DEBUG("%s +++, mute:%d\n", __func__, mute);
	/*FIXME, the mute method may cause some noise, we do nothing in mute function now*/
	return 0;
	if (mute) {
		VATICS_ADCC_WRITEL(dwc_base + ACDCC_MUTE_CTRL1, 0x43);
	} else {
		VATICS_ADCC_WRITEL(dwc_base + ACDCC_MUTE_CTRL1, 0x0);
	}
	do_latch();
	//dwc_data_path_reset();
	return 0;
}

int vivo_codec_set_clkdiv(int div)
{
	u32 reg=0;
	VPL_DEBUG("%s +++\n", __func__);
	switch (div) {
		case 48000:
			reg = 0x8;
			break;
		case 44100:
			reg = 0x7;
			break;
		case 32000:
			reg = 0x6;
			break;
		case 16000:
			reg = 0x3;
			break;
		case 8000:
			reg = 0x0;
			break;
	}
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_I2S_CONFIG1, reg);  // sfsdac
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_I2S_CONFIG0, reg);  // sfsadc
	dwc_data_path_reset();
	return 0;
}

int vivo_codec_trigger(int cmd, int direction)
{
	VPL_DEBUG("%s +++\n", __func__);
	if (direction != AUDIO_STREAM_PLAYBACK)
		return 0;
	switch (cmd) {
		case AUDIO_TRIGGER_START:
			VATICS_ADCC_WRITEL(dwc_base + ACDCC_MUTE_CTRL1, 0x0);
			break;
		case AUDIO_TRIGGER_STOP:
			VATICS_ADCC_WRITEL(dwc_base + ACDCC_MUTE_CTRL1, 0x43);
			break;
	}
	do_latch();
	return 0;

}

__maybe_unused static void dump_reg(void)
{
	u32 reg;
	u32 offset = 0;
	int counter = 0;

	printk("\n");
	for (offset = 0 ; offset <= 0xd0 ; offset= offset+0x4, counter++ )
	{
		reg =  readl(IOMEM(dwc_base + offset));
		printk("0x%02x=0x%x  ", offset, reg);
		if ((counter % 4) == 3)
			printk("\n");
	}
	printk("\n");
	return;
}

static int dwc_codec_probe(void)
{
	int ret = 0;
	struct clk *clk;
	VPL_DEBUG("%s +++\n", __func__);

	/* start the master clocks, mclkadc, mclkdac */
	clk = clk_get(NULL, "vpl_acdcc");
	if (IS_ERR(clk)) {
		pr_err("Failed to get vpl_acdcc clock\n");
		return PTR_ERR(clk);
	}
	clk_prepare_enable(clk);

	// master reset
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x0);
	// need delay here?
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x1);

	// soft reset
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x3);
	// need delay here?
	
	// pdz0
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x0); //R21
	do_latch();

	// R2 setting mclkadc 12M
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CLK_SEL0, 0x2);
        mdelay(10);
	// R3 setting mclkdac 12M
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CLK_SEL1, 0x2);
	do_latch();

	// R21 Mic Bias 1 and vcmbuf power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x6);
	// R22 PGA and ADC power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL1, 0x5);
	// R24 PGA and ADC power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL3, 0x89);
	do_latch();

	VATICS_ADCC_WRITEL(dwc_base + ACDCC_I2S_CONFIG2, 0x19);// set master mode
	do_latch();
	dwc_data_path_reset();

	/* set pdz to high */
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x5); // power-up all and MicBias1
	do_latch();

	/*set digital playback source*/
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PLAYBACK_MIXER_CTRL, 0x0);

	/*set input line1p*/
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RECORD_INPUT_SEL, 0x0);
	/*mic-input*/
	//VATICS_ADCC_WRITEL(dwc_base + ACDCC_RECORD_INPUT_SEL, 0x2);
	do_latch();

	if (ret)
		return ret;
//	dump_reg();
	return ret;
}

int vivo_codec_init(struct vivo_audio_dev *adev)
{
	dwc_base = adev->dwc_base;
	sysc_base = adev->sysc_base;
	dwc_codec_probe();
	return 0;
}

