/*
 * Command for eFuse processing.
 *
 * Copyright (C) 2014 Vatics Corporation
 */
#include <common.h>
#include <malloc.h>
#include <asm/io.h>

#include <asm/arch/platform.h>

int efuse_write(unsigned int addr, unsigned int index, unsigned int len, unsigned long debug_en  );
int efuse_read(unsigned int addr, unsigned long debug_en  );
int eFuse_init( void );

static int parse_parameter(int argc, char *argv[])
{
	unsigned long access_mode = 0;
	unsigned long addr;
	unsigned long idx;
	unsigned long len;
	unsigned long  debug_enable = 0;
	char *endp;
	int ret;
	int time = 0;
	unsigned long data[4] =  {0};

	access_mode = strcmp(argv[1], "write") ?1:0;		//mode, 1 read, 0 write
	if (*argv[1] == 0 )
		goto usage;
	printf("mode: %d\n", access_mode );

	if ( !access_mode ) { // write mode only

		addr = simple_strtoul(argv[2], &endp, 16);		//addr
		if (*argv[2] == 0 || *endp != 0)
			goto usage;
		printf("addr: %d\n", addr );

		idx = simple_strtoul(argv[3], &endp, 16);		// bit index
		if (*argv[3] == 0 || *endp != 0)
			goto usage;
		printf("idx: %d\n", idx );

		len = simple_strtoul(argv[4], &endp, 16);		// bit len
		if (*argv[4] == 0 || *endp != 0)
			goto usage;
		printf("len: %d\n", len );

		debug_enable = simple_strtoul(argv[5], &endp, 16);	// debug time, >1s let human sensible.
		if (*argv[5] == 0 || *endp != 0)
			goto usage;
		printf("debug? %d\n", len );

		if ( len < 1 || len > 32) {
			puts("bit number 1~32  bits\n");
			return 1;
		}
	}
	
	time = get_timer(0);
	printf("start: %d\n", time );

	if ( access_mode ) {
		ret = efuse_read( data, debug_enable);
		printf("data[ 31:  0]: %8x, \ndata[ 63: 32]: %8x, \ndata[ 95: 64]: %8x, \ndata[127: 96]: %8x", data[0], data[1], data[2], data[3]);
	}
	else
		ret = efuse_write( &addr, idx, len, debug_enable);

	if (ret) {
		printf(" VPL efuse %s failed\n", argv[0]);
		return 1;
	}
	
	time = get_timer(time);
	printf("\nend: %d\n", time);
	
	return 0;

usage:
	printf("Usage:  %s write data bitindex bitlen debugmode\n", argv[0]);
	return 1;
}

static int do_efuse_operation(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	const char *cmd;
	unsigned int	tmp = 0;

	/* need 3 arguments */
	printf("argc: %d\n", argc );
	
	if (strcmp(argv[1], "write") == 0 )
		if (argc < 5)
			goto usage;
	
	eFuse_init();

	cmd = argv[0];

	if (strcmp(cmd, "efuse") == 0 ) {
		tmp =parse_parameter(argc, argv);
		return tmp;
	}

usage:
	cmd_usage(cmdtp);
	return 1;
}

U_BOOT_CMD(
	efuse,	6,	1,	do_efuse_operation,
	"eFuse read/write",
	"efuse write dataaddr bitindex bitlen debug_time - write `len' bites starting at\n"
	"				  `PHYSICAL addr'\n"	
	"efuse read dataaddr bitindex bitlen debug_time - read `len' bites starting at\n"
	"				  `PHYSICAL addr'\n"	
);


