/*
 * Command for eFuse processing.
 *
 * Copyright (C) 2013 Vatics Corporation
 */
#include <common.h>
#include <malloc.h>
#include <asm/io.h>

#include <asm/arch/platform.h>
/* for Guiliani */
//#define USE_FIRE_ENGINE 
#define DEBUG

#define AGPOC_CTRL		0x04
#define AGPOC_STATUS	0x08
#define DFT_DATA_OE_N	0x10


#define AGPOC_BIT_pattern(n, p)	(0x1C+4*p+28*n)
#define AGPOC_BIT_pattern0(n)		(0x1C+28*n)
#define AGPOC_BIT_pattern1(n)		(0x20+28*n)
#define AGPOC_BIT_pattern2(n)		(0x24+28*n)
#define AGPOC_BIT_pattern3(n)		(0x28+28*n)
#define AGPOC_BIT_period(n)		(0x2C+28*n)
#define AGPOC_BIT_length(n)		(0x30+28*n)
#define AGPOC_BIT_intervalrepeat(n)	(0x34+28*n)

#define TEST_I_ADDR_SHIFT	8
#define TEST_I_REN_SHIFT		14
#define TEST_O_DAT_SHIFT		15
#define TEST_I_CLK_SHIFT		16
#define TEST_I_AEN_SHIFT		17
#define TEST_I_JUMP_SHIFT	18

#define TEST_I_RDEN		(1<<TEST_I_REN_SHIFT)
#define TEST_O_DAT		(1<<TEST_O_DAT_SHIFT)
#define TEST_I_CLK		(1<<TEST_I_CLK_SHIFT)
#define TEST_I_AEN		(1<<TEST_I_AEN_SHIFT)
#define TEST_I_JMP		(1<<TEST_I_JUMP_SHIFT)

#define GPIO_SET(x)		v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_SET, x)
#define GPIO_CLEAR(x)		v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_CLEAR, x)

void gpio_prog(unsigned int addr)
{		
	printf("#### gpio_prog ................");
	// set A[6:0]
	//v_outl(VPL_GPIOC1_MMR_BASE|GPIOC_DATA_OUT, (addr<<TEST_I_ADDR_SHIFT));
	GPIO_CLEAR(0x7F<<TEST_I_ADDR_SHIFT);
	
	printf("%x\n", (addr<<TEST_I_ADDR_SHIFT));
	GPIO_SET((addr<<TEST_I_ADDR_SHIFT));
	udelay(1000);
		
	printf(" %x\n", TEST_I_AEN);
	GPIO_SET(TEST_I_AEN);
	udelay(10);
	
	GPIO_CLEAR(TEST_I_AEN);
	udelay(1000);
}

int efuse_write(unsigned int addr, unsigned int index, unsigned int len, unsigned long debug_en  )
{
	unsigned int	reg;
	int idx = index, iRet = 0, bitn = 0, i, x;
		
#ifdef  USE_FIRE_ENGINE
	u32 keybit = *(u32*)addr;
	u16 value = 0, n, p;
	u32 pattern[8][4] = {0};
	u32 period = 0, bitvalue;
	u32 pat_bit_seq = 0;

	reg = 0;
	pat_bit_seq = 0;
	v_outl(VPL_AGPOC_MMR_BASE|AGPOC_CTRL, reg ) ; // clear complete status

	// start
	printf("####################################\n");
	
	printf("\nkey: %x\n", keybit);
	for (idx = index; idx < index+len; idx++) 			// process each index (address)
	{
		//printf("idx: %x ",	idx);
		for ( i=0; i <=2; i++, pat_bit_seq++ ) 						// signaling each bit, stage 1 programming
		{
			if ( i == 1) {							// addr_en
				period = 1000;
				value = (keybit >> (idx%16)) ;
			}
			else {								// addr_disable
				period = 1;
				value = 0;
			}
			
			for ( bitn = 0; bitn <=7; bitn++ ) 			// 7 address bit + 1 value bit
			{
				bitvalue = ((bitn == 7) ?  value: idx>>bitn)&1;
				pattern[bitn][pat_bit_seq/32] |= bitvalue<<(pat_bit_seq%32);
				printf("%x", bitvalue);
				
				if ( (idx == index+len-1) && (i == 2) ) {
					// TYPICAL 10 us
					v_outl(VPL_AGPOC_MMR_BASE | AGPOC_BIT_period(bitn),  debug_en? debug_en:(APB_CLOCK/100000) );
					v_outl(VPL_AGPOC_MMR_BASE | AGPOC_BIT_length(bitn),  pat_bit_seq);
					v_outl(VPL_AGPOC_MMR_BASE | AGPOC_BIT_intervalrepeat(bitn),  pat_bit_seq);
				}
			}
			printf("\n", bitvalue);
		}
		printf("\n", bitvalue);
	}
	
	for ( bitn = 0; bitn <=7; bitn++) {
		memcpy( VPL_AGPOC_MMR_BASE | AGPOC_BIT_pattern(bitn, 0), &pattern[bitn][0], 16);
	}
#else
	u32 data = *(u32*)addr;
	u32 addr_tranlated = 0;

	v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_PIN_DIR, 0x7E7F00) ; 		// configure GPIO pin direction
	v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_OUT, TEST_I_RDEN) ; 	// configure GPIO pin to all zero, but bit 18 to high level
	v_outl(VPL_SYSC_MMR_BASE|0xA8, 0x7E7F00) ; 					// GPIO1 pad enable
	udelay(100000);
	
	/* Before writing mode, normal mode reset*/
	GPIO_CLEAR(TEST_I_JMP);									// TEST_I_JMP = 0 is normal mode
	udelay(100000);
	GPIO_CLEAR(TEST_I_RDEN );								// SYS_GLB_RST  = 0, low active to reset
	udelay(100000);

	/* write mode */
	GPIO_SET(0x9<<TEST_I_JUMP_SHIFT );						// write mode 5'b01001 =  1'h9
	
	printf("#### efuse starting ................\n");

	for( idx = index; idx < index+len; idx++ )
	{
		data = *(((u32*)addr)+((idx-index)/32));
		if ( (data&(1<<((idx-index)%32))) )	{
			//gpio_prog(idx);							// original datasheet format
			addr_tranlated = (idx%8)*16 + (idx/8);				// Giuliani format
			gpio_prog(addr_tranlated);							
			printf("bit :%d\n", idx);
		}
	}
#endif	
	printf("eFuse programming done.\n");
	printf("####################################\n");
	return iRet;
	
}

int efuse_read(unsigned int *buf, unsigned long debug_en  )
{
	unsigned int	reg;
	int idx, iRet = 0,  i = 0;
	//unsigned short * pbuf = (unsigned short*)buf; // original datasheet 
	unsigned char * pbuf = (unsigned char*)buf;
	u32 tmp = 0;

	reg = 0;
	
	v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_PIN_DIR, 0x7F4F00) ; 					// configure GPIO pin direction
	v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_OUT, 0x7<<TEST_I_JUMP_SHIFT) ;	// configure GPIO pin direction
	
	// SYSC
	v_outl(VPL_SYSC_MMR_BASE|0xb4, v_inl(VPL_SYSC_MMR_BASE|0xb4)&~0x400) ; 	// disable VOC SECT 0
	v_outl(VPL_SYSC_MMR_BASE|0xA8, 0x7FCf00) ; 								// GPIO1 pad enable
	
	GPIO_SET(0x7<<TEST_I_JUMP_SHIFT );						// write mode 5'b00111 =  1'h7
	udelay(1000);
	
// start
	printf("####################################\n");
	printf("eFuse read start...\n");
		
	for ( idx = 0; idx <16; idx++, i= 0) // total 128 bits, 16bytes
	{
		GPIO_CLEAR(0xF00);
	// set RDEN
		GPIO_SET(TEST_I_RDEN);
		
		// set A[3:0]
		//v_outl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_OUT, tmp|(idx<<TEST_I_ADDR_SHIFT));
		printf("bit Addr %x", (idx));
		GPIO_SET((idx<<TEST_I_ADDR_SHIFT));

		udelay(1);
		
		// enable  AEN
		GPIO_SET(TEST_I_AEN);

		udelay(50000);

		// low AEN
		GPIO_CLEAR(TEST_I_AEN);
		
		udelay(50000);
		
		//clock 1
		GPIO_SET(TEST_I_CLK);
		udelay(50000);

		//Get Data
		tmp = v_inl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_IN);
		pbuf[idx] |= (tmp&TEST_O_DAT) >> TEST_O_DAT_SHIFT << 0;		// datasheet p.10 bit postion is row postion
		printf(" %x, ", (tmp&TEST_O_DAT) >> TEST_O_DAT_SHIFT);

		// clock 0
		GPIO_CLEAR(TEST_I_CLK);
		udelay(50000);

	// low RDEN
		GPIO_CLEAR(TEST_I_RDEN);
		
		// clocking & get 7 bit data
		for ( i = 1; i < 8; i++ )
		{
			//clock 1
			GPIO_SET(TEST_I_CLK);
			udelay(50000);

			//Get Data
			tmp = v_inl(VPL_GPIOC_1_MMR_BASE|GPIOC_DATA_IN);
			//pbuf[i] |= (tmp&TEST_O_DAT) >> TEST_O_DAT_SHIFT << idx;  	/* original datasheet layout */
			pbuf[idx] |= (tmp&TEST_O_DAT) >> TEST_O_DAT_SHIFT << i;  			/* Giuliani layout */
			printf(" %x, ", (tmp&TEST_O_DAT) >> TEST_O_DAT_SHIFT);

			// clock 0
			GPIO_CLEAR(TEST_I_CLK);
			udelay(50000);
		}
		printf("\n");
	}

	printf("eFuse read done.\n");
	printf("####################################\n");
	
	return iRet;
}

// Basically initialize system controller for later GPIOC usage.
int eFuse_init( void )
{
	unsigned int	reg = 0;
	
	// SYSC
	v_outl(VPL_SYSC_MMR_BASE|0x94, v_inl(VPL_SYSC_MMR_BASE|0x94)|0x10000) ; // GPIO1 clock 
		
	return 1;
}


