#ifndef _GMAC_H_
#define _GMAC_H_

#include <phy.h>

extern volatile unsigned long DMA_BUFFER_BASE;
#define DMA_BUFFER_SIZE 1536
#define TX_DESC_COUNT 16
#define RX_DESC_COUNT 16
#define DESC_COUNT (TX_DESC_COUNT+RX_DESC_COUNT)

typedef int bool;

/* ============================================ */
struct tx_desc {
	u32 buffer1_addr;
	u32 buffer2_addr;
	u32 length;
	u32 status;
};

struct rx_desc {
	u32 buffer1_addr;
	u32 reserved;
	u32 buffer2_addr;
	u32 status;
};

enum DmaRegisters             /* DMA engine registers, base address is BAR+DmaRegistersBase */
{
	DmaBusMode		= 0x00,
	DmaSysBusMode		= 0x04,
	DmaIntStatus		= 0x08,
	DmaCH0Control		= 0x100,
	DmaCH0TxControl		= 0x104,
	DmaCH0RxControl		= 0x108,
	DmaCH0TxDescListAddr	= 0x114,
	DmaCH0RxDescListAddr	= 0x11C,
	DmaCH0TxDescTailAddr	= 0x120,
	DmaCH0RxDescTailAddr	= 0x128,
	DmaCH0TxDescRingLength  = 0x12C,
	DmaCH0RxDescRingLength  = 0x130,
	DmaCH0Interrupt		= 0x134,
	DmaCH0RxWDT		= 0x138,
	DmaCH0SlotCtrl		= 0x13C,
	DmaCH0CurtTxDesc	= 0x144,
	DmaCH0CurtRxDesc	= 0x14C,
	DmaCH0CurtTxBuff	= 0x154,
	DmaCH0CurtRxBuff	= 0x15C,
	DmaCH0Status		= 0x160,
};

enum GmacRegisters              /* GMAC registers, base address is BAR+GmacRegistersBase */
{
	GmacConfig		= 0x00,    /* config */
	GmacExtConfig		= 0x04,    /* ext config */
	GmacPacketFilter	= 0x08,    /* frame filter */
	GmacTxQ0FlowControl	= 0x70,    /* Flow control */
	GmacRxFlowControl	= 0x90,
	GmacHWFeature0		= 0x11C,
	GmacHWFeature1		= 0x120,
	GmacHWFeature2		= 0x124,
	GmacGmiiAddr		= 0x200,    /* GMII address */
	GmacGmiiData		= 0x204,    /* GMII data */
	GmacAddr0High		= 0x300,
	GmacAddr0Low		= 0x304,
	/* MTL registers */
	GmacMtlOperation	= 0xC00,
	GmacMtlTxQ0Operation	= 0xD00,
	GmacMtlRxQ0Operation	= 0xD30,
};

/* DMA Burst */
#define DMA_CH_BURST_1		(1 << 16)
#define DMA_CH_BURST_2		(2 << 16)
#define DMA_CH_BURST_4		(4 << 16)
#define DMA_CH_BURST_8		(8 << 16)
#define DMA_CH_BURST_16		(16 << 16)
#define DMA_CH_BURST_32		(32 << 16)
/* Channel Tx Control */
#define DMA_CH_TX_ST		(1 << 0)
/* Channel Rx Control */
#define DMA_CH_RX_SR		(1 << 0)
/* MTL */
#define MTL_TXQ_TSF		(1 << 1)
#define MTL_RXQ_FUP		(1 << 3)
#define MTL_RXQ_RSF		(1 << 5)

/* GMAC Control Defines */
#define GMAC_CONTROL_IPC	0x08000000  /* Checksum Offload */
enum inter_packet_gap {
	GMAC_CONTROL_IPG_88 = 0x01000000,
	GMAC_CONTROL_IPG_80 = 0x02000000,
	GMAC_CONTROL_IPG_40 = 0x07000000,
};

#define GMAC_CONTROL_GPSLCE	0x00800000  /* Enable Giant Packet Size Limit Control */
#define GMAC_CONTROL_S2KP	0x00400000  /* Support for 2K Packets */
#define GMAC_CONTROL_CST	0x00200000  /* CRC stripping */
#define GMAC_CONTROL_ACS	0x00100000  /* Auto Pad/FCS Stripping */
#define GMAC_CONTROL_WD		0x00080000  /* Disable Watchdog on receive */
#define GMAC_CONTROL_BE		0x00040000  /* Frame Burst Enable */
#define GMAC_CONTROL_JD		0x00020000  /* Jabber disable */
#define GMAC_CONTROL_JE		0x00010000  /* Jumbo frame */
#define GMAC_CONTROL_PS		0x00008000  /* Port Select 0:GMI 1:MII */
#define GMAC_CONTROL_FES	0x00004000  /* Speed 0:10 1:100 */
#define GMAC_CONTROL_DM		0x00002000  /* Duplex Mode */
#define GMAC_CONTROL_LM		0x00001000  /* Loop-back mode */
#define GMAC_CONTROL_ECRSFD	0x00000800  /* Enable Carrier Sense BeforeTransmission */
#define GMAC_CONTROL_DO		0x00000400  /* Disable Rx Own */
#define GMAC_CONTROL_DCRS	0x00000200  /* Disable carrier sense */
#define GMAC_CONTROL_DR		0x00000100  /* Disable Retry */
#define GMAC_CONTROL_DC		0x00000010  /* Deferral Check */
#define GMAC_CONTROL_TE		0x00000002  /* Transmitter Enable */
#define GMAC_CONTROL_RE		0x00000001  /* Receiver Enable */

/* DMA Mode defines */
#define DMA_MODE_SFT_RESET	0x00000001	/* Software Reset */

/* txrx status definitions */
#define DESC_TXCTL_OWN		(1 << 31)
#define DESC_TXCTL_CTXT		(1 << 30)
#define DESC_TXCTL_FD		(1 << 29)
#define DESC_TXCTL_LD		(1 << 28)
#define DESC_TX_R_BUF1_LEN_MASK		0x00001fff
#define DESC_TX_R_BUF1_LEN_SHIFT	0

#define DESC_RXCTL_OWN		(1 << 31)
#define DESC_RXCTL_BUF1V	(1 << 24)

#define DESC_RXSTS_FRMLENMSK    (0x3FFF << 0)

struct dw_eqos_priv {
	unsigned long		macBase;	/* base address of MAC registers */
	unsigned long		dmaBase;	/* base address of DMA registers */
	unsigned long		phyAddr;	/* PHY device address on MII interface */
	struct tx_desc		*tx;		/* start of TX descriptors ring */
	struct rx_desc		*rx;		/* start of RX descriptors ring */
	unsigned long		rxCount;	/* number of rx descriptors */
	unsigned long		txCount;    	/* number of tx descriptors */
	u32			txBusy;		/* first descriptor owned by DMA engine, moved by DmaTxGet */
	u32			txNext;    	/* next available tx descriptor, moved by DmaTxSet */
	u32			rxBusy;      	/* first descripror owned by DMA engine, moved by DmaRxGet */
	u32			rxNext;      	/* next available rx descriptor, moved by DmaRxSet */ //CPU available!
	phy_interface_t		interface;
	struct tx_desc		*desc;
	unsigned long		tx_desc_base;
	unsigned long		rx_desc_base;
	char			*tx_buff;
	char			*rx_buff;

	struct mii_dev		*mdio_bus;
	struct phy_device	*phydev;
};

/* -------------------------------------------- */
enum GmacFrameFilterReg /* GMAC frame filter register layout */
{
	GmacFilterOff            = 0x80000000,     /* Receive all incoming packets         RW                */
	GmacFilterOn             = 0,              /* Receive filtered packets only                  0       */
	GmacSrcAddrFilterEnable  = 0x00000200,     /* Source Address Filter enable         RW                */
	GmacSrcAddrFilterDisable = 0,              /*                                                0       */

	GmacSrcInvAddrFilterEn   = 0x00000100,     /* Inverse Source Address Filter enable RW                */
	GmacSrcInvAddrFilterDis  = 0,              /*                                                0       */

	GmacPassControl3         = 0x000000C0,     /* Forwards control frames that pass AF RW                */
	GmacPassControl2         = 0x00000080,     /* Forwards all control frames                            */
	GmacPassControl1         = 0x00000040,     /* Does not pass control frames                           */
	GmacPassControl0         = 00,             /* Does not pass control frames                   00      */
	GmacBroadcastDisable     = 0x00000020,     /* Disable reception of broadcast frames RW               */
	GmacBroadcastEnable      = 0,              /* Enable broadcast frames                        0       */
	GmacMulticastFilterOff   = 0x00000010,     /* Pass all multicast packets           RW                */
	GmacMulticastFilterOn    = 0,              /* Pass filtered multicast packets                0       */

	GmacDestAddrFilterInv    = 0x00000008,     /* Inverse filtering for DA             RW                */
	GmacDestAddrFilterNor    = 0,              /* Normal filtering for DA                        0       */

	GmacMcastHashFilterOn    = 0x00000004,     /* perfom multicast hash filtering      RW                */
	GmacMcastHashFilterOff   = 0,              /* perfect filtering only                         0       */

	GmacUcastHashFilterOn    = 0x00000002,     /* Unicast Hash filtering only          RW                */
	GmacUcastHashFilterOff   = 0,              /* perfect filtering only                         0       */

	GmacPromiscuousModeOn    = 0x00000001,     /* Receive all valid packets            RW                */
	GmacPromiscuousModeOff   = 0,              /* Receive filtered packets only                  0       */
};

extern int gmac_eth_initialize(int quiet) ;
int gmac_mdio_init(struct dw_eqos_priv *priv);
#endif /* !_GMAC_H_ */
