#ifndef __VPL_VOC_H
#define __VPL_VOC_H

// use panel define
#define PANEL_NT39016
//#define PANEL_ILI9341V
//#define PANEL_ILI9342C
//#define PANEL_ST7789
//#define PANEL_ST7793
//#define PANEL_ST7789V
//#define PANEL_RM68172_4INCH
//#define PANEL_RM68172_5INCH

// constant define
#define SPLASH_STORAGE_NAND		0x01
#define SPLASH_STORAGE_SF		0x02


struct splash_location
{
	char *name;
	u32  storage;
	u32  offset;
};


struct vpl_voc_info
{
	u32 dwVersion; // MMR 0
	u32 dwCtrl; // MMR 1
	u32 dwStat; // MMR 2

	/* Video Buffer Address Registers */
	u32 dwYBuff0Addr; // MMR 3
	u32 dwCbBuff0Addr; // MMR 4
	u32 dwCrBuff0Addr; // MMR 5
	u32 dwYBuff1Addr; // MMR 6
	u32 dwCbBuff1Addr; // MMR 7
	u32 dwCrBuff1Addr; // MMR 8

	/* Video Signal Contrl Registers */
	u32 dwInSize; // MMR 9
	u32 dwOutSize; // MMR 10
	u32 dwOutSizeCtrl; // MMR 11
	u32 dwHSyncCtrl; // MMR 12
	u32 dwVSyncCtrl; // MMR 13

	/* Color Space convert Registers */
	u32 dwSBCCtrl; //MMR 14
	u32 dwYCbCr2RGBCoeff0; //MMR 15
	u32 dwYCbCr2RGBCoeff1; //MMR 16
	u32 dwYCbCr2RGBCoeff2; //MMR 17

	/* I80 interface Control Registers */
	u32 dwI80Ctrl; // MMR 18
	u32 dwI80Timing; // MMR 19
	u32 dwI80WTCONData; // MMR 20
	u32 dwI80RTCONReg; // MMR 21

	/* Index OSD Control Registers */
	u32 dwIndexOSDCtrl; // MMR 22
	u32 dwIndexOSDAddr; // MMR 23
	u32 dwIndexOSDSize; // MMR 24
	u32 dwIndexOSDAxis; // MMR 25
	u32 dwIndexOSDPalette; // MMR 26
	u32 dwIndexOSDReadPalette; // MMR 27

	/* Global Registers */
	u32 dwStrideSetting; // MMR 28

	/* PIP */
	u32 dwPIPCtrl; //MMR29
	u32 dwPIPYBuff0Addr; // MMR 30
	u32 dwPIPCbBuff0Addr; // MMR 31
	u32 dwPIPCrBuff0Addr; // MMR 32
	u32 dwPIPYBuff1Addr; // MMR 33
	u32 dwPIPCbBuff1Addr; // MMR 34
	u32 dwPIPCrBuff1Addr; // MMR 35
	u32 dwPIPSize; //MMR 36
	u32 dwPIPAxis; //MMR 37
};

#define BIT(x)          (1 << (x))
enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW     = BIT(0),
	DISPLAY_FLAGS_HSYNC_HIGH    = BIT(1),
	DISPLAY_FLAGS_VSYNC_LOW     = BIT(2),
	DISPLAY_FLAGS_VSYNC_HIGH    = BIT(3),

	/* data enable flag */
	DISPLAY_FLAGS_DE_LOW        = BIT(4),
	DISPLAY_FLAGS_DE_HIGH       = BIT(5),
	/* drive data on pos. edge */
	DISPLAY_FLAGS_PIXDATA_POSEDGE   = BIT(6),
	/* drive data on neg. edge */
	DISPLAY_FLAGS_PIXDATA_NEGEDGE   = BIT(7),
	DISPLAY_FLAGS_INTERLACED    = BIT(8),
	DISPLAY_FLAGS_DOUBLESCAN    = BIT(9),
};

enum vpl_voc_sync_polarity {
	VOC_SYNC_ACTIVE_LOW, /* Oops, the datasheed defined high/law is "data puls" not "sync puls" */
	VOC_SYNC_ACTIVE_HIGH,
};

enum vpl_voc_de_polarity {
	VOC_DE_ACTIVE_HIGH,
	VOC_DE_ACTIVE_LOW,
};

enum vpl_voc_signal_edge {
	POSITIVE_EDGE_ALIGNED = 0,
	NEGATIVE_EDGE_ALIGNED = 2,
};

struct videomode {
	unsigned long pixelclock;   /* pixelclock in Hz */

	u32 hactive;
	u32 hfront_porch;
	u32 hback_porch;
	u32 hsync_len;

	u32 vactive;
	u32 vfront_porch;
	u32 vback_porch;
	u32 vsync_len;

	enum vpl_voc_sync_polarity hsync_act_pol;
	enum vpl_voc_sync_polarity vsync_act_pol;
	enum vpl_voc_de_polarity de_act_pol;
	enum vpl_voc_signal_edge pclk_pol;
};

#endif /* __VPL_VOC_H */
