/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * do_irq()@lib_arm/interrupt.c :
 * #include <asm/io.h>
 * #include <asm/arch/platform.h>
 * 	int irq;
 *	do {
 *		readl(VPL_UARTC2_MMR_BASE + SERIAL_RBR);
 *	} while (readl(VPL_UARTC2_MMR_BASE + SERIAL_LSR) & 0x1);
 *
 *	irq = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_IRQ_NUM);
 *	printf("IRQ %d\n", irq);
 *	if (irq < 32)
 *		writel((1UL<<irq), VPL_INTC_MMR_BASE + IRQ_CLEAR_LO_REG);
 *	else
 *		writel((1UL<<(irq - 32)), VPL_INTC_MMR_BASE + IRQ_CLEAR_HI_REG);
 */

#include <common.h>
#include <exports.h>
#include <asm/io.h>
#include <asm/arch/platform.h>


#define PSR_F_BIT   "0x00000040"
int cpuclk(int argc, char *argv[])
{
	unsigned int reg, clksel, intc_mask_lo, intc_mask_hi, intc_trigger_lo, intc_trigger_hi;
	unsigned long start, l, loops=1000000;
	int _r0=0, _r1=0, _r2=0, _r3=0, _ip=0;

	/* Print the ABI version */
	app_startup(argv);
	printf ("Example expects ABI version %d\n", XF_VERSION);
	printf ("Actual U-Boot ABI version %d\n", (int)get_version());

	printf ("CPU clock switch standalone application\n");

	if (argc < 2)
	{
		printf("Usage:\n"
		       "\tgo c100000 <clksel> [<busy loops>]\n");
		goto end;
	}
#if 1
	int i;
	printf ("argc = %d\n", argc);
	for (i=0; i<argc; ++i) {
		printf ("argv[%d] = \"%s\"\n",
			i,
			argv[i] ? argv[i] : "<NULL>");
	}
#endif

	/*------------ start of program ------------------------*/
	reg = readl(VPL_SYSC_MMR_BASE);
	printf("SYSC version %d.%d.%d.%d\n", reg>>24, (reg>>16)&0xff, (reg>>8)&0xff, reg&0xff);

	clksel = (*argv[1]) - '0';
	printf("CPU clock selection: %u\n", clksel);
	if (argc >=3)
		loops = simple_strtoul(argv[2], NULL, 10);

	/* save INTC registers */
	intc_mask_lo = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	intc_mask_hi = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	intc_trigger_lo = readl(VPL_INTC_MMR_BASE + IRQ_MODE_LO_REG);
	intc_trigger_hi = readl(VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);
	/* mask and clean all interrupts */
	writel(0x00000000, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	writel(0x00000000, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_CLEAR_LO_REG);
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_CLEAR_HI_REG);
	/* setup default priorities */
	for (i=0; i <64; i++)
		writel(i, VPL_INTC_MMR_BASE + IRQ_INTR_PRI_START + i*4);

#ifdef WAKEUP_BY_GPIO
	/* GPIOC */
	writel(0xff, VPL_AGPOC_MMR_BASE + 0x10);
	writel(0xff, VPL_GPIOC_0_MMR_BASE + GPIOC_PIN_PULL_TYPE);
	writel(0xff, VPL_GPIOC_0_MMR_BASE + GPIOC_PIN_PULL_ENABLE);
	writel(0x0, VPL_GPIOC_0_MMR_BASE + GPIOC_PIN_DIR);
	writel(0x0, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_MASK);
	writel(0xff, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_CLEAR);
	/* falling edge trigger */
	writel(0x0, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_TRIGGER_TYPE);
	writel(0x0, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_BOTH);
	writel(0xff, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_DIR);
	writel(0xff, VPL_GPIOC_0_MMR_BASE + GPIOC_INTR_ENABLE);

	/* INTC */
	writel(0x40000000, VPL_INTC_MMR_BASE + EVM_INTC_TRIGGER_MODE_LO);
	writel(0x40000000, VPL_INTC_MMR_BASE + EVM_INTC_MASK_LO);
#elif defined(WAKEUP_BY_UART)
	/* UARTC */
	readl(VPL_UARTC2_MMR_BASE + SERIAL_LSR);
	writel(0x01, VPL_UARTC2_MMR_BASE + SERIAL_IER);
	/* INTC */
	writel((0UL<<(UARTC2_IRQ_NUM - 32)), VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);
	reg = (1UL<<(UARTC2_IRQ_NUM - 32)) | intc_mask_hi;
	writel(reg, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	readl(VPL_UARTC2_MMR_BASE + SERIAL_LSR);
#else /* wakeup by sysc interrupt */
	/* INTC */
	printf("wake up by sysc\n");
	writel((1UL<<(SYSC_IRQ_NUM - 32)), VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);
	reg = (1UL<<(SYSC_IRQ_NUM - 32)) | intc_mask_hi;
	writel(reg, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
#endif

	start = get_timer(0);
	l = loops;
	writel(0x00010000, VPL_SYSC_MMR_BASE + 0x18);
	do { } while (readl(VPL_SYSC_MMR_BASE + 0x1c));
	writel(0x00000000, VPL_SYSC_MMR_BASE + 0x18);
	do {
		asm volatile("nop");
	} while (l--);
	printf("time %lu\n", get_timer(start));
	printf("sysc timer (%#08x, %#08x)\n", readl(VPL_SYSC_MMR_BASE + 0x20), readl(VPL_SYSC_MMR_BASE + 0x1c));


	printf("\nDo Idle!\n");

	reg = readl(VPL_SYSC_MMR_BASE + 0x2c);
	reg &= ~(0x70UL);
	reg |= (clksel<<4) | 0x1;
	writel(reg, VPL_SYSC_MMR_BASE + 0x2c);

	/* cpu_arm926_do_idle */
	asm volatile (
		"mov	%[R0], #0\n"
		"mrc	p15, 0, %[R1], c1, c0, 0           @ Read control register\n"
		"mcr	p15, 0, %[R0], c7, c10, 4          @ Drain write buffer\n"
		"bic	%[R2], %[R1], #1 << 12\n"
		"mrs	%[R3], cpsr                        @ Disable FIQs while Icache\n"
		"orr	%[IP], %[R3], #"PSR_F_BIT"         @ is disabled\n"
		"msr	cpsr_c, %[IP]\n"
		"mcr	p15, 0, %[R2], c1, c0, 0           @ Disable I cache\n"
		"mcr	p15, 0, %[R0], c7, c0, 4           @ Wait for interrupt\n"
		"mcr	p15, 0, %[R1], c1, c0, 0           @ Restore ICache enable\n"
		"msr	cpsr_c, %[R3]                      @ Restore FIQ state\n"
		:[R0]"+r"(_r0), [R1]"+r"(_r1), [R2]"+r"(_r2), [R3]"+r"(_r3), [IP]"+r"(_ip)
		:
	);

	printf("\nWelcome back (sysc + 0x2c: %#08x)\n", readl(VPL_SYSC_MMR_BASE + 0x2c));

#ifdef WAKEUP_BY_UART
	/* UARTC */
	//writel(0x00, VPL_UARTC1_MMR_BASE + SERIAL_IER);
	writel(0x00, VPL_UARTC2_MMR_BASE + SERIAL_IER);
#endif

	/* restore INTC registers */
	writel(intc_mask_lo, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	writel(intc_mask_hi, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	writel(intc_trigger_lo, VPL_INTC_MMR_BASE + IRQ_MODE_LO_REG);
	writel(intc_trigger_hi, VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);


	/* */
	l = loops;
	start = get_timer(0);
	writel(0x00010000, VPL_SYSC_MMR_BASE + 0x18);
	do { } while (readl(VPL_SYSC_MMR_BASE + 0x1c));
	writel(0x00000000, VPL_SYSC_MMR_BASE + 0x18);
	do {
		asm volatile("nop");
	} while (l--);
	printf("time %lu\n", get_timer(start));
	printf("sysc timer (%#08x, %#08x)\n", readl(VPL_SYSC_MMR_BASE + 0x20), readl(VPL_SYSC_MMR_BASE + 0x1c));

	/*------------ end of program --------------------------*/

end:
	printf ("Hit any key to exit ... ");
	while (!tstc())
		;
	/* consume input */
	(void) getc();

	printf ("\n\n");
	return (0);
}

