/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * lib_arm/interrupt.c should be patched as following:
 *
 * #include <asm/io.h>
 * #include <asm/arch/platform.h>
 *
 * do_irq():
 *	int irq = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_IRQ_NUM);
 *	printf("IRQ %d\n", irq);
 *	if (irq < 32)
 *		writel((1UL<<irq), VPL_INTC_MMR_BASE + IRQ_CLEAR_LO_REG);
 *	else
 *		writel((1UL<<(irq - 32)), VPL_INTC_MMR_BASE + IRQ_CLEAR_HI_REG);
 */

#include <common.h>
#include <exports.h>
#include <asm/io.h>
#include <asm/proc/system.h>
#include <asm/arch/platform.h>


#define PSR_F_BIT   "0x00000040"
#define WAKEUP_BY_UART
int intc(int argc, char *argv[])
{
	int i;
	unsigned int intc_mask_lo, intc_mask_hi, intc_trigger_lo, intc_trigger_hi, reg;
	register unsigned int   intc_mask_lo_r __asm__("r3"), intc_mask_hi_r __asm__("r4");

	/* Print the ABI version */
	app_startup(argv);
	printf ("Example expects ABI version %d\n", XF_VERSION);
	printf ("Actual U-Boot ABI version %d\n", (int)get_version());

	printf ("Interrupt priority standalone application\n");

	if (argc < 2)
	{
		printf("Usage:\n"
		       "\tgo c100000 <irq> [<irq> ...]\n"
		       "\tgo c100000 <irq> [<irq> ...] -- [<irq,pri> ...]\n");
		goto end;
	}
#if 0
	printf ("argc = %d\n", argc);
	for (i=0; i<argc; ++i) {
		printf ("argv[%d] = \"%s\"\n",
			i,
			argv[i] ? argv[i] : "<NULL>");
	}
#endif

	/*------------ start of program ------------------------*/
	reg = readl(VPL_INTC_MMR_BASE);
	printf("INTC version %d.%d.%d.%d\n", reg>>24, (reg>>16)&0xff, (reg>>8)&0xff, reg&0xff);

	local_irq_disable();

	/* save INTC mask/mode registers */
	intc_mask_lo = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	intc_mask_hi = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	intc_trigger_lo = readl(VPL_INTC_MMR_BASE + IRQ_MODE_LO_REG);
	intc_trigger_hi = readl(VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);
	/* mask and clean all interrupts */
	writel(0x00000000, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	writel(0x00000000, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_CLEAR_LO_REG);
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_CLEAR_HI_REG);
	/* setup default priorities */
	for (i=0; i <64; i++)
		writel(i, VPL_INTC_MMR_BASE + IRQ_INTR_PRI_START + i*4);

	printf("Enable irqs: ");
	for (i=1; i < argc && *argv[i] >= '0' && *argv[i] <= '9'; i++)
	{
		int irq;
		irq = simple_strtoul(argv[i], NULL, 10);
		printf("%d ", irq);
		if (irq < 32)
			writel(readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG) | (1UL << irq),
				VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
		else
			writel(readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG) | (1UL << (irq - 32)),
				VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	}
	printf("\n");
	printf("\tIRQ_HOST_0_MASK_LO_REG: 0x%08x\n", readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG));
	printf("\tIRQ_HOST_0_MASK_HI_REG: 0x%08x\n", readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG));

	printf("Set irq priorities:\n\t");
	for (i++; i < argc && *argv[i] >= '0' && *argv[i] <= '9'; i++)
	{
		int irq, pri;
		char *p;
		for (p=argv[i]; *p != ','; p++);
		*p = 0;
		irq = simple_strtoul(argv[i], NULL, 10);
		pri = simple_strtoul(++p, NULL, 10);
		printf("IRQ%d=%d ", irq, pri);
		writel(irq, VPL_INTC_MMR_BASE + IRQ_INTR_PRI_START + pri*4);
	}
	printf("\n[pri]=irq\n");
	for (i=0; i<64;)
	{
		int j;
		for (j=0; j<10 && i<64; j++, i++)
			printf("[%2d]=%2d ", i, readl(VPL_INTC_MMR_BASE + IRQ_INTR_PRI_START + i*4));
		printf("\n");
	}

	printf("\nSoftware trigger...\n");
	/* edge trigger */
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_MODE_LO_REG);
	writel(0xffffffff, VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);
	/* software triggered interrupts */
	intc_mask_lo_r = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	intc_mask_hi_r = readl(VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	asm volatile (
		"stmia	%[reg], {%[lo], %[hi]}"
		::[reg]"r"(VPL_INTC_MMR_BASE + IRQ_SET_LO_REG),
	          [lo]"r"(intc_mask_lo_r),
		  [hi]"r"(intc_mask_hi_r)
	);

	local_irq_enable();

	/* restore INTC registers */
	writel(intc_mask_lo, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_LO_REG);
	writel(intc_mask_hi, VPL_INTC_MMR_BASE + IRQ_HOST_0_MASK_HI_REG);
	writel(intc_trigger_lo, VPL_INTC_MMR_BASE + IRQ_MODE_LO_REG);
	writel(intc_trigger_hi, VPL_INTC_MMR_BASE + IRQ_MODE_HI_REG);



	/*------------ end of program --------------------------*/

end:
	printf ("Hit any key to exit ... ");
	while (!tstc())
		;
	/* consume input */
	(void) getc();

	printf ("\n\n");
	return (0);
}

