#ifndef __VPL_SYSCTRL_H__
#define __VPL_SYSCTRL_H__

extern int (*env_init)(void) ;
extern int (*saveenv)(void) ;
extern unsigned char (*env_get_char_spec)(int index) ;
extern void (*env_relocate_spec)(void) ;

#define EVM_VDAC_BASE				VPL_VDAC_MMR_BASE
#define VDAC_BG_CTRL  				0x04
#define VDAC_LDO_CTRL 				0x08

#define EVM_PLLC_BASE				VPL_PLLC_MMR_BASE
#define PLL4_MMR_CTRL				0x24
#define PLL4_MMR_DIV				0x28

#define EVM_SYSC_BASE				VPL_SYSC_MMR_BASE

#define SYSC_MMR_CHIP_VER			0x14
#define SYSC_CHIP_VERSION			(EVM_SYSC_BASE + SYSC_MMR_CHIP_VER)
#define SYSC_MMR_NFC_CTRL  	 		0x6c
#define SYSC_MMR_VOC_CTRL    		0x88
#define SYSC_MMR_MON_CLK_SEL		0x90
#define SYSC_MMR_CLKEN_CTRL0		0x94
#define SYSC_MMR_CLKEN_CTRL1		0x98
#define EVM_SYSC_PAD_EN_CTRL		0xB0
#define SYSCTRL_PROT_INFO			(EVM_SYSC_BASE + 0xC0)

#define SYSCTRL_DATA_IN_SERIALFLASH	0x0
#define SYSCTRL_DATA_IN_SD			0x1
#define SYSCTRL_DATA_IN_NANDFLASH	0x2
#define SYSCTRL_DATA_IN_SPINAND		0x3
#define SYSCTRL_DATA_IN_UART		0x4

#define SYSC_PAD_CTRL0_DCE			0x200

#endif
