#ifndef _ARCH_USB_H_
#define _ARCH_USB_H_

#include <config.h>

#ifdef CONFIG_EVB_V3
#define SPNSID		0x4f54294a /* 2.94a */
#else
#define SPNSID		0x4f54266a /* 2.66a */
#endif


/* Controller Core Global CSR */
#define GOTGCTL                     (0x0000)
#define GOTGINT                     (0x0004)
#define GAHBCFG                     (0x0008)
#define     DMAEn_SHIFT                 ( 5)
#define     HBstLen_SHIFT               ( 1)
#define     GlbIntrMsk_SHIFT            ( 0)
#define     DMAEn(x)                    ((x) << DMAEn_SHIFT)
#define     HBstLen(x)                  ((x) << HBstLen_SHIFT)
#define     GlbIntrMsk(x)               ((x) << GlbIntrMsk_SHIFT)
#define     DMAEn_MASK                  DMAEn(1)
#define     HBstLen_MASK                HBstLen(0xF)
#define     GlbIntrMsk_MASK             GlbIntrMsk(1)
#define GUSBCFG                     (0x000C)
#define     USBTrdTim_SHIFT             (10)
#define     HNPCap_SHIFT                ( 9)
#define     SRPCap_SHIFT                ( 8)
#define     ULPI_UTMI_Sel_SHIFT         ( 4)
#define     PHYIf_SHIFT                 ( 3)
#define     TOutCal_SHIFT               ( 0)
#define     USBTrdTim(x)                ((x) << USBTrdTim_SHIFT)
#define     HNPCap(x)                   ((x) << HNPCap_SHIFT)
#define     SRPCap(x)                   ((x) << SRPCap_SHIFT)
#define     ULPI_UTMI_Sel(x)            ((x) << ULPI_UTMI_Sel_SHIFT)
#define     PHYIf(x)                    ((x) << PHYIf_SHIFT)
#define     TOutCal(x)                  ((x) << TOutCal_SHIFT)
#define     USBTrdTim_MASK              USBTrdTim(0xF)
#define     HNPCap_MASK                 HNPCap(1)
#define     SRPCap_MASK                 SRPCap(1)
#define     ULPI_UTMI_Sel_MASK          ULPI_UTMI_Sel(1)
#define     PHYIf_MASK                  PHYIf(1)
#define     TOutCal_MASK                TOutCal(1)
#define GRSTCTL                     (0x0010)
#define     TxFNum_SHIFT                ( 6)
#define     TxFFlsh_SHIFT               ( 5)
#define     RxFFlsh_SHIFT               ( 4)
#define     CSftRst_SHIFT               ( 0)
#define     TxFNum(x)                   ((x) << TxFNum_SHIFT)
#define     TxFFlsh(x)                  ((x) << TxFFlsh_SHIFT)
#define     RxFFlsh(x)                  ((x) << RxFFlsh_SHIFT)
#define     CSftRst(x)                  ((x) << CSftRst_SHIFT)
#define     TxFNum_MASK                 TxFNum(0x1F)
#define     TxFFlsh_MASK                TxFFlsh(1)
#define     RxFFlsh_MASK                RxFFlsh(1)
#define     CSftRst_MASK                CSftRst(1)
#define GINTSTS                     (0x0014)
#define     WkUpInt_SHIFT               (31)
#define     SessReqInt_SHIFT            (30)
#define     DisconnInt_SHIFT            (29)
#define     ConIDStsChng_SHIFT          (28)
#define     HChInt_SHIFT                (25)
#define     PrtInt_SHIFT                (24)
#define     USBSusp_SHIFT               (11)
#define     Sof_SHIFT                   ( 3)
#define     OTGInt_SHIFT                ( 2)
#define     ModeMis_SHIFT               ( 1)
#define     WkUpInt(x)                  ((x) << WkUpInt_SHIFT)
#define     SessReqInt(x)               ((x) << SessReqInt_SHIFT)
#define     DisconnInt(x)               ((x) << DisconnInt_SHIFT)
#define     ConIDStsChng(x)             ((x) << ConIDStsChng_SHIFT)
#define     HChInt(x)                   ((x) << HChInt_SHIFT)
#define     PrtInt(x)                   ((x) << PrtInt_SHIFT)
#define     USBSusp(x)                  ((x) << USBSusp_SHIFT)
#define     Sof(x)                      ((x) << Sof_SHIFT)
#define     OTGInt(x)                   ((x) << OTGInt_SHIFT)
#define     ModeMis(x)                  ((x) << ModeMis_SHIFT)
#define     WkUpInt_MASK                WkUpInt(1)
#define     SessReqInt_MASK             SessReqInt(1)
#define     DisconnInt_MASK             DisconnInt(1)
#define     ConIDStsChng_MASK           ConIDStsChng(1)
#define     HChInt_MASK                 HChInt(1)
#define     PrtInt_MASK                 PrtInt(1)
#define     USBSusp_MASK                USBSusp(1)
#define     Sof_MASK                    Sof(1)
#define     OTGInt_MASK                 OTGInt(1)
#define     ModeMis_MASK                ModeMis(1)
#define GINTMSK                     (0x0018)
#define GRXFSIZ                     (0x0024)
#define GNPTXFSIZ                   (0x0028)
#define GSNPSID                     (0x0040)
#define HPTXFSIZ                    (0x0100)
/* Controller Host Mode CSR */
#define HCFG                        (0x0400)
#define HAINTMSK                    (0x0418)
#define HPRT                        (0x0440)
#define     PrtSpd_SHIFT                (17)
#define     PrtPwr_SHIFT                (12)
#define     PrtLnSts_SHIFT              (10)
#define     PrtRst_SHIFT                ( 8)
#define     PrtEnChng_SHIFT             ( 3)
#define     PrtEna_SHIFT                ( 2)
#define     PrtConnDet_SHIFT            ( 1)
#define     PrtConnSts_SHIFT            ( 0)
#define     PrtSpd(x)                   ((x) << PrtSpd_SHIFT)
#define     PrtPwr(x)                   ((x) << PrtPwr_SHIFT)
#define     PrtLnSts(x)                 ((x) << PrtLnSts_SHIFT)
#define     PrtRst(x)                   ((x) << PrtRst_SHIFT)
#define     PrtEnChng(x)                ((x) << PrtEnChng_SHIFT)
#define     PrtEna(x)                   ((x) << PrtEna_SHIFT)
#define     PrtConnDet(x)               ((x) << PrtConnDet_SHIFT)
#define     PrtConnSts(x)               ((x) << PrtConnSts_SHIFT)
#define     PrtSpd_MASK                 PrtSpd(0x3)
#define     PrtPwr_MASK                 PrtPwr(1)
#define     PrtLnSts_MASK               PrtLnSts(1)
#define     PrtRst_MASK                 PrtRst(1)
#define     PrtEnChng_MASK              PrtEnChng(1)
#define     PrtEna_MASK                 PrtEna(1)
#define     PrtConnDet_MASK             PrtConnDet(1)
#define     PrtConnSts_MASK             PrtConnSts(1)
#define HCCHARn(n)                  (0x500 + (n)*0x20)
#define     ChEna_SHIFT                 (31)
#define     ChDis_SHIFT                 (30)
#define     DevAddr_SHIFT               (22)
#define     McEc_SHIFT                  (20)
#define     EPType_SHIFT                (18)
#define     EPDir_SHIFT                 (15)
#define     EPNum_SHIFT                 (11)
#define     MPS_SHIFT                   ( 0)
#define     ChEna(x)                    ((x) << ChEna_SHIFT)
#define     ChDis(x)                    ((x) << ChDis_SHIFT)
#define     DevAddr(x)                  ((x) << DevAddr_SHIFT)
#define     McEc(x)                     ((x) << McEc_SHIFT)
#define     EPType(x)                   ((x) << EPType_SHIFT)
#define     EPDir(x)                    ((x) << EPDir_SHIFT)
#define     EPNum(x)                    ((x) << EPNum_SHIFT)
#define     MPS(x)                      ((x) << MPS_SHIFT)
#define     ChEna_MASK                  ChEna(1)
#define     ChDis_MASK                  ChDis(1)
#define     DevAddr_MASK                DevAddr(0x3F)
#define     McEc_MASK                   McEc(0x3)
#define     EPType_MASK                 EPType(0x3)
#define     EPDir_MASK                  EPDir(1)
#define     EPNum_MASK                  EPNum(0xF)
#define     MPS_MASK                    MPS(0x3FF)
#define HCSPLTn(n)                  (0x504 + (n)*0x20)
#define HCINTn(n)                   (0x508 + (n)*0x20)
#define     XactErr_SHIFT               ( 7)
#define     NYET_SHIFT                  ( 6)
#define     ACK_SHIFT                   ( 5)
#define     NAK_SHIFT                   ( 4)
#define     STALL_SHIFT                 ( 3)
#define     AHBErr_SHIFT                ( 2)
#define     ChHltd_SHIFT                ( 1)
#define     XferCompl_SHIFT             ( 0)
#define     XactErr(x)                  ((x) << XactErr_SHIFT)
#define     NYET(x)                     ((x) << NYET_SHIFT)
#define     ACK(x)                      ((x) << ACK_SHIFT)
#define     NAK(x)                      ((x) << NAK_SHIFT)
#define     STALL(x)                    ((x) << STALL_SHIFT)
#define     AHBErr(x)                   ((x) << AHBErr_SHIFT)
#define     ChHltd(x)                   ((x) << ChHltd_SHIFT)
#define     XferCompl(x)                ((x) << XferCompl_SHIFT)
#define     XactErr_MASK                XactErr(1)
#define     NYET_MASK                   NYET(1)
#define     ACK_MASK                    ACK(1)
#define     NAK_MASK                    NAK(1)
#define     STALL_MASK                  STALL(1)
#define     AHBErr_MASK                 AHBErr(1)
#define     ChHltd_MASK                 ChHltd(1)
#define     XferCompl_MASK              XferCompl(1)
#define HCINTMSKn(n)                (0x50C + (n)*0x20)
#define HCTSIZn(n)                  (0x510 + (n)*0x20)
#define     PID_SHIFT                   (29)
#define     PktCnt_SHIFT                (19)
#define     XferSize_SHIFT              ( 0)
#define     PID(x)                      ((x) << PID_SHIFT)
#define     PktCnt(x)                   ((x) << PktCnt_SHIFT)
#define     XferSize(x)                 ((x) << XferSize_SHIFT)
#define     PID_MASK                    PID(0x3)
#define     PktCnt_MASK                 PktCnt(0x3FF)
#define     XferSize_MASK               XferSize(0x7FFFF)
#define HCDMAn(n)                   (0x514 + (n)*0x20)
#if CONFIG_EVB_V3 == 1
#define HCDMABn(n)                  (0x51C + (n)*0x20)
#endif
/* Controller Power and Clock Gating CSR */
#define PCGCR                       (0x0E00)

/* PHY */
#define USBC_CTRL                   (0x0004)
#if CONFIG_EVB_V3 == 1
#define     REFCLK_SEL_SHIFT            (30)
#define     REFCLK_DIV_SHIFT            (29)
#endif
#define     PHY_RST_N_SHIFT             (28)
#define     CORE_RST_N_SHFIT            (27)
#define     CORE_RST_RELEASE_SHIFT      (26)
#define     OTG_MODE_SHIFT              (25)
#define     PHY_RST_RELEASE_SHIFT       (24)
#define     TXVREFTUNE_SHIFT            (15)
#define     TXRISETUNE_SHIFT            (14)
#define     TXPREEMPHASISTUNE_SHIFT     (13)
#define     TXFSLSTUNE_SHIFT            ( 9)
#define     SQRXTUNE_SHIFT              ( 6)
#if CONFIG_EVB_V3 == 1
#define     REFCLK_SEL(x)               ((x) << REFCLK_SEL_SHIFT)
#define     REFCLK_DIV(x)               ((x) << REFCLK_DIV_SHIFT)
#endif
#define     PHY_RST_N(x)                ((x) << PHY_RST_N_SHIFT)
#define     CORE_RST_N(x)               ((x) << CORE_RST_N_SHFIT)
#define     CORE_RST_RELEASE(x)         ((x) << CORE_RST_RELEASE_SHIFT)
#define     OTG_MODE(x)                 ((x) << OTG_MODE_SHIFT)
#define     PHY_RST_RELEASE(x)          ((x) << PHY_RST_RELEASE_SHIFT)
#define     TXVREFTUNE(x)               ((x) << TXVREFTUNE_SHIFT)
#define     TXRISETUNE(x)               ((x) << TXRISETUNE_SHIFT)
#define     TXPREEMPHASISTUNE(x)        ((x) << TXPREEMPHASISTUNE_SHIFT)
#define     TXFSLSTUNE(x)               ((x) << TXFSLSTUNE_SHIFT)
#define     SQRXTUNE(x)                 ((x) << SQRXTUNE_SHIFT)
#if CONFIG_EVB_V3 == 1
#define     REFCLK_SEL_MASK             REFCLK_SEL(0x3)
#define     REFCLK_DIV_MASK             REFCLK_DIV(1)
#endif
#define     PHY_RST_N_MASK              PHY_RST_N(1)
#define     CORE_RST_N_MASK             CORE_RST_N(1)
#define     CORE_RST_RELEASE_MASK       CORE_RST_RELEASE(1)
#define     OTG_MODE_MASK               OTG_MODE(1)
#define     PHY_RST_RELEASE_MASK        PHY_RST_RELEASE(1)
#define     TXVREFTUNE_MASK             TXVREFTUNE(0xF)
#define     TXRISETUNE_MASK             TXRISETUNE(1)
#define     TXPREEMPHASISTUNE_MASK      TXPREEMPHASISTUNE(1)
#define     TXFSLSTUNE_MASK             TXFSLSTUNE(0xF)
#define     SQRXTUNE_MASK               SQRXTUNE(0x7)
#define USBC_PWR_ON_CYCLE   (0x08)
#define USBC_COUNTER        (0x0C)


#endif /* !_ARCH_USB_H_ */
