#ifndef _OTUS_COMMON_H
#define _OTUS_COMMON_H

//----------------------------------------------------------------------------------------------
#define KENXEN

#ifdef KENXEN
    #define KENXEN_SDV360T2         0
    #define KENXEN_SDV360T3         1
	#define KENXEN_SDV360T4         0
    #define KENXEN_SDV360T5         0
    #define KENXEN_C360T1           0
    #define KENXEN_RF200T           0
	#define KENXEN_SDV360T8         0
    #define KENXEN_LN100P           0

#if (KENXEN_SDV360T3 == 1)
    #define LIVE360           		0
#endif

#if (KENXEN_SDV360T5 == 1)
    #define FUJITSU_NX600           0
#endif

#if (KENXEN_SDV360T8 == 1)
	#define KEZHAN_PLR_DV10			0	// Change SSID
#endif
//#define QINIU_TEST
//#define OLD_SET_RTMP_STREAM_ID2

#define SGC_ENABLE         			0

#endif
//-------------------------------------------------------------------------
#if (defined KENXEN) && ((KENXEN_SDV360T4 == 1) || (KENXEN_C360T1 == 1))
	#define OLED_UI
#endif
//----------------------------------------------------------------------------------------------
#if (defined KENXEN) && (KENXEN_LN100P == 1)
    #define LUNA_SOUND
#endif
//----------------------------------------------------------------------------------------------
#if 0
	#define MSG		printf
#else
	#define MSG(...)
#endif
//----------------------------------------------------------------------------------------------
#define OLD_USB_SUPPORT          0    // OLD_USB_SUPPORT = 1, usb_mode only 0,3,4,5 ; OLD_USB_SUPPORT = 0, usb_mode only 0,1,2
//----------------------------------------------------------------------------------------------
#define MAX_SENSOR_COUNT         2
//----------------------------------------------------------------------------------------------
#define system_setting		     "/etc/system_setting.ini"
#define default_system_setting   "/etc/default_system/system_setting.ini"
#define rootfs_file              "rootfs.sqfs"
#define socket_pro_ver           "1.0"
#define rtmp_config				 "/etc/conf.d/rtmp/rtmp_server_config.ini"
//----------------------------------------------------------------------------------------------
#define DEFAULT_360_LSC_CURCE_FILE   "/etc/calibrate/ISA_Device/curveparam.dat"
//----------------------------------------------------------------------------------------------
#define BUTTON_COMMAND_FIFO 	 "/tmp/fifo/button.fifo"
#define TINYVENC_FIFO			 "/tmp/venc/c0/command.fifo"
#define CAPTURE_FIFO 	         "/tmp/capture/command.fifo"
//----------------------------------------------------------------------------------------------
#define VREC_FIFO               "/tmp/fifo/vrec.fifo"
#define VREC_HOST_NAME			"vrec"
#define CMD_FORCE_SAVE          "forceSave"
#define CMD_START               "start"
#define CMD_STOP                "stop"
#define CMD_CYCLIC_STORAGE      "cyclic_storage"
#define CMD_AUDIO_MUTE          "audio_mute"
#define CMD_EXECPTION_MODE      "execption_mode"
#define CMD_EVENT               "event"
#define CMD_MOTION              "motion"
#define CMD_TIME_LAPSE          "time_lapse"
#define CMD_SNAPSHOT            "snapshot"
#define CMD_CONTAINER           "container"
#define CMD_FORCE_CI            "forceCI"         // Need Conf 
#define CMD_GET_STREAM_HDR		"getStreamHdr"
#define CMD_FORCE_INTRA         "forceIntra"      // Need Intra
#define CMD_SET_ENCODER_CONF    "setEncorderConf"
#define CMD_SETUP_TIMELAPSE     "setupTimeLapse"
#define CMD_SETUP_ROI           "setupROI"
#define CMD_SETUP_TIMESTAMP     "setupTimeStamp"
#define CMD_SETUP_DUMMY_FRAME	"setupDummyFrame"
#define CMD_SETUP_PARAMETER		"setupParameter"
//----------------------------------------------------------------------------------------------
#define CAPTURE_HOST_NAME       "capture"
//----------------------------------------------------------------------------------------------
#define CAPTURE_FEC360_DATA      "/usr/share/PhotoFEC360.dat"
#define CAPTURE_VR360_DATA       "/usr/share/PhotoVR360.dat"
//----------------------------------------------------------------------------------------------
#define FONT_PATH 				 "/usr/share/fonts/DejaVuSans-Bold.ttf"
#define UI_IMAGE_DATA		     "/usr/share/ImageData.dat"
#define UI_TV_IMAGE_DATA         "/usr/share/ImageData_TV.dat"
#define UI_HDMI_IMAGE_DATA       "/usr/share/ImageData_HDMI.dat"
//----------------------------------------------------------------------------------------------
#define PLAYBACK_WAV_FIFO        "/tmp/fifo/playback_wav.fifo"
#define PLAYBACK_WAV_HOST_NAME   "playback wav"
#define PLAYBACK_WAV_CMD_SET	 "Playback_cmd"
#define PLAYBACK_WAV_DEV_SET	 "Playback_dev"
#define WAVE_FOLDER_PATH 		 "/usr/share/sounds/"
#define KEY_TONE				 "BEEP.wav"
#define KEY_TONE_2T				 "BEEP2"
#define KEY_TONE_3T				 "BEEP3"

#ifdef LUNA_SOUND
#define VOICE_SNAPSHOT           "LunaSnap.wav"
#define VOICE_POWER_ON           "LunaSysOn.wav"
#define VOICE_POWER_OFF          "LunaSysOff.wav"
#define VOICE_START_RECORD       "LunaRecOn.wav"
#define VOICE_STOP_RECORD        "LunaRecOff.wav"
#else
#define VOICE_SNAPSHOT           "snapshot.wav"
#endif

#define VOICE_WIFI_ON			 "CARCAM_01.wav"
#define VOICE_WIFI_OFF			 "CARCAM_02.wav"
#define VOICE_SYSTEM_SETUP		 "CARCAM_03.wav"
#define VOICE_INSERT_SDCARD		 "CARCAM_04.wav"
#define VOICE_AUDIO_ON			 "CARCAM_05.wav"
#define VOICE_AUDIO_OFF			 "CARCAM_06.wav"
#define VOICE_VOICE_ON			 "CARCAM_03.wav"
#define VOICE_VOICE_OFF			 "CARCAM_04.wav"
#define VOICE_TIME_SYNC_OK		 "CARCAM_22.wav"
#define VOICE_SDCARD_FAIL		 "CARCAM_23.wav"
#define VOICE_RECORD_FAIL		 "CARCAM_24.wav"
#define VOICE_CHECK_SDCARD		 "CARCAM_25.wav"
#define VOICE_SDCARD_FORMAT_OK   "CARCAM_34.wav"
#define VOICE_GPS_RECORD_ON		 "CARCAM_35.wav"
#define VOICE_GPS_RECORD_OFF	 "CARCAM_36.wav"
#define VOICE_RECORD_OFF		 "CARCAM_38.wav"
#define VOICE_RECORD_ON			 "CARCAM_40.wav"
#define VOICE_LED_ON			 "CARCAM_41.wav"
#define VOICE_LED_OFF			 "CARCAM_42.wav"
//----------------------------------------------------------------------------------------------
#define CHECKER_FIFO                "/tmp/fifo/checker.fifo"
#define CHECKER_HOST_NAME           "checker"
#define CMD_CHECK_FOLDER            "checkfolder"
#define CMD_SET_CHECK_CARD_ENABLE   "ck_sd_enable"         // check sd enable
#define CMD_SET_CHECK_FOLDER_ENABLE "ck_fd_enable"         // check fd enable
//----------------------------------------------------------------------------------------------
#define GSENSOR_FIFO                "/tmp/fifo/Gsensor.fifo"
#define GSENSOR_HOST_NAME           "Gsensor"
#define CMD_SET_TAP_LEVLEL          "set tap level"
//----------------------------------------------------------------------------------------------
#define GPS_FIFO                    "/tmp/fifo/gps.fifo"
//----------------------------------------------------------------------------------------------
#define LED_FIFO                    "/tmp/fifo/led_service.fifo"
#define HOST_LED                    "led"
#define CMD_LED_SET                 "led_set"

#define CMD_LED_RECORD              "led_record"
#define CMD_LED_NO_SDCARD           "led_no_sdcard"
#define CMD_SWITCH_RECORD_MODE      "led_sw_record"
#define CMD_SWITCH_SNAPSHOT_MODE    "led_sw_snapshot"
#define CMD_WIFI_TWINKLE_FAST       "wifi_fast"
#define CMD_WIFI_TWINKLE_FAST_250MS "wifi_fast_250ms"
#define CMD_WIFI_TWINKLE            "wifi_twinkle"
#define CMD_WIFI_TWINKLE_FAST_2_TIMES    "wifi_fast_2"

#if (defined KENXEN) && (KENXEN_SDV360T3 == 1)
#define CMD_WIFI_BLUE_TWINKLE_FAST  		"wifiB_fast"
#define CMD_WIFI_BLUE_TWINKLE_FAST_250MS 	"wifiB_fast_250"
#define CMD_WIFI_BLUE_TWINKLE       		"wifiB_twinkle"
#define CMD_LED_WIFI_BLUE					"wifiB"

#define CMD_WIFI_RED_TWINKLE_FAST   		"wifiR_fast"
#define CMD_WIFI_RED_TWINKLE_FAST_250MS 	"wifiR_fast_250"
#define CMD_WIFI_RED_TWINKLE        		"wifiR_twinkle"
#define CMD_LED_WIFI_RED					"wifiR"

#define CMD_LED_WIFI                "wifi"
#define CMD_LED_BATTERY_LOW_TWINKLE "battery_low"
#define CMD_LED_BATTERY_CHARGING	"charging"
#define CMD_LED_CAPTURE             "led_capture"
#define CMD_LED_POWER_OFF           "power_off"
#define CMD_LED_WIFI_RESET          "wifi_reset"
#else

#define CMD_LED_WIFI                "wifi"
#define CMD_LED_BATTERY_LOW         "battery_low"
#define CMD_LED_CAPTURE             "led_capture"
#define CMD_LED_POWER_OFF           "power_off"
#define CMD_LED_WIFI_RESET          "wifi_reset"

#endif

#if (defined KENXEN) && ((KENXEN_SDV360T3 == 1) || (KENXEN_SDV360T5 == 1))
#define LED_POWER                   59
#elif (defined KENXEN) && (KENXEN_SDV360T4 == 1)
#define LED_POWER                   43
#else
#define LED_POWER                   0xFF
#endif

#if (defined KENXEN) && (KENXEN_SDV360T4 == 1)
#define LED_VREC                    46
#define LED_WIFI                    0XFF
#define LED_MIC                     0xFF
#define LED_PHOTO                   0XFF
#elif (defined KENXEN) && (KENXEN_SDV360T3 == 1)
#define LED_VREC                    61
#define LED_WIFI                    0xFF
#define LED_WIFI_RED                57
#define LED_WIFI_BLUE               60
#define LED_MIC                     0xFF
#define LED_PHOTO                   63
#else
#define LED_VREC                    61
#define LED_WIFI                    60
#define LED_MIC                     0xFF
#define LED_PHOTO                   56
#endif
//----------------------------------------------------------------------------------------------
#define USB_VBUS_DETECT				0xFF
//----------------------------------------------------------------------------------------------
#define TV_OUT_DETECT				0xFF
//----------------------------------------------------------------------------------------------
#define SERVER_SOCKET_FIFO                  "/tmp/fifo/server_socket.fifo"
#define SERVER_SOCKET_HOST_NAME		        "server_socket"
#define CMD_NOTIFY_SDCARD_STATUS            "nt_sd_status"
#define CMD_NOTIFY_MOTION_STATUS            "nt_motion_stts"
#define CMD_NOTIFY_EVENT_STATUS             "nt_event_status"
#define CMD_NOTIFY_SELFTIMER_COUNT          "nt_selftimer_ct"
#define CMD_NOTIFY_BURST_COUNT		        "nt_burst_ct"
#define CMD_NOTIFY_R_REVERSE		        "nt_r_reverse"
#define CMD_NOTIFY_RELOAD_RECORD_STATUS     "nt_relo_record"
#define CMD_NOTIFY_RECORD_FAIL              "nt_record_fail"
#define CMD_NOTIFY_WIFI_WILL_DISABLE        "nt_wifi_disable"
#define CMD_NOTIFY_BATTERY_INFO             "nt_battery_info"
//----------------------------------------------------------------------------------------------
#define VDISP_FIFO 	                "/tmp/vdisp/command.fifo"
#define VDISP_HOST_NAME             "system_event"
#define CMD_VDISP_SWITCH_MODE       "switch_mode"
#define CMD_VDISP_START_LIVEVIEW    "start_liveview"
#define CMD_VDISP_STOPKEYPRESSTIMECHECK "stop_keypressCK"  // stop key press time check
#define CMD_VDISP_RESETKEYPRESSTIME "reset_keypress"       // reset key press time
#define CMD_VDISP_SETLANGUAGE       "set_language"
#define CMD_VDISP_START_SELFTIMER   "set_selftimer"
#define CMD_VDISP_START_RTMP		"set_rtmp"
#define CMD_VDISP_STOP_RTMP	    	"stop_rtmp"
#define CMD_VDISP_START_P2P        "set_p2p"
#define CMD_VDISP_STOP_P2P         "stop_p2p"

//----------------------------------------------------------------------------------------------
#define DISK_FOLDER_PATH            "/tmp/vrecord/videoclips/"

#if (defined KENXEN) && ((KENXEN_SDV360T4 == 1) || (KENXEN_SDV360T8 == 1))
#define FOLDER_NAME_ROOT            "."
#define FOLDER_NAME_EVENT           "event"     // event / "."
#define FOLDER_NAME_MOTION          "."         // motion / "."
#define FOLDER_NAME_TIME_LAPSE      "."         // time_lapse / "."
#define FOLDER_NAME_PARKING         "."         // parking / "."
#define FOLDER_NAME_SNAPSHOTS       "IMG"       // snapshots / "."
#define FOLDER_NAME_THUMBNAIL       "."         // thumbnail / "."
#else
#define FOLDER_NAME_ROOT            "."
#define FOLDER_NAME_EVENT           "."         // event / "."
#define FOLDER_NAME_MOTION          "."         // motion / "."
#define FOLDER_NAME_TIME_LAPSE      "."         // time_lapse / "."
#define FOLDER_NAME_PARKING         "."         // parking / "."
#define FOLDER_NAME_SNAPSHOTS       "IMG"       // snapshots / "."
#define FOLDER_NAME_THUMBNAIL       "."         // thumbnail / "."
#endif

#define NORMAL_VIDRO_PREFIX         ""
#define EVENT_VIDEO_PREFIX          ""
#define MOTION_VIDEO_PREFIX         ""
#define TIME_LAPSE_VIDEO_PROEFIX    ""
#define PARKING_VIDEO_PREFIX        ""
#define SNAPSHOT_PREFIX             "IMG_"
#define THUMBNAIL_PREFIX            "thumbnail_"


#define MAX_PATH                  256
//----------------------------------------------------------------------------------------------
#define YYMMDDHHMMSS_TIMESTAMP_FORMAT   "%Y/%m/%d %H:%M:%S"
#define MMDDYYHHMMSS_TIMESTAMP_FORMAT   "%m/%d/%Y %H:%M:%S"
#define DDMMYYHHMMSS_TIMESTAMP_FORMAT   "%d/%m/%Y %H:%M:%S"

#define YYMMDD_TIMESTAMP_FORMAT         "%Y/%m/%d"
#define MMDDYY_TIMESTAMP_FORMAT         "%m/%d/%Y"
#define DDMMYY_TIMESTAMP_FORMAT         "%d/%m/%Y"

#define DEFAULT_RECORDTIME_STRING		"00:00:00"
#define DEFAULT_TIMESTAMP_STRING		"2015/06/11 02:00:00"
#define DEFAULT_TIMESTAMP_STRING2 		"2016-07-01"
#define DEFAULT_FILENAME_FORMAT_STRING  "%Y%m%d_%H%M%S"
#define DEFAULT_FILENAME_STRING			"20150714_060000"
//----------------------------------------------------------------------------------------------
#define MENU_ITEM_WIDTH           64
#define MENU_ITEM_HEIGHT          48
#define TV_MENU_ITEM_WIDTH       128
#define TV_MENU_ITEM_HEIGHT       96
#define HDMI_MENU_ITEM_WIDTH     320
#define HDMI_MENU_ITEM_HEIGHT    240
//----------------------------------------------------------------------------------------------
#define NULL_COLOR                {  0,   0,   0}
#define BLACK_COLOR               {  0, 128, 128}
#define WHITE_COLOR               {255, 128, 128}
#define GRAY_COLOR                {128, 128, 128}
#define RED_COLOR                 { 76,  84, 255}
#define BLUE_COLOR                { 36, 255, 107}
#define AZURE_RADIANCE_COLOR      {110, 214,  54}
#define LIGHTGRAY_COLOR           {200, 128, 128}
#define BRIGHT_NEON_CYAN_COLOR    {237, 139, 95}
#define BRIGHT_NEON_YELLOW_COLOR  {214,  79, 155}
#define CINNABAR_COLOR			  {122,  84, 213}
#define DARKBLUE_COLOR            { 71, 235, 122} 
#define LIGHTBLUE_COLOR           {135, 199,  61}
#define SUNFLOWER_COLOR			  {190,  40, 157}
#define VIDALOCA_COLOR            {128,  70, 108} 
#define MAUVE_COLOR               {202, 161, 150}
#define TANGERINE_COLOR           {158,  38, 196}
#define RIPTIDE_COLOR             {201, 127,  73}
#define NavyBlue                  { 18, 193, 117}


//#define VR_MAINMENU_BGCOLOR       BRIGHT_NEON_CYAN_COLOR
//#define VR_SUBMENU_BGCOLOR        BRIGHT_NEON_YELLOW_COLOR
//#define SS_MAINMENU_BGCOLOR       SUNFLOWER_COLOR
//#define SS_SUBMENU_BGCOLOR        VIDALOCA_COLOR
//#define PP_MAINMENU_BGCOLOR       CINNABAR_COLOR
//#define PP_SUBMENU_BGCOLOR        DARKBLUE_COLOR
//#define SP_MAINMENU_BGCOLOR       MAUVE_COLOR
//#define SP_SUBMENU_BGCOLOR        TANGERINE_COLOR
//#define MESSAGE_BGCOLOR           GRAY_COLOR
//#define MESSAGE_BGCOLOR_OUTLINE   BRIGHT_NEON_CYAN_COLOR

#define FU_MAINMENU_BGCOLOR       BLUE_COLOR
#define FU_SUBMENU_BGCOLOR        NavyBlue
#define VR_MAINMENU_BGCOLOR       BLUE_COLOR
#define VR_SUBMENU_BGCOLOR        NavyBlue
#define SS_MAINMENU_BGCOLOR       BLUE_COLOR
#define SS_SUBMENU_BGCOLOR        NavyBlue
#define PP_MAINMENU_BGCOLOR       BLUE_COLOR
#define PP_SUBMENU_BGCOLOR        NavyBlue
#define SP_MAINMENU_BGCOLOR       BLUE_COLOR
#define SP_SUBMENU_BGCOLOR        NavyBlue
#define MESSAGE_BGCOLOR           GRAY_COLOR
#define MESSAGE_BGCOLOR_OUTLINE   BRIGHT_NEON_CYAN_COLOR

//----------------------------------------------------------------------------------------------
#define SNAPSHOT_QUALITY_NORMAL    70
#define SNAPSHOT_QUALITY_GOOD      50
#define SNAPSHOT_QUALITY_EXCELLENT 30
//----------------------------------------------------------------------------------------------
#define SNAPSHOT_RESOLUTION_12M    12
#define SNAPSHOT_RESOLUTION_8M   	8
#define SNAPSHOT_RESOLUTION_5M		5
#define SNAPSHOT_RESOLUTION_3M		3
//----------------------------------------------------------------------------------------------
#define THUMBNAIL_MAX_WIDTH	      200  // can not as same as panel resolution
#define THUMBNAIL_MAX_HEIGHT	  150
//----------------------------------------------------------------------------------------------
#define EXFAT_SUPER_MAGIC   (0x2011BAB0L)
//----------------------------------------------------------------------------------------------
enum KeyIDEnum
{
	KEYID_NONE = -1,
	KEYID_MODE = 0,
	KEYID_MENU,
	KEYID_OK,
	KEYID_OK_LONG,
	KEYID_UP,
	KEYID_DOWN,
	KEYID_POWEROFF,
	KEYID_WIFI,
	KEYID_RTMP,
	KEYID_P2P,
};
//----------------------------------------------------------------------------------------------
enum TWINKLE_MODE
{
    TWINKLE_OFF,
    TWINKLE_NORMAL,
};
//----------------------------------------------------------------------------------------------
enum CurSystemMode
{
	CSM_NORM_RECORD = 0,
	CSM_TIMELAPSE_RECORD,
	CSM_NORM_SNAPSHOT,
	CSM_TIMER_SNAPSHOT,
};
//----------------------------------------------------------------------------------------------
enum SRBTypeEnum
{
	SRB_TYPE_SRC = 0,
	SRB_TYPE_RTSP,
	SRB_TYPE_VIDEO_GRAB, 
	SRB_TYPE_RTMP,
	SRB_TYPE_UVC,
};
//----------------------------------------------------------------------------------------------
enum RTMPPlatform
{
	RTMP_NONE = 0,
	RTMP_YOUTUBE,
	RTMP_EASYLIVE,
	RTMP_FACEBOOK,
	RTMP_QINIU,
	RTMP_USER,
	RTMP_MAX
};
//----------------------------------------------------------------------------------------------
enum SupportFishModeType
{
	SUP_FEC_OFF 				= (1<<0),
	SUP_FEC_P360_ALL 			= (1<<1),
	SUP_FEC_P360_ALL_YOUTUBE 	= (1<<2),
	SUP_FEC_P360_SEPURATED		= (1<<3),
	SUP_FEC_P360_HALF			= (1<<4),
	SUP_FEC_P180_ALL			= (1<<5),
	SUP_FEC_P180_ONE			= (1<<6),
	SUP_FEC_P180_TWO			= (1<<7),
	SUP_FEC_3_IN_1				= (1<<8),
	SUP_FEC_4_IN_1				= (1<<9),
	SUP_FEC_1R					= (1<<10),
	SUP_FEC_1O					= (1<<11),
	SUP_FEC_P360_VR720			= (1<<12),
	SUP_FEC_P180_FRONT			= (1<<13),
	SUP_FEC_P180_BACK			= (1<<14),
#if defined(KENXEN)
	SUP_FEC_CAR_MODE			= (1<<15),
#endif
};
//----------------------------------------------------------------------------------------------
enum WIFI_MODE
{
	WIFI_MODE_NONE = 0,
    WIFI_MODE_ADHOC,
    WIFI_MODE_STATION,
};
//----------------------------------------------------------------------------------------------
typedef enum CARD_STATUS
{
    CARD_OK = 0,
    CARD_ERROR_CARD_NONEXISTENT,
    CARD_ERROR_CARD_FULL,
    CARD_ERROR_NOT_WORK,
    CARD_ERROR_INITIAL,
}CARD_STATUS;
//----------------------------------------------------------------------------------------------
typedef enum FOLDAR_STATUS
{
    FOLDER_ERROR_OTHER = 0,
    FOLDER_ERROR_FOLDER_NONEXISTENT,
    FOLDER_ERROR_FOLDER_FULL,
    FOLDER_OK
}FOLDAR_STATUS;
//----------------------------------------------------------------------------------------------

#endif
