#include <common.h>
#include <command.h>
#include <config.h>
#include <asm/arch/platform.h>

#define ACDCC_VERSION                          0x00
#define ACDCC_CTRL                             0x04
#define ACDCC_RESET                            0x14
#define ACDCC_LATCH                            0x18
#define ACDCC_CLK_SEL0                         0x1C
#define ACDCC_CLK_SEL1                         0x20
#define ACDCC_I2S_CONFIG0                      0x24
#define ACDCC_I2S_CONFIG1                      0x28
#define ACDCC_I2S_CONFIG2                      0x2C
#define ACDCC_PWR_MANAGEMENT                   0x30 
#define ACDCC_PWR_CTRL0                        0x34
#define ACDCC_PWR_CTRL1                        0x38
#define ACDCC_PWR_CTRL3                        0x40
#define ACDCC_MUTE_CTRL0                       0x48 
#define ACDCC_MUTE_CTRL1                       0x4C
#define ACDCC_RECORD_VOL                       0x54
#define ACDCC_PGA_VOL                          0x5C
#define ACDCC_PLAYBACK_VOL                     0x64 
#define ACDCC_RECORD_INPUT_SEL                 0x6C 
#define ACDCC_PLAYBACK_MIXER_CTRL              0x78 
#define ACDCC_ALC_CTRL0                        0x80 
#define ACDCC_ALC_CTRL1                        0x84
#define ACDCC_ALC_CTRL2                        0x88
#define ACDCC_ALC_RMAP_DOWN_CTRL               0x8C
#define ACDCC_ALC_RMAP_UP_CTRL                 0x90 
#define ACDCC_ALC_MAX_AUTO_GAIN                0x94 
#define ACDCC_DIGITAL_NOISE_GATE               0x98 
#define ACDCC_DIGITAL_TEST                     0x9C 
#define ACDCC_ADC_HIGH_PASS_MIXER              0xA0 
#define ACDCC_DAC_MIXER                        0xA4 
#define ACDCC_SOFT_RAMPING                     0xA8 
#define ACDCC_DIGITAL_ASS_TEST1                0xB4 
#define ACDCC_DIGITAL_ASS_TEST2                0xB8 
#define ACDCC_DIGITAL_ASS_TEST3                0xBC
#define ACDCC_DIGITAL_ASS_TEST4                0xC0
#define ACDCC_DIGITAL_ASS_TEST5                0xC4 
#define ACDCC_PURE_ANALOG_TEST0                0xC8 
#define ACDCC_PURE_ANALOG_TEST1                0xCC 
#define ACDCC_PURE_ANALOG_TEST2                0xD0 
#define ACDCC_PURE_ANALOG_TEST3                0xD4 

#define dwc_base VPL_ACDCC_MMR_BASE
#define VATICS_ADCC_WRITEL(reg, val) 	       v_outl(reg, val)

DECLARE_GLOBAL_DATA_PTR;

void init_i2s(int enable)
{
	unsigned long reg;
	// enable i2s clock
	reg  = v_inl(VPL_SYSC_MMR_BASE + 0x94) ;
	reg |= 0x1 <<24;
	v_outl(VPL_SYSC_MMR_BASE + 0x94, reg);

	v_outl(I2S_RX + I2S_MMR_IER,  0) ;
	v_outl(I2S_RX + I2S_MMR_IRER, 0) ;
	v_outl(I2S_RX + I2S_MMR_ITER, 0) ;

	v_outl(I2S_RX + I2S_MMR_IMR, 0x0) ;

	//1. set FIFO threshold & flush FIFO
	v_outl(I2S_RX + I2S_MMR_RFCR, 0x3) ;
	v_outl(I2S_RX + I2S_MMR_TFCR, 0x3) ;
	v_outl(I2S_RX + I2S_MMR_RFF0, 0x1) ;
	v_outl(I2S_RX + I2S_MMR_TFF0, 0x1) ;

	//2. set Data width
	v_outl(I2S_RX + I2S_MMR_RCR0, 0x2) ;
	v_outl(I2S_RX + I2S_MMR_TCR0, 0x2) ; 


	v_outl(I2S_TX + I2S_MMR_IER,  0) ;
	v_outl(I2S_TX + I2S_MMR_IRER, 0) ;
	v_outl(I2S_TX + I2S_MMR_ITER, 0) ;

	v_outl(I2S_TX + I2S_MMR_IMR, 0x0) ;

	//1. set FIFO threshold & flush FIFO
	v_outl(I2S_TX + I2S_MMR_RFCR, 0x3) ;
	v_outl(I2S_TX + I2S_MMR_TFCR, 0x3) ;
	v_outl(I2S_TX + I2S_MMR_RFF0, 0x1) ;
	v_outl(I2S_TX + I2S_MMR_TFF0, 0x1) ;

	//2. set Data width
	v_outl(I2S_TX + I2S_MMR_RCR0, 0x2) ;
	v_outl(I2S_TX + I2S_MMR_TCR0, 0x2) ; 


	//4. enable blocks/channels/module
	v_outl(I2S_RX + I2S_MMR_IER,  1) ;
	v_outl(I2S_RX + I2S_MMR_IRER, 1) ;

	v_outl(I2S_TX + I2S_MMR_IER,  1) ;
	v_outl(I2S_TX + I2S_MMR_ITER, 1) ;
}

inline void do_latch(void)
{
        udelay(1000);
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_LATCH, 0x1);
        udelay(1000);
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_LATCH, 0x0);

}

inline void dwc_data_path_reset(void)
{
	/* reset data path */
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RESET, 0x0); // set low
	do_latch();
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RESET, 0x3); // set high
	do_latch();
}

void codec_init(void)
{
	unsigned int reg;

	// enable adc clock
	reg  = v_inl(VPL_SYSC_MMR_BASE + 0x94) ;
	reg |= 0x1;
	v_outl(VPL_SYSC_MMR_BASE + 0x94, reg);

	// master reset
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x0);
	// need delay here?
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x1);

	// soft reset
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_CTRL, 0x3);
	// need delay here?
	
	// pdz0
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x0); //R21
	do_latch();

	// R2 setting mclkadc 12M
	//VATICS_ADCC_WRITEL(dwc_base + ACDCC_CLK_SEL0, 0x2);
        //udelay(1000);
	// R3 setting mclkdac 12M
	//VATICS_ADCC_WRITEL(dwc_base + ACDCC_CLK_SEL1, 0x2);
	//do_latch();

	// R21 Mic Bias 1 and vcmbuf power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x6);
	// R22 PGA and ADC power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL1, 0x5);
	// R24 PGA and ADC power on
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL3, 0x89);
	do_latch();


	VATICS_ADCC_WRITEL(dwc_base + ACDCC_I2S_CONFIG2, 0x19);// set master mode
	do_latch();
	dwc_data_path_reset();

	/* set pdz to high */
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PWR_CTRL0, 0x5); // power-up all and MicBias1
	do_latch();

	/*set digital playback source*/
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_PLAYBACK_MIXER_CTRL, 0x0);

	/*set input line1p*/
	VATICS_ADCC_WRITEL(dwc_base + ACDCC_RECORD_INPUT_SEL, 0x0);
	do_latch();

}

int dwc_audio_test_func(int input_type)//1 is line-in, other is mic-in.
{   
	unsigned int start = 0;


	if(input_type == 1) {
		printf("  - Test ANALOG-IN for 10 secs...\n") ;
		printf("  - (press ANY KEY to stop the test..)\n") ;        
	} else {
		/*set input line1p*/
		VATICS_ADCC_WRITEL(dwc_base + ACDCC_RECORD_INPUT_SEL, 0x4);
		do_latch();
		printf("  - Test MIC-IN for 10 secs...\n") ;
		printf("  - (press ANY KEY to stop the test..)\n") ;        
	}

	int delay = 10 ;
	//reset_timer() ;
	start = get_timer(0);
	while((get_timer(start)/1000) < delay)
	{
		unsigned long left = v_inl(I2S_RX + I2S_MMR_LRBR0) ;
		unsigned long right =  v_inl(I2S_RX + I2S_MMR_RRBR0) ;
		v_outl(I2S_TX + I2S_MMR_LTHR0, left);
		v_outl(I2S_TX + I2S_MMR_RTHR0, right);
		if(tstc())
		{		   
			(void) getc();  /* consume input	*/
			break;
		}
//		printf("%d\n", get_timer_masked()) ;
	}
	printf("  - STOP!\n") ;

	return 0 ;
}


int audio_test_func(void)
{
	int result = 0 ;

	printf("DWC Audio Codec test..\n") ;
	
	init_i2s(1);
	codec_init();

	result |= dwc_audio_test_func(1) ;
	result |= dwc_audio_test_func(0) ;

	return result ;
}



