#include <common.h>
#include <command.h>
#include <config.h>
#include <spi.h>
#include <spi_flash.h>
#include <asm/arch/platform.h>

#define WDT_REBOOT_MARK           0x96A0BCF2
#define WDT_TEST_DATA_BLOCK_ADDR   144 //addr = 144 * 64KB = 0x00900000(9MB)
#define WDT_ORIGINAL_RELOAD_VALUE 0x5AB9
#define WDT_RELOAD_VALUE          0x300
extern struct spi_flash *spi_flash_probe_vpl(struct spi_slave *spi, u8 *idcode);

int WDTC_quick_test(void) 
{
    unsigned long block_size ;
    struct spi_flash *flash ;
    unsigned long reg ;
	volatile int timeout = 100000 ;
    unsigned long write_data = WDT_REBOOT_MARK ;
    
	flash = spi_flash_probe(CONFIG_SPI_FLASH_BUS, 0, CONFIG_SF_DEFAULT_SPEED,
							CONFIG_DEFAULT_SPI_MODE);
	if (!flash)
	{
		printf("probe failed!\n");
		return -1;
	}

    block_size = SZ_64K;
    
	//read the data
    spi_flash_read(flash, WDT_TEST_DATA_BLOCK_ADDR * block_size, sizeof(write_data), (void *)(unsigned long)(&reg)) ;

	if ( reg == WDT_REBOOT_MARK ) { // this condition should be true after rebooting
		v_outl(EVM_WDTC_BASE + EVM_WDT_CTRL, 0x0 ) ; //disable wdt
	    v_outl(EVM_WDTC_BASE + EVM_WDT_RELOAD_VALUE, WDT_ORIGINAL_RELOAD_VALUE); 
        v_outl(EVM_WDTC_BASE + EVM_WDT_RELOAD_CTRL, WDT_RELOAD_PASSWD );   
        spi_flash_erase(flash, WDT_TEST_DATA_BLOCK_ADDR * block_size, block_size, 1) ;
		printf( "[ WDT ] ......................................... Pass\n" ) ;
	    return 0 ;
	}
	else { // this condition should be true when testing wdt first time
        //unsigned long mark = WDT_REBOOT_MARK;

        spi_flash_erase(flash, WDT_TEST_DATA_BLOCK_ADDR * block_size, block_size, 1) ;
	    spi_flash_write(flash, WDT_TEST_DATA_BLOCK_ADDR * block_size, sizeof(write_data), &write_data, 1) ;

	        //configure the WDT and restart
		v_outl(EVM_WDTC_BASE + EVM_WDT_CTRL, 0x0 ) ;                   
	    v_outl(EVM_WDTC_BASE + EVM_WDT_RELOAD_VALUE, WDT_RELOAD_VALUE ); 
		v_outl(EVM_WDTC_BASE + EVM_WDT_MATCH_VALUE, 0x0 ) ;             
        v_outl(EVM_WDTC_BASE + EVM_WDT_RELOAD_CTRL, WDT_RELOAD_PASSWD ); 
	    v_outl(EVM_WDTC_BASE + EVM_WDT_CTRL, 0x7 );//bit#2 : enable/disable WDTC ; bit#1 : enable/disable match ack(interrupt)

                // waiting wdt to reboot the system.  
        while (timeout >= 0) {
			timeout-- ;
		}
                
		if( timeout < 0 ) {
			v_outl(EVM_WDTC_BASE + EVM_WDT_CTRL, 0x0 ) ; //disable wdt
			spi_flash_erase(flash, WDT_TEST_DATA_BLOCK_ADDR * block_size, block_size, 1) ;
			printf("[ WDT ] ......................................... Fail\n" ) ;
			printf("        -- WDT can not reboot the system\n" ) ;
			printf("        -- in the limited time.\n" ) ;
			return -1 ;
		}
    }

	return 0 ;
}

int wdt_test_func(void)
{
	int result ;
	
	printf( "wdt_test_func!!!\n" ) ;

    result = WDTC_quick_test() ;

	return  result;
}

